/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.network.SynthPacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntitySpeaker
extends TileEntity
implements IPlusPlusPeripheral {
    private ITurtleAccess turtle;
    private TurtleSide side = null;
    private int id;
    private List<IComputerAccess> computers = new ArrayList<IComputerAccess>();
    private Map<UUID, Long> pendingEvents = new HashMap<UUID, Long>();

    public TileEntitySpeaker() {
    }

    public TileEntitySpeaker(ITurtleAccess turtle, TurtleSide side) {
        this();
        this.turtle = turtle;
        this.side = side;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (this.turtle != null) {
            this.func_145834_a(this.turtle.getWorld());
            this.func_174878_a(this.turtle.getPosition());
        }
        if (this.field_145850_b != null) {
            this.id = this.field_145850_b.field_73011_w.getDimension();
        }
        TileEntitySpeaker tileEntitySpeaker = this;
        synchronized (tileEntitySpeaker) {
            for (Map.Entry<UUID, Long> pendingEvent : this.pendingEvents.entrySet()) {
                if (System.currentTimeMillis() - pendingEvent.getValue() <= 30000L) continue;
                this.onSpeechCompletion("", pendingEvent.getKey());
                break;
            }
        }
    }

    public String getType() {
        return "speaker";
    }

    public String[] getMethodNames() {
        return new String[]{"speak", "synthesize"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableSpeaker) {
            throw new LuaException("Speakers have been disabled");
        }
        if (method <= 1) {
            if (arguments.length <= 0 || !(arguments[0] instanceof String)) {
                throw new LuaException("Bad argument #1 (expected string)");
            }
            if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected number)");
            }
            if (arguments.length > 2 && !(arguments[2] instanceof String)) {
                throw new LuaException("Bad argument #3 (expected string)");
            }
            if (arguments.length > 3 && !(arguments[3] instanceof Double)) {
                throw new LuaException("Bad argument #4 (expected number)");
            }
            if (arguments.length > 4 && !(arguments[4] instanceof Double)) {
                throw new LuaException("Bad argument #5 (expected number)");
            }
            if (arguments.length > 5 && !(arguments[5] instanceof Double)) {
                throw new LuaException("Bad argument #6 (expected number)");
            }
            if (arguments.length > 6 && !(arguments[6] instanceof Double)) {
                throw new LuaException("Bad argument #7 (expected number)");
            }
            if (arguments.length > 7 && !(arguments[7] instanceof Double)) {
                throw new LuaException("Bad argument #8 (expected number)");
            }
            if (arguments.length > 8 && !(arguments[8] instanceof Boolean)) {
                throw new LuaException("Bad argument #9 (expected boolean");
            }
            String text = (String)arguments[0];
            double range = Config.speechRange < 0.0 ? Double.MAX_VALUE : Config.speechRange;
            if (arguments.length > 1) {
                range = (Double)arguments[1];
            }
            String voice = arguments.length > 2 ? (String)arguments[2] : "kevin16";
            Float pitch = arguments.length > 3 ? Float.valueOf(((Double)arguments[3]).floatValue()) : null;
            Float pitchRange = arguments.length > 4 ? Float.valueOf(((Double)arguments[4]).floatValue()) : null;
            Float pitchShift = arguments.length > 5 ? Float.valueOf(((Double)arguments[5]).floatValue()) : null;
            Float rate = arguments.length > 6 ? Float.valueOf(((Double)arguments[6]).floatValue()) : null;
            Float volume = arguments.length > 7 ? Float.valueOf(((Double)arguments[7]).floatValue()) : null;
            UUID eventId = null;
            while (eventId == null || this.pendingEvents.containsKey(eventId)) {
                eventId = UUID.randomUUID();
            }
            this.pendingEvents.put(eventId, System.currentTimeMillis());
            PeripheralsPlusPlus.NETWORK.sendToAllAround((IMessage)new SynthPacket(text, voice, pitch, pitchRange, pitchShift, rate, volume, this.func_174877_v(), this.id, this.side, eventId), new NetworkRegistry.TargetPoint(this.id, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), range));
            if (arguments.length > 8 && ((Boolean)arguments[8]).booleanValue()) {
                context.pullEvent("synthComplete");
            }
            return new Object[]{eventId.toString()};
        }
        return new Object[0];
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computers.add(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSpeechCompletion(String text, UUID eventId) {
        TileEntitySpeaker tileEntitySpeaker = this;
        synchronized (tileEntitySpeaker) {
            if (!this.pendingEvents.containsKey(eventId)) {
                return;
            }
            this.pendingEvents.remove(eventId);
        }
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("synthComplete", new Object[]{text, eventId});
        }
    }
}

