/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.tiles.TileEntityInventory;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.lua.LuaObjectPlayerInv;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TileEntityPlayerInterface
extends TileEntityInventory
implements IPlusPlusPeripheral {
    public EnumFacing outputSide;
    public EnumFacing inputSide;

    public TileEntityPlayerInterface() {
        this.invName = "PlayerInterface";
    }

    public int getSize() {
        return 8;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (Config.enablePlayerInterface) {
            if (method == 0) {
                if (arguments.length != 1) {
                    throw new LuaException("Wrong number of arguments. 1 expected.");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                for (WorldServer worldServer : DimensionManager.getWorlds()) {
                    for (EntityPlayer player : worldServer.field_73010_i) {
                        if (!player.getDisplayNameString().equals(arguments[0])) continue;
                        if (this.hasPermissionsCardFor(player) || !Config.enableInterfacePermissions) {
                            return new Object[]{new LuaObjectPlayerInv(player, this, this.getPermCardFor(player))};
                        }
                        throw new LuaException("Missing permissions for player " + arguments[0]);
                    }
                }
                throw new LuaException("Player not found");
            }
            if (method == 1 || method == 2) {
                if (arguments.length != 1) {
                    throw new LuaException("Wrong number of arguments. 1 expected.");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                if (method == 1) {
                    this.outputSide = EnumFacing.valueOf((String)((String)arguments[0]).toUpperCase());
                } else {
                    this.inputSide = EnumFacing.valueOf((String)((String)arguments[0]).toUpperCase());
                }
            } else {
                if (method == 3) {
                    if (this.outputSide == null) {
                        return new Object[0];
                    }
                    return new Object[]{this.outputSide.toString()};
                }
                if (method == 4) {
                    if (this.inputSide == null) {
                        return new Object[0];
                    }
                    return new Object[]{this.inputSide.toString()};
                }
            }
        } else {
            throw new LuaException("Player Interfaces have been disabled");
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public String[] getMethodNames() {
        return new String[]{"getPlayerInv", "setOutputSide", "setInputSide", "getOutputSide", "getInputSide"};
    }

    public String getType() {
        return "playerInterface";
    }

    private boolean hasPermissionsCardFor(EntityPlayer player) {
        return !this.getPermCardFor(player).func_190926_b();
    }

    private ItemStack getPermCardFor(EntityPlayer player) {
        for (ItemStack stack : this.items) {
            if (stack == null || !stack.func_77942_o()) continue;
            GameProfile profile = NBTUtil.func_152459_a((NBTTagCompound)NBTHelper.getCompoundTag((ItemStack)stack, (String)"profile"));
            if (profile == null) {
                return ItemStack.field_190927_a;
            }
            UUID uuid = profile.getId();
            if (!uuid.equals(player.func_146103_bH().getId())) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

