/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.tiles.NetworkedTileEntity;
import com.austinv11.collectiveframework.minecraft.utils.Colors;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.lua.LuaObjectPeripheralWrap;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.peripheralcontainer.ContainedPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class TileEntityPeripheralContainer
extends NetworkedTileEntity
implements ITickable,
IPlusPlusPeripheral {
    private List<ContainedPeripheral> peripheralsContained = new ArrayList<ContainedPeripheral>();
    private boolean needsUpdate = false;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("peripherals")) {
            NBTBase peripheralsBase = nbttagcompound.func_74781_a("peripherals");
            if (!(peripheralsBase instanceof NBTTagList)) {
                return;
            }
            NBTTagList peripherals = (NBTTagList)peripheralsBase;
            for (NBTBase peripheralBase : peripherals) {
                if (!(peripheralBase instanceof NBTTagCompound)) continue;
                this.addPeripheral(new ContainedPeripheral((NBTTagCompound)peripheralBase));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagList peripherals = new NBTTagList();
        for (ContainedPeripheral peripheral : this.peripheralsContained) {
            peripherals.func_74742_a((NBTBase)peripheral.toNbt());
        }
        nbttagcompound.func_74782_a("peripherals", (NBTBase)peripherals);
        return nbttagcompound;
    }

    public String getType() {
        return "peripheralContainer";
    }

    public String[] getMethodNames() {
        return new String[]{"getContainedPeripherals", "wrapPeripheral"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enablePeripheralContainer) {
            throw new LuaException("Peripheral Containers have been disabled");
        }
        if (method == 0) {
            HashMap<Integer, String> returnVals = new HashMap<Integer, String>();
            for (int i = 0; i < this.peripheralsContained.size(); ++i) {
                returnVals.put(i + 1, this.peripheralsContained.get(i).getPeripheral().getType());
            }
            return new Object[]{returnVals};
        }
        if (method == 1) {
            if (arguments.length < 1) {
                throw new LuaException("Too few arguments");
            }
            if (!(arguments[0] instanceof String)) {
                throw new LuaException("Bad argument #1 (expected string)");
            }
            return new Object[]{new LuaObjectPeripheralWrap(this.getPeripheralByName((String)arguments[0]), computer)};
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void func_73660_a() {
        for (ContainedPeripheral peripheral : this.peripheralsContained) {
            if (!(peripheral.getPeripheral() instanceof ITickable)) continue;
            ((ITickable)peripheral.getPeripheral()).func_73660_a();
            if (!this.needsUpdate) continue;
            this.field_145850_b.markAndNotifyBlock(this.func_174877_v(), this.field_145850_b.func_175726_f(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            if (!(peripheral.getPeripheral() instanceof TileEntity)) continue;
            ((TileEntity)peripheral.getPeripheral()).func_145834_a(this.field_145850_b);
            ((TileEntity)peripheral.getPeripheral()).func_174878_a(this.func_174877_v());
        }
    }

    public void addPeripheral(ContainedPeripheral peripheral) {
        if (peripheral.getPeripheral() == null) {
            return;
        }
        this.peripheralsContained.add(peripheral);
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.markAndNotifyBlock(this.func_174877_v(), this.field_145850_b.func_175726_f(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            if (peripheral.getPeripheral() instanceof TileEntity) {
                ((TileEntity)peripheral.getPeripheral()).func_145834_a(this.field_145850_b);
                ((TileEntity)peripheral.getPeripheral()).func_174878_a(this.func_174877_v());
            }
        } else {
            this.needsUpdate = true;
        }
    }

    private IPeripheral getPeripheralByName(String name) {
        for (ContainedPeripheral peripheral : this.peripheralsContained) {
            if (!peripheral.getPeripheral().getType().equals(name)) continue;
            return peripheral.getPeripheral();
        }
        return null;
    }

    @Override
    public void attach(IComputerAccess computer) {
        for (ContainedPeripheral peripheral : this.peripheralsContained) {
            peripheral.getPeripheral().attach(computer);
        }
    }

    @Override
    public void detach(IComputerAccess computer) {
        for (ContainedPeripheral peripheral : this.peripheralsContained) {
            peripheral.getPeripheral().detach(computer);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack container = new ItemStack((Block)ModBlocks.PERIPHERAL_CONTAINER);
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        container.func_77982_d(tag);
        ArrayList<String> text = new ArrayList<String>();
        text.add(Colors.RESET.toString() + Colors.UNDERLINE + "Contained Peripherals:");
        for (ContainedPeripheral peripheral : this.peripheralsContained) {
            text.add(Colors.RESET + peripheral.getBlockResourceLocation().toString());
        }
        NBTHelper.addInfo((ItemStack)container, text);
        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), container.func_77946_l()));
    }
}

