/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.init.ModItems;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.OpenComputersPeripheral;
import com.austinv11.peripheralsplusplus.utils.OpenComputersUtil;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Node;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Optional;

public class TileEntityMagReaderWriter
extends TileEntity
implements IPlusPlusPeripheral,
OpenComputersPeripheral {
    private static final int MAX_TRACKS = 3;
    private static final String MAG_TAG = String.format("%s:%s", "peripheralsplusone", "mag_card");
    private String[] buffers = new String[3];
    private List<IComputerAccess> computers = new ArrayList<IComputerAccess>();
    private Node node = OpenComputersUtil.createNode(this, this.getType());

    @Nonnull
    public String getType() {
        return "mag_reader_writer";
    }

    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"write", "clear"};
    }

    @Nullable
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return this.writeLua(arguments);
            }
            case 1: {
                return this.clearLua(arguments);
            }
        }
        throw new LuaException("Unexpected error");
    }

    private Object[] clearLua(Object[] arguments) throws LuaException {
        if (arguments.length < 1) {
            this.buffers = new String[3];
            return new Object[0];
        }
        int trackIndex = this.parseTrackIndex(arguments[0], "First");
        this.buffers[trackIndex] = null;
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] writeLua(Object[] arguments) throws LuaException {
        if (arguments.length < 2) {
            throw new LuaException("Not enough arguments");
        }
        int trackIndex = this.parseTrackIndex(arguments[0], "First");
        if (!(arguments[1] instanceof String)) {
            throw new LuaException("Second argument expected to be a string");
        }
        if (!this.isBufferValid(trackIndex, (String)arguments[1])) {
            throw new LuaException("Buffer data is invalid for track");
        }
        TileEntityMagReaderWriter tileEntityMagReaderWriter = this;
        synchronized (tileEntityMagReaderWriter) {
            this.buffers[trackIndex] = (String)arguments[1];
        }
        return new Object[0];
    }

    private boolean isBufferValid(int trackIndex, String buffer) {
        switch (trackIndex) {
            case 0: {
                return buffer.length() <= 79 && buffer.matches("[A-Za-z0-9%^?;=]*");
            }
            case 1: {
                return buffer.length() <= 40 && buffer.matches("[0-9%^?;=]*");
            }
            case 2: {
                return buffer.length() <= 107 && buffer.matches("[0-9%^?;=]*");
            }
        }
        return false;
    }

    private int parseTrackIndex(Object argument, String position) throws LuaException {
        if (!(argument instanceof Double)) {
            throw new LuaException(String.format("%s argument expected to be an integer", position));
        }
        int trackIndex = ((Double)argument).intValue();
        if (trackIndex >= 3 || trackIndex < 0) {
            throw new LuaException(String.format("Track index out of bounds: %d", trackIndex));
        }
        return trackIndex;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    @Optional.Method(modid="opencomputers|core")
    public String[] methods() {
        return this.getMethodNames();
    }

    @Optional.Method(modid="opencomputers|core")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "write": {
                return this.writeLua(args.toArray());
            }
            case "clear": {
                return this.clearLua(args.toArray());
            }
        }
        throw new NoSuchMethodException(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemSwipped(ItemStack swipedItem) {
        if (!this.isMagCard(swipedItem)) {
            return;
        }
        NBTTagCompound itemTag = swipedItem.func_77978_p();
        assert (itemTag != null);
        NBTTagCompound magTag = itemTag.func_74775_l(MAG_TAG);
        TileEntityMagReaderWriter tileEntityMagReaderWriter = this;
        synchronized (tileEntityMagReaderWriter) {
            for (int bufferIndex = 0; bufferIndex < this.buffers.length; ++bufferIndex) {
                if (this.buffers[bufferIndex] == null) continue;
                magTag.func_74778_a(String.valueOf(bufferIndex), this.buffers[bufferIndex]);
            }
        }
        itemTag.func_74782_a(MAG_TAG, (NBTBase)magTag);
        swipedItem.func_77982_d(itemTag);
        Object[] event = new Object[]{magTag.func_74779_i("0"), magTag.func_74779_i("1"), magTag.func_74779_i("2")};
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("mag_swipe", event);
        }
        OpenComputersUtil.sendToReachable(this.node, "mag_swipe", event);
    }

    private boolean isMagCard(ItemStack swipedItem) {
        return swipedItem.func_77969_a(new ItemStack(ModItems.PLASTIC_CARD)) && swipedItem.func_77978_p() != null && swipedItem.func_77978_p().func_74764_b(MAG_TAG) && swipedItem.func_190916_E() == 1;
    }

    @Override
    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    @Override
    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public static ItemStack createMagCard() {
        ItemStack magCard = new ItemStack(ModItems.PLASTIC_CARD);
        NBTTagCompound magTag = new NBTTagCompound();
        magTag.func_74778_a("0", "");
        magTag.func_74778_a("1", "");
        magTag.func_74778_a("2", "");
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(MAG_TAG, (NBTBase)magTag);
        magCard.func_77982_d(tag);
        magCard.func_190924_f("item.peripheralsplusone:plastic_card.name_mag");
        return magCard;
    }

    @Optional.Method(modid="opencomputers|core")
    public Node node() {
        return this.node;
    }

    public void func_73660_a() {
        OpenComputersUtil.updateNode(this, this.node);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        OpenComputersUtil.removeNode(this.node);
    }

    public void func_145843_s() {
        super.func_145843_s();
        OpenComputersUtil.removeNode(this.node);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        OpenComputersUtil.readFromNbt(compound, this.node);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        OpenComputersUtil.writeToNbt(compound, this.node);
        return compound;
    }
}

