/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.items.ItemSmartHelmet;
import com.austinv11.peripheralsplusplus.lua.LuaObjectEntityControl;
import com.austinv11.peripheralsplusplus.lua.LuaObjectHUD;
import com.austinv11.peripheralsplusplus.network.ScaleRequestPacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.Util;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityAntenna
extends TileEntity
implements ITickable,
IPlusPlusPeripheral {
    private int dimension = 0;
    public HashMap<IComputerAccess, Boolean> computers = new HashMap();
    private HashMap<Integer, LuaObjectHUD> huds = new HashMap();
    public static final HashMap<UUID, TileEntityAntenna> ANTENNA_REGISTRY = new HashMap();
    public UUID identifier;
    public String label;
    private volatile List<Entity> associatedEntities = new ArrayList<Entity>();

    public TileEntityAntenna() {
        this.identifier = UUID.randomUUID();
        while (ANTENNA_REGISTRY.containsKey(this.identifier) && !ANTENNA_REGISTRY.get(this.identifier).equals(this)) {
            this.identifier = UUID.randomUUID();
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("identifier")) {
            this.identifier = UUID.fromString(nbttagcompound.func_74779_i("identifier"));
        }
        if (nbttagcompound.func_74764_b("label")) {
            this.label = nbttagcompound.func_74779_i("label");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74778_a("identifier", this.identifier.toString());
        if (this.label != null) {
            nbttagcompound.func_74778_a("label", this.label);
        }
        return nbttagcompound;
    }

    public String getType() {
        return "antenna";
    }

    public String[] getMethodNames() {
        return new String[]{"getPlayers", "getHUD", "setLabel", "getLabel", "getInfectedEntities", "getInfectedEntity"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableSmartHelmet && method < 6) {
            throw new LuaException("Smart Helmets have been disabled");
        }
        if (!Config.enableNanoBots) {
            throw new LuaException("Nano bots have been disabled");
        }
        switch (method) {
            case 0: {
                TileEntityAntenna tileEntityAntenna = this;
                synchronized (tileEntityAntenna) {
                    ArrayList<String> playerNames = new ArrayList<String>();
                    List<EntityPlayer> players = TileEntityAntenna.getPlayersWearingSmartHelmets();
                    for (EntityPlayer player : players) {
                        Iterable armor = player.func_184193_aE();
                        for (ItemStack itemStack : armor) {
                            if (!(itemStack.func_77973_b() instanceof ItemSmartHelmet) || !NBTHelper.hasTag((ItemStack)itemStack, (String)"identifier") || !this.identifier.equals(UUID.fromString(NBTHelper.getString((ItemStack)itemStack, (String)"identifier")))) continue;
                            playerNames.add(player.getDisplayNameString());
                        }
                    }
                    return new Object[]{Util.arrayToMap(playerNames.toArray())};
                }
            }
            case 1: {
                TileEntityAntenna tileEntityAntenna = this;
                synchronized (tileEntityAntenna) {
                    if (arguments.length < 1) {
                        throw new LuaException("Not enough arguments");
                    }
                    if (!(arguments[0] instanceof String)) {
                        throw new LuaException("Bad argument #1 (expected string)");
                    }
                    if (Util.getPlayer((String)arguments[0]) == null) {
                        return new Object[]{null};
                    }
                    LuaObjectHUD obj = new LuaObjectHUD((String)arguments[0], this.identifier);
                    this.huds.put(computer.getID(), obj);
                    PeripheralsPlusPlus.NETWORK.sendTo((IMessage)new ScaleRequestPacket(this, computer.getID(), this.dimension), (EntityPlayerMP)Util.getPlayer((String)arguments[0]));
                    context.pullEvent("resolution");
                    return new Object[]{obj};
                }
            }
            case 2: {
                TileEntityAntenna tileEntityAntenna = this;
                synchronized (tileEntityAntenna) {
                    if (arguments.length != 1) {
                        throw new LuaException("Incorrect Arguments!");
                    }
                    this.setLabel(arguments[0].toString());
                }
            }
            case 3: {
                TileEntityAntenna tileEntityAntenna = this;
                synchronized (tileEntityAntenna) {
                    return new Object[]{this.getLabel()};
                }
            }
            case 4: {
                HashMap<Integer, String> entities = new HashMap<Integer, String>();
                for (int i = 0; i < this.associatedEntities.size(); ++i) {
                    entities.put(i + 1, this.associatedEntities.get(i).getPersistentID().toString());
                }
                return new Object[]{entities};
            }
            case 5: {
                if (arguments.length < 1) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                Entity ent = this.entityFromId((String)arguments[0]);
                if (ent != null) {
                    return new Object[]{new LuaObjectEntityControl(this.identifier, ent)};
                }
                throw new LuaException("Entity with id " + arguments[0] + " not found");
            }
        }
        return new Object[0];
    }

    public static List<EntityPlayer> getPlayersWearingSmartHelmets() {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (WorldServer worldServer : DimensionManager.getWorlds()) {
            if (worldServer.func_73046_m() == null) continue;
            for (EntityPlayer player : worldServer.field_73010_i) {
                Iterable armor = player.func_184193_aE();
                for (ItemStack itemStack : armor) {
                    if (!(itemStack.func_77973_b() instanceof ItemSmartHelmet)) continue;
                    players.add(player);
                }
            }
        }
        return players;
    }

    private Entity entityFromId(String id) {
        for (Entity entity : this.associatedEntities) {
            if (!entity.getPersistentID().toString().equals(id)) continue;
            return entity;
        }
        return null;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            this.dimension = this.field_145850_b.field_73011_w.getDimension();
            if (!ANTENNA_REGISTRY.containsKey(this.identifier)) {
                ANTENNA_REGISTRY.put(this.identifier, this);
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        ANTENNA_REGISTRY.remove(this.identifier);
    }

    public void func_145829_t() {
        super.func_145829_t();
        ANTENNA_REGISTRY.put(this.identifier, this);
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computers.put(computer, true);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void onResponse(int id, int width, int height) {
        if (this.huds.containsKey(id)) {
            this.huds.get((Object)Integer.valueOf((int)id)).height = height;
            this.huds.get((Object)Integer.valueOf((int)id)).width = width;
            for (IComputerAccess comp : this.computers.keySet()) {
                if (comp.getID() != id) continue;
                comp.queueEvent("resolution", new Object[]{height, width});
            }
        }
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public void registerEntity(Entity entity) {
        for (Entity containedEntity : this.associatedEntities) {
            if (!containedEntity.getPersistentID().equals(entity.getPersistentID())) continue;
            this.associatedEntities.remove(containedEntity);
            break;
        }
        this.associatedEntities.add(entity);
    }

    public boolean isEntityRegistered(Entity entity) {
        return this.associatedEntities.contains(entity);
    }

    public void removeEntity(Entity entity) {
        this.associatedEntities.remove(entity);
    }
}

