/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.recipe;

import com.austinv11.collectiveframework.minecraft.utils.Colors;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.blocks.BlockPeripheralContainer;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.peripheralcontainer.ContainedPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeContainer
implements IRecipe {
    private final ResourceLocation group;
    private ResourceLocation name;

    public RecipeContainer(ResourceLocation group) {
        this.group = group;
    }

    public boolean func_77569_a(InventoryCrafting craftingInventory, World world) {
        ItemStack container = this.getPeripheralContainer(craftingInventory);
        if (container.func_190926_b()) {
            return false;
        }
        List<ContainedPeripheral> peripherals = this.getPeripherals(craftingInventory);
        if (peripherals.size() == 0) {
            return false;
        }
        int items = 0;
        for (int itemStack = 0; itemStack < craftingInventory.func_70302_i_(); ++itemStack) {
            if (craftingInventory.func_70301_a(itemStack).func_190926_b()) continue;
            ++items;
        }
        if (items != peripherals.size() + 1) {
            return false;
        }
        NBTTagList contained = this.getContainedPeripherals(container);
        return contained.func_74745_c() + peripherals.size() <= Config.maxNumberOfPeripherals;
    }

    private NBTTagList getContainedPeripherals(ItemStack container) {
        NBTTagList tagList = new NBTTagList();
        if (container.func_77978_p() != null && container.func_77978_p().func_74764_b(ModBlocks.PERIPHERAL_CONTAINER.getRegistryName().toString())) {
            NBTBase idTag = container.func_77978_p().func_74781_a(ModBlocks.PERIPHERAL_CONTAINER.getRegistryName().toString());
            if (!(idTag instanceof NBTTagList)) {
                return tagList;
            }
            return (NBTTagList)idTag;
        }
        return tagList;
    }

    private ItemStack getPeripheralContainer(InventoryCrafting inventory) {
        ItemStack returnStack = ItemStack.field_190927_a;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack itemStack = inventory.func_70301_a(slot).func_77946_l();
            if (!(Block.func_149634_a((Item)itemStack.func_77973_b()) instanceof BlockPeripheralContainer)) continue;
            if (itemStack.func_190916_E() != 1 || !returnStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            returnStack = itemStack.func_77946_l();
        }
        return returnStack;
    }

    public ItemStack func_77572_b(InventoryCrafting craftingInventory) {
        ItemStack container = this.getPeripheralContainer(craftingInventory);
        List<ContainedPeripheral> peripherals = this.getPeripherals(craftingInventory);
        NBTTagList contained = this.getContainedPeripherals(container);
        ArrayList<String> text = new ArrayList<String>();
        if (contained.func_74745_c() == 0) {
            text.add(Colors.RESET.toString() + Colors.UNDERLINE + "Contained Peripherals:");
        }
        for (ContainedPeripheral peripheral : peripherals) {
            contained.func_74742_a((NBTBase)peripheral.toNbt());
            text.add(Colors.RESET + peripheral.getBlockResourceLocation().toString());
        }
        NBTHelper.setTag((ItemStack)container, (String)ModBlocks.PERIPHERAL_CONTAINER.getRegistryName().toString(), (NBTBase)contained);
        NBTHelper.addInfo((ItemStack)container, text);
        return container;
    }

    private List<ContainedPeripheral> getPeripherals(InventoryCrafting inventory) {
        ArrayList<ContainedPeripheral> peripherals = new ArrayList<ContainedPeripheral>();
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            Block block;
            IPeripheral peripheral;
            ItemStack itemStack = inventory.func_70301_a(slot).func_77946_l();
            if (itemStack.func_77960_j() != 0 || itemStack.func_190916_E() != 1 || (peripheral = ContainedPeripheral.getPeripheralForBlock(block = Block.func_149634_a((Item)itemStack.func_77973_b()))) == null) continue;
            ResourceLocation name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
            peripherals.add(new ContainedPeripheral(name, peripheral));
        }
        return peripherals;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Block)ModBlocks.PERIPHERAL_CONTAINER);
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public String func_193358_e() {
        return this.group.toString();
    }
}

