/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.pocket;

import com.austinv11.collectiveframework.minecraft.utils.Colors;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.collectiveframework.utils.LogicUtils;
import com.austinv11.peripheralsplusplus.hooks.ComputerCraftRegistry;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.pocket.peripherals.PeripheralPeripheralContainer;
import com.austinv11.peripheralsplusplus.utils.TurtleUtil;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PocketPeripheralContainer
implements IPocketUpgrade {
    public ResourceLocation getUpgradeID() {
        return new ResourceLocation("peripheralsplusone:pocket_container");
    }

    public String getUnlocalisedAdjective() {
        return "peripheralsplusone.pocket_upgrade.peripheral_container";
    }

    public ItemStack getCraftingItem() {
        return new ItemStack((Block)ModBlocks.PERIPHERAL_CONTAINER);
    }

    @Nullable
    public IPeripheral createPeripheral(@Nonnull IPocketAccess access) {
        NBTBase listBase;
        HashMap<IPocketUpgrade, IPeripheral> pocketUpgrades = new HashMap<IPocketUpgrade, IPeripheral>();
        ItemStack stack = TurtleUtil.getPocketServerItemStack(access);
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (listBase = tag.func_74781_a("peripheralsplusone:pocket_container")) instanceof NBTTagList) {
            NBTTagList upgrades = (NBTTagList)listBase;
            for (int upgradeIndex = 0; upgradeIndex < upgrades.func_74745_c(); ++upgradeIndex) {
                ResourceLocation upgradeId = new ResourceLocation(upgrades.func_150307_f(upgradeIndex));
                for (IPocketUpgrade pocketUpgrade : ComputerCraftRegistry.getPocketUpgrades().values()) {
                    if (!upgradeId.equals((Object)pocketUpgrade.getUpgradeID())) continue;
                    pocketUpgrades.put(pocketUpgrade, pocketUpgrade.createPeripheral(access));
                }
            }
        }
        return new PeripheralPeripheralContainer(pocketUpgrades);
    }

    public void update(@Nonnull IPocketAccess access, @Nullable IPeripheral peripheral) {
        if (!(peripheral instanceof PeripheralPeripheralContainer)) {
            return;
        }
        Map<IPocketUpgrade, IPeripheral> peripherals = ((PeripheralPeripheralContainer)peripheral).getUpgrades();
        for (Map.Entry<IPocketUpgrade, IPeripheral> upgrade : peripherals.entrySet()) {
            upgrade.getKey().update(access, upgrade.getValue());
        }
        Map<ResourceLocation, ItemStack> unequippedItems = ((PeripheralPeripheralContainer)peripheral).getUnequippedItems();
        if (unequippedItems.size() > 0) {
            for (Map.Entry<ResourceLocation, ItemStack> unequipped : unequippedItems.entrySet()) {
                ItemStack pocketItem;
                NBTTagCompound tag;
                if (!(access.getEntity() instanceof EntityPlayer) || (tag = (pocketItem = TurtleUtil.getPocketServerItemStack(access)).func_77978_p()) == null) continue;
                NBTBase tagList = tag.func_74781_a("peripheralsplusone:pocket_container");
                NBTTagList newTagList = new NBTTagList();
                ArrayList<String> lore = new ArrayList<String>();
                if (tagList instanceof NBTTagList) {
                    for (int tagIndex = 0; tagIndex < ((NBTTagList)tagList).func_74745_c(); ++tagIndex) {
                        if (((NBTTagList)tagList).func_150307_f(tagIndex).equals(unequipped.getKey().toString())) continue;
                        newTagList.func_74742_a(((NBTTagList)tagList).func_179238_g(tagIndex));
                        lore.add(Colors.RESET + unequipped.getKey().toString());
                    }
                    tag.func_74782_a("peripheralsplusone:pocket_container", (NBTBase)newTagList);
                }
                if (newTagList.func_74745_c() > 0) {
                    lore.add(0, Colors.RESET.toString() + Colors.UNDERLINE + "Contained Peripherals:");
                }
                pocketItem.func_77982_d(tag);
                NBTHelper.setInfo((ItemStack)pocketItem, lore);
                ((EntityPlayer)access.getEntity()).field_71071_by.func_70441_a(pocketItem);
                ((EntityPlayer)access.getEntity()).field_71071_by.func_70441_a(unequipped.getValue());
            }
            unequippedItems.clear();
        }
    }

    public boolean onRightClick(@Nonnull World world, @Nonnull IPocketAccess access, @Nullable IPeripheral peripheral) {
        if (!(peripheral instanceof PeripheralPeripheralContainer)) {
            return false;
        }
        Map<IPocketUpgrade, IPeripheral> peripherals = ((PeripheralPeripheralContainer)peripheral).getUpgrades();
        boolean[] results = new boolean[peripherals.size()];
        int resultIndex = 0;
        for (Map.Entry<IPocketUpgrade, IPeripheral> upgrade : peripherals.entrySet()) {
            results[resultIndex++] = upgrade.getKey().onRightClick(world, access, upgrade.getValue());
        }
        return LogicUtils.or((boolean[])results);
    }
}

