/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.network;

import com.austinv11.peripheralsplusplus.tiles.TileEntityAntenna;
import dan200.computercraft.api.peripheral.IComputerAccess;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TextFieldInputEventPacket
implements IMessage {
    public UUID uuid;
    public String event;
    public String player;
    public String text;
    public String key;

    public TextFieldInputEventPacket() {
    }

    public TextFieldInputEventPacket(UUID uuid, String key, String text, String event, String player) {
        this.uuid = uuid;
        this.key = key;
        this.text = text;
        this.event = event;
        this.player = player;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.uuid = UUID.fromString(tag.func_74779_i("uuid"));
        this.key = tag.func_74779_i("key");
        this.event = tag.func_74779_i("event");
        this.player = tag.func_74779_i("player");
        this.text = tag.func_74779_i("text");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("uuid", this.uuid.toString());
        tag.func_74778_a("key", this.key);
        tag.func_74778_a("event", this.event);
        tag.func_74778_a("player", this.player);
        tag.func_74778_a("text", this.text);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class TextFieldInputEventPacketHandler
    implements IMessageHandler<TextFieldInputEventPacket, IMessage> {
        public IMessage onMessage(TextFieldInputEventPacket message, MessageContext ctx) {
            TileEntityAntenna antenna = TileEntityAntenna.ANTENNA_REGISTRY.get(message.uuid);
            if (antenna != null) {
                for (IComputerAccess computer : antenna.computers.keySet()) {
                    computer.queueEvent(message.event, new Object[]{message.player, message.key, message.text});
                }
            }
            return null;
        }
    }
}

