/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.network;

import com.austinv11.peripheralsplusplus.event.handler.RobotHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RobotEventPacket
implements IMessage {
    public ActionType action;
    public PressType type;
    public Object info;

    public RobotEventPacket() {
    }

    public RobotEventPacket(ActionType action, PressType type, Object information) {
        this.action = action;
        this.type = type;
        this.info = information;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.action = ActionType.values()[tag.func_74762_e("action")];
        this.type = PressType.values()[tag.func_74762_e("type")];
        this.info = this.action == ActionType.KEYBOARD ? tag.func_74779_i("info") : (this.action == ActionType.MOUSE_CLICK ? Integer.valueOf(tag.func_74762_e("info")) : (Object)tag.func_74759_k("info"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("action", this.action.ordinal());
        tag.func_74768_a("type", this.type.ordinal());
        if (this.action == ActionType.KEYBOARD) {
            tag.func_74778_a("info", (String)this.info);
        } else if (this.action == ActionType.MOUSE_CLICK) {
            tag.func_74768_a("info", ((Integer)this.info).intValue());
        } else {
            tag.func_74783_a("info", (int[])this.info);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class RobotEventPacketHandler
    implements IMessageHandler<RobotEventPacket, IMessage> {
        public IMessage onMessage(RobotEventPacket message, MessageContext ctx) {
            switch (message.action) {
                case KEYBOARD: {
                    this.doKeyboardAction(message.type, (String)message.info);
                    break;
                }
                case MOUSE_CLICK: {
                    this.doMouseClickAction(message.type, (Integer)message.info);
                    break;
                }
                case MOUSE_MOVE: {
                    this.doMouseMoveAction((int[])message.info);
                }
            }
            return null;
        }

        private void doKeyboardAction(PressType pressType, String key) {
            RobotHandler.KeyBoardOperation operation = new RobotHandler.KeyBoardOperation();
            operation.pressType = pressType;
            operation.key = key;
            RobotHandler.operationList.add(operation);
        }

        private void doMouseClickAction(PressType pressType, int button) {
            RobotHandler.MouseClickOperation operation = new RobotHandler.MouseClickOperation();
            operation.pressType = pressType;
            operation.button = button;
            RobotHandler.operationList.add(operation);
        }

        private void doMouseMoveAction(int[] movement) {
            RobotHandler.MouseMoveOperation operation = new RobotHandler.MouseMoveOperation();
            operation.x = movement[0];
            operation.y = movement[1];
            RobotHandler.operationList.add(operation);
        }
    }

    public static enum PressType {
        PRESS,
        RELEASE;

    }

    public static enum ActionType {
        KEYBOARD,
        MOUSE_CLICK,
        MOUSE_MOVE;

    }
}

