/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.network;

import com.austinv11.peripheralsplusplus.entities.EntityRidableTurtle;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RidableTurtlePacket
implements IMessage {
    private UUID entityId;
    private EntityRidableTurtle.MovementCode movementCode;
    private int dimension;

    public RidableTurtlePacket() {
    }

    public RidableTurtlePacket(UUID entityId, EntityRidableTurtle.MovementCode movementCode, int dimension) {
        this.entityId = entityId;
        this.movementCode = movementCode;
        this.dimension = dimension;
    }

    public void fromBytes(ByteBuf byteBuf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)byteBuf);
        this.entityId = tag.func_186857_a("entityId");
        this.movementCode = EntityRidableTurtle.MovementCode.values()[tag.func_74762_e("movementCode")];
        this.dimension = tag.func_74762_e("dimension");
    }

    public void toBytes(ByteBuf byteBuf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a("entityId", this.entityId);
        tag.func_74768_a("movementCode", this.movementCode.ordinal());
        tag.func_74768_a("dimension", this.dimension);
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)tag);
    }

    public static class RidableTurtlePacketHandler
    implements IMessageHandler<RidableTurtlePacket, IMessage> {
        public IMessage onMessage(RidableTurtlePacket ridableTurtlePacket, MessageContext messageContext) {
            EntityRidableTurtle ridableTurtle = (EntityRidableTurtle)DimensionManager.getWorld((int)ridableTurtlePacket.dimension).func_175733_a(ridableTurtlePacket.entityId);
            if (ridableTurtle != null) {
                ridableTurtle.tryMove(ridableTurtlePacket.movementCode);
            }
            return null;
        }
    }
}

