/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.entities;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.network.RidableTurtlePacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class EntityRidableTurtle
extends Entity
implements IPlusPlusPeripheral {
    private long lastUpdateTime = 0L;
    private ITurtleAccess turtle;

    public EntityRidableTurtle(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbtTagCompound) {
    }

    protected void func_70014_b(NBTTagCompound nbtTagCompound) {
    }

    public boolean func_70067_L() {
        return this.field_70170_p.field_72995_K && (Keyboard.isKeyDown((int)29) || this.playerIsHoldingRideEnablingItem());
    }

    private boolean playerIsHoldingRideEnablingItem() {
        if (!this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack item = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        return !item.func_190926_b() && (item.func_77969_a(new ItemStack(Items.field_151146_bM)) || item.func_77969_a(new ItemStack(Items.field_151055_y)));
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!hand.equals((Object)EnumHand.MAIN_HAND)) {
            return false;
        }
        if (this.func_184207_aI() && this.func_184179_bs() instanceof EntityPlayer && this.func_184179_bs() != player) {
            return true;
        }
        if (this.func_184207_aI() && this.func_184179_bs() != player) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.isTurtleInWorld()) {
            this.field_70170_p.func_72900_e((Entity)this);
            return;
        }
        this.checkPlayerMovementRequest();
    }

    public void update(ITurtleAccess turtle) {
        this.setTurtle(turtle);
        this.func_70029_a(turtle.getWorld());
        this.moveToTurtlePosition();
    }

    private boolean isTurtleInWorld() {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.turtle == null) {
            return false;
        }
        TileEntity tileEntity = this.field_70170_p.func_175625_s(this.turtle.getPosition());
        if (tileEntity == null) {
            return false;
        }
        try {
            ITurtleAccess worldTurtle = ReflectionHelper.getTurtle(tileEntity);
            if (worldTurtle == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void moveToTurtlePosition() {
        if (this.field_70170_p.field_72995_K || this.turtle == null) {
            return;
        }
        Vec3d pos = new Vec3d((Vec3i)this.turtle.getPosition()).func_72441_c(0.5, 0.0, 0.5);
        this.field_70165_t = pos.field_72450_a;
        this.field_70163_u = pos.field_72448_b;
        this.field_70161_v = pos.field_72449_c;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public boolean tryMove(MovementCode action) {
        boolean canPerformAction;
        boolean bl = canPerformAction = System.currentTimeMillis() - this.lastUpdateTime > 500L;
        if (!canPerformAction || this.field_70170_p.field_72995_K || this.turtle == null) {
            return false;
        }
        switch (action) {
            case FORWARD: 
            case DESCEND: 
            case ASCEND: {
                this.moveTurtle(action, this.turtle);
                break;
            }
            case TURN_LEFT: 
            case TURN_RIGHT: {
                this.turnTurtle(action, this.turtle);
            }
        }
        this.lastUpdateTime = System.currentTimeMillis();
        return true;
    }

    private void turnTurtle(MovementCode turnTo, ITurtleAccess turtle) {
        switch (turnTo) {
            case TURN_LEFT: {
                turtle.setDirection(turtle.getDirection().func_176735_f());
                turtle.playAnimation(TurtleAnimation.TurnLeft);
                break;
            }
            case TURN_RIGHT: {
                turtle.setDirection(turtle.getDirection().func_176746_e());
                turtle.playAnimation(TurtleAnimation.TurnRight);
            }
        }
    }

    private void moveTurtle(MovementCode direction, ITurtleAccess turtle) {
        int x = turtle.getPosition().func_177958_n();
        int y = turtle.getPosition().func_177956_o();
        int z = turtle.getPosition().func_177952_p();
        TurtleAnimation animation = TurtleAnimation.None;
        switch (direction) {
            case FORWARD: {
                switch (turtle.getDirection()) {
                    case NORTH: {
                        --z;
                        break;
                    }
                    case EAST: {
                        ++x;
                        break;
                    }
                    case SOUTH: {
                        ++z;
                        break;
                    }
                    case WEST: {
                        --x;
                    }
                }
                animation = TurtleAnimation.MoveForward;
                break;
            }
            case DESCEND: {
                --y;
                animation = TurtleAnimation.MoveDown;
                break;
            }
            case ASCEND: {
                ++y;
                animation = TurtleAnimation.MoveUp;
            }
        }
        if (this.field_70170_p.func_175623_d(new BlockPos(x, y, z)) && (turtle.getFuelLevel() >= Config.fuelPerTurtleMovement || !turtle.isFuelNeeded())) {
            turtle.teleportTo(turtle.getWorld(), new BlockPos(x, y, z));
            turtle.playAnimation(animation);
            turtle.consumeFuel(Config.fuelPerTurtleMovement);
        }
    }

    private void checkPlayerMovementRequest() {
        if (this.field_70170_p.field_72995_K && this.func_184179_bs() != null && this.func_184179_bs() == Minecraft.func_71410_x().field_71439_g) {
            if (Keyboard.isKeyDown((int)17)) {
                PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new RidableTurtlePacket(this.getPersistentID(), MovementCode.FORWARD, this.field_71093_bK));
            } else if (Keyboard.isKeyDown((int)32)) {
                PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new RidableTurtlePacket(this.getPersistentID(), MovementCode.TURN_RIGHT, this.field_71093_bK));
            } else if (Keyboard.isKeyDown((int)30)) {
                PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new RidableTurtlePacket(this.getPersistentID(), MovementCode.TURN_LEFT, this.field_71093_bK));
            } else if (Keyboard.isKeyDown((int)31)) {
                PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new RidableTurtlePacket(this.getPersistentID(), MovementCode.DESCEND, this.field_71093_bK));
            } else if (Keyboard.isKeyDown((int)45)) {
                PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new RidableTurtlePacket(this.getPersistentID(), MovementCode.ASCEND, this.field_71093_bK));
            }
        }
    }

    public void setTurtle(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().size() > 0 ? (Entity)this.func_184188_bt().get(0) : null;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void func_70030_z() {
        super.func_70030_z();
    }

    public void func_174812_G() {
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    protected void func_145775_I() {
    }

    public void func_70108_f(Entity entityIn) {
    }

    public String getType() {
        return "ridable";
    }

    public String[] getMethodNames() {
        return new String[]{"getEntity", "mountNearbyEntity", "mountNearestEntity", "mount", "unmount", "up"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableRidableTurtle) {
            throw new LuaException("Ridable turtles have been disabled.");
        }
        switch (method) {
            case 0: {
                return this.getEntityRidingTurtle();
            }
            case 1: 
            case 2: 
            case 3: {
                return this.mountNearbyEntity();
            }
            case 4: {
                return this.unmountCurrentEntity();
            }
            case 5: {
                return this.moveTurtleUp();
            }
        }
        return new Object[0];
    }

    private Object[] moveTurtleUp() {
        String failMessage = "";
        if (!this.turtle.getWorld().func_175623_d(this.turtle.getPosition().func_177984_a())) {
            failMessage = "No fuel available to move";
        }
        if (this.turtle.getFuelLevel() < Config.fuelPerTurtleMovement && this.turtle.isFuelNeeded()) {
            failMessage = "Movement blocked";
        }
        if (failMessage.isEmpty()) {
            return new Object[]{this.tryMove(MovementCode.ASCEND)};
        }
        return new Object[]{false, failMessage};
    }

    private Object[] unmountCurrentEntity() {
        Entity passenger = this.func_184179_bs();
        if (passenger != null) {
            passenger.func_184210_p();
        }
        return new Object[]{true};
    }

    private Object[] mountNearbyEntity() {
        List entities = EntityRidableTurtle.getNearbyEntities(this.turtle, 1, 2, Entity.class);
        Entity entity = null;
        for (Object ent : entities) {
            if (!((Entity)ent).func_70089_S() || ent instanceof EntityRidableTurtle) continue;
            entity = (Entity)ent;
            break;
        }
        if (entity == null || this.func_184179_bs() != null) {
            return new Object[]{false};
        }
        return new Object[]{entity.func_184205_a((Entity)this, true)};
    }

    public static List getNearbyEntities(ITurtleAccess turtle, int radiusStart, int radiusEnd, Class entityType) {
        World world = turtle.getWorld();
        AxisAlignedBB bb = new AxisAlignedBB((double)(turtle.getPosition().func_177958_n() - radiusStart), (double)(turtle.getPosition().func_177956_o() - radiusStart), (double)(turtle.getPosition().func_177952_p() - radiusStart), (double)(turtle.getPosition().func_177958_n() + radiusEnd), (double)(turtle.getPosition().func_177956_o() + radiusEnd), (double)(turtle.getPosition().func_177952_p() + radiusEnd));
        return world.func_72872_a(entityType, bb);
    }

    private Object[] getEntityRidingTurtle() {
        Entity ridingEntity = this.func_184179_bs();
        HashMap<String, String> map = new HashMap<String, String>();
        if (ridingEntity != null) {
            map.put("name", ridingEntity instanceof EntityPlayer ? ((EntityPlayer)ridingEntity).getDisplayNameString() : EntityList.func_75621_b((Entity)ridingEntity));
            map.put("type", ridingEntity.getClass().getSimpleName());
            map.put("uuid", ridingEntity instanceof EntityPlayer ? ((EntityPlayer)ridingEntity).func_146103_bH().getId().toString() : ridingEntity.func_110124_au().toString());
        }
        return new Object[]{map};
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    public static enum MovementCode {
        FORWARD,
        TURN_LEFT,
        TURN_RIGHT,
        ASCEND,
        DESCEND;

    }
}

