/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Coord
implements Cloneable {
    public final int x;
    public final int y;
    public final int z;

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord(double x, double y, double z) {
        this.x = MathHelper.func_76128_c((double)x);
        this.y = MathHelper.func_76128_c((double)y);
        this.z = MathHelper.func_76128_c((double)z);
    }

    public Coord(int[] coords) {
        this(coords[0], coords[1], coords[2]);
    }

    public Coord(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Coord(Vec3d vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Coord offset(int ox, int oy, int oz) {
        return new Coord(this.x + ox, this.y + oy, this.z + oz);
    }

    public int hashCode() {
        return this.x + 128 << 16 | this.y + 128 << 8 | this.z + 128;
    }

    public boolean equals(Object that) {
        if (!(that instanceof Coord)) {
            return false;
        }
        Coord otherCoord = (Coord)that;
        return otherCoord.x == this.x && otherCoord.y == this.y && otherCoord.z == this.z;
    }

    public String toString() {
        return String.format("%s,%s,%s", this.x, this.y, this.z);
    }

    public Coord clone() {
        return new Coord(this.x, this.y, this.z);
    }

    public BlockPos asBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public Vec3d asVector() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    public Coord add(Coord other) {
        return new Coord(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Coord substract(Coord other) {
        return new Coord(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public int lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSq());
    }

    public boolean isAbove(Coord pos) {
        return pos != null ? this.y > pos.y : false;
    }

    public boolean isBelow(Coord pos) {
        return pos != null ? this.y < pos.y : false;
    }

    public boolean isNorthOf(Coord pos) {
        return pos != null ? this.z < pos.z : false;
    }

    public boolean isSouthOf(Coord pos) {
        return pos != null ? this.z > pos.z : false;
    }

    public boolean isEastOf(Coord pos) {
        return pos != null ? this.x > pos.x : false;
    }

    public boolean isWestOf(Coord pos) {
        return pos != null ? this.x < pos.x : false;
    }

    public boolean isXAligned(Coord pos) {
        return pos != null ? this.x == pos.x : false;
    }

    public boolean isYAligned(Coord pos) {
        return pos != null ? this.y == pos.y : false;
    }

    public boolean isZAligned(Coord pos) {
        return pos != null ? this.z == pos.z : false;
    }
}

