/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeVisitor<T> {
    private final Class<?> selectedClass;

    protected TypeVisitor(Class<? extends T> selectedClass) {
        this.selectedClass = selectedClass;
    }

    protected TypeVisitor() {
        Type superclass = this.getClass().getGenericSuperclass();
        Preconditions.checkArgument((boolean)(superclass instanceof ParameterizedType), (String)"%s isn't parameterized", (Object)superclass);
        Type firstArg = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        this.selectedClass = TypeToken.of((Type)firstArg).getRawType();
    }

    protected abstract void visit(T var1);

    public void visit(Iterable<? super T> values) {
        for (T listener : values) {
            if (!this.selectedClass.isInstance(listener)) continue;
            this.visit(listener);
        }
    }
}

