/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import openmods.gui.Icon;
import openmods.gui.component.BaseComponent;

public class GuiComponentSprite
extends BaseComponent {
    protected Icon icon;
    protected float r = 1.0f;
    protected float g = 1.0f;
    protected float b = 1.0f;
    protected boolean overlay_mode;

    public static Icon adaptSprite(TextureAtlasSprite icon) {
        return new Icon(TextureMap.field_110575_b, icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h(), icon.func_94211_a(), icon.func_94216_b());
    }

    public boolean isOverlay() {
        return this.overlay_mode;
    }

    public BaseComponent setOverlayMode(boolean isOverlay) {
        this.overlay_mode = isOverlay;
        return this;
    }

    public GuiComponentSprite(int x, int y) {
        this(x, y, (Icon)null);
    }

    public GuiComponentSprite(int x, int y, Icon icon) {
        super(x, y);
        this.icon = icon;
    }

    public GuiComponentSprite(int x, int y, TextureAtlasSprite icon) {
        this(x, y, GuiComponentSprite.adaptSprite(icon));
    }

    public GuiComponentSprite setColor(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        return this;
    }

    @Override
    public void render(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (!this.overlay_mode) {
            this.doRender(offsetX, offsetY, mouseX, mouseY);
        }
    }

    @Override
    public void renderOverlay(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.overlay_mode) {
            this.doRender(offsetX, offsetY, mouseX, mouseY);
        }
    }

    protected void doRender(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.icon == null) {
            return;
        }
        GlStateManager.func_179124_c((float)this.r, (float)this.g, (float)this.b);
        this.drawSprite(this.icon, offsetX + this.x, offsetY + this.y);
    }

    @Override
    public int getWidth() {
        return this.icon != null ? this.icon.width : 0;
    }

    @Override
    public int getHeight() {
        return this.icon != null ? this.icon.height : 0;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setIcon(TextureAtlasSprite icon) {
        this.icon = GuiComponentSprite.adaptSprite(icon);
    }

    public static class Sprites {
        public static Icon hammer = Icon.createSheetIcon(BaseComponent.WIDGETS, 0, 233, 23, 23);
        public static Icon plus = Icon.createSheetIcon(BaseComponent.WIDGETS, 23, 242, 13, 13);
        public static Icon result = Icon.createSheetIcon(BaseComponent.WIDGETS, 36, 241, 22, 15);
    }
}

