/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.model.obj;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class MuseOBJModel
implements IModel {
    private final ResourceLocation modelLocation;
    private MaterialLibrary matLib;
    private CustomData customData;

    public MuseOBJModel(MaterialLibrary matLib, ResourceLocation modelLocation) {
        this(matLib, modelLocation, new CustomData());
    }

    public MuseOBJModel(MaterialLibrary matLib, ResourceLocation modelLocation, CustomData customData) {
        this.matLib = matLib;
        this.modelLocation = modelLocation;
        this.customData = customData;
    }

    public Collection<ResourceLocation> getTextures() {
        Iterator materialIterator = this.matLib.materials.values().iterator();
        ArrayList textures = Lists.newArrayList();
        while (materialIterator.hasNext()) {
            Material mat = (Material)materialIterator.next();
            ResourceLocation textureLoc = new ResourceLocation(mat.getTexture().getPath());
            if (textures.contains(textureLoc) || mat.isWhite()) continue;
            textures.add(textureLoc);
        }
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ModelLoader.White.LOCATION.toString(), (Object)ModelLoader.White.INSTANCE);
        TextureAtlasSprite missing = bakedTextureGetter.apply(new ResourceLocation("missingno"));
        for (Map.Entry e : this.matLib.materials.entrySet()) {
            if (((Material)e.getValue()).getTexture().getTextureLocation().func_110623_a().startsWith("#")) {
                FMLLog.log.fatal("MuseOBJLoader: Unresolved texture '{}' for obj model '{}'", (Object)((Material)e.getValue()).getTexture().getTextureLocation().func_110623_a(), (Object)this.modelLocation);
                builder.put(e.getKey(), (Object)missing);
                continue;
            }
            builder.put(e.getKey(), (Object)bakedTextureGetter.apply(((Material)e.getValue()).getTexture().getTextureLocation()));
        }
        builder.put((Object)"missingno", (Object)missing);
        return new MuseOBJBakedModel(this, state, format, (ImmutableMap<String, TextureAtlasSprite>)builder.build());
    }

    public MaterialLibrary getMatLib() {
        return this.matLib;
    }

    public IModel process(ImmutableMap<String, String> customData) {
        MuseOBJModel ret = new MuseOBJModel(this.matLib, this.modelLocation, new CustomData(this.customData, customData));
        return ret;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        MuseOBJModel ret = new MuseOBJModel(this.matLib.makeLibWithReplacements(textures), this.modelLocation, this.customData);
        return ret;
    }

    public class MuseOBJBakedModel
    implements IBakedModel {
        private final MuseOBJModel model;
        private final VertexFormat format;
        private IModelState state;
        private ImmutableList<BakedQuad> quads;
        private Map<String, List<BakedQuad>> partQuadMap;
        private ImmutableMap<String, TextureAtlasSprite> textures;
        private final LoadingCache<IModelState, MuseOBJBakedModel> cache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<IModelState, MuseOBJBakedModel>(){

            public MuseOBJBakedModel load(IModelState state) throws Exception {
                return new MuseOBJBakedModel(MuseOBJBakedModel.this.model, state, MuseOBJBakedModel.this.format, (ImmutableMap<String, TextureAtlasSprite>)MuseOBJBakedModel.this.textures);
            }
        });
        private IBlockState cachedBlockstate;
        private TextureAtlasSprite sprite = ModelLoader.White.INSTANCE;

        public MuseOBJBakedModel(MuseOBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures) {
            this.model = model;
            this.state = state;
            if (this.state instanceof OBJState) {
                this.updateStateVisibilityMap((OBJState)this.state);
            }
            this.format = format;
            this.textures = textures;
            this.partQuadMap = new HashMap<String, List<BakedQuad>>();
        }

        public void scheduleRebake() {
        }

        public List<BakedQuad> getQuadsforPart(String partName) {
            if (this.partQuadMap.isEmpty()) {
                this.quads = this.buildQuads(this.state);
            }
            return this.partQuadMap.get(partName);
        }

        public List<BakedQuad> getRetexturedQuadsforPart(String partName, TextureAtlasSprite texture) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (BakedQuad quad : this.getQuadsforPart(partName)) {
                builder.add((Object)new BakedQuadRetextured(quad, texture));
            }
            return builder.build();
        }

        public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
            IModelState newState;
            IExtendedBlockState exState;
            if (side != null) {
                return ImmutableList.of();
            }
            if (this.partQuadMap.isEmpty()) {
                this.quads = this.buildQuads(this.state);
            }
            if (blockState == null || blockState == this.cachedBlockstate) {
                return this.quads;
            }
            this.cachedBlockstate = blockState;
            if (blockState instanceof IExtendedBlockState && (exState = (IExtendedBlockState)blockState).getUnlistedNames().contains(Properties.AnimationProperty) && (newState = (IModelState)exState.getValue(Properties.AnimationProperty)) != null) {
                newState = new ModelStateComposition(this.state, newState);
                return this.buildQuads(newState);
            }
            return ImmutableList.copyOf((Collection)this.partQuadMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toList()));
        }

        private ImmutableList<BakedQuad> buildQuads(IModelState modelState) {
            List visibleParts;
            OBJState state;
            ArrayList quads = Lists.newArrayList();
            Collections.synchronizedSet(new LinkedHashSet());
            Map<String, LinkedHashSet<Face>> facesMap = Collections.synchronizedMap(new LinkedHashMap());
            Optional transform = Optional.empty();
            OBJState oBJState = state = modelState instanceof OBJState ? (OBJState)modelState : null;
            if (state != null) {
                this.updateStateVisibilityMap(state);
                visibleParts = state.visibilityMap.keySet().stream().filter(key -> state.visibilityMap.get(key)).collect(Collectors.toList());
            } else {
                visibleParts = this.model.getMatLib().getGroups().keySet().stream().filter(name -> !modelState.apply(Optional.of(Models.getHiddenModelPart((ImmutableList)ImmutableList.of((Object)this.model.getMatLib().getGroups().get(name).getName())))).isPresent()).collect(Collectors.toList());
            }
            for (Group g : this.model.getMatLib().getGroups().values()) {
                if (state == null) {
                    transform = modelState.apply(Optional.empty());
                }
                facesMap.put(g.name, g.applyTransform(transform));
            }
            for (String group : facesMap.keySet()) {
                this.partQuadMap.put(group, (List<BakedQuad>)this.getQuadsFromFaces((Set)facesMap.get(group)));
            }
            return ImmutableList.copyOf((Collection)this.partQuadMap.entrySet().stream().filter(entry -> visibleParts.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()).stream().flatMap(x -> x.stream()).collect(Collectors.toList()));
        }

        private ImmutableList<BakedQuad> getQuadsFromFaces(Set<Face> faces) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (Face f : faces) {
                if (((Material)this.model.getMatLib().materials.get(f.getMaterialName())).isWhite()) {
                    for (Vertex v : f.getVertices()) {
                        if (v.getMaterial().equals(this.model.getMatLib().getMaterial(v.getMaterial().getName()))) continue;
                        v.setMaterial(this.model.getMatLib().getMaterial(v.getMaterial().getName()));
                    }
                    this.sprite = ModelLoader.White.INSTANCE;
                } else {
                    this.sprite = (TextureAtlasSprite)this.textures.get((Object)f.getMaterialName());
                }
                quads.add(this.getQuadForFace(f));
            }
            return ImmutableList.copyOf(quads);
        }

        private BakedQuad getQuadForFace(Face f) {
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
            builder.setContractUVs(true);
            builder.setQuadOrientation(EnumFacing.func_176737_a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z));
            builder.setTexture(this.sprite);
            Normal faceNormal = f.getNormal();
            this.putVertexData(builder, f.verts[0], faceNormal, TextureCoordinate.getDefaultUVs()[0], this.sprite);
            this.putVertexData(builder, f.verts[1], faceNormal, TextureCoordinate.getDefaultUVs()[1], this.sprite);
            this.putVertexData(builder, f.verts[2], faceNormal, TextureCoordinate.getDefaultUVs()[2], this.sprite);
            this.putVertexData(builder, f.verts[3], faceNormal, TextureCoordinate.getDefaultUVs()[3], this.sprite);
            return builder.build();
        }

        private final void putVertexData(UnpackedBakedQuad.Builder builder, Vertex v, Normal faceNormal, TextureCoordinate defUV, TextureAtlasSprite sprite) {
            block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
                switch (this.format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        builder.put(e, new float[]{v.getPos().x, v.getPos().y, v.getPos().z, v.getPos().w});
                        continue block6;
                    }
                    case COLOR: {
                        if (v.getMaterial() != null) {
                            builder.put(e, new float[]{v.getMaterial().getColor().x, v.getMaterial().getColor().y, v.getMaterial().getColor().z, v.getMaterial().getColor().w});
                            continue block6;
                        }
                        builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                        continue block6;
                    }
                    case UV: {
                        if (!v.hasTextureCoordinate()) {
                            builder.put(e, new float[]{sprite.func_94214_a((double)(defUV.u * 16.0f)), sprite.func_94207_b((double)((((MuseOBJModel)this.model).customData.flipV ? 1.0f - defUV.v : defUV.v) * 16.0f)), 0.0f, 1.0f});
                            continue block6;
                        }
                        builder.put(e, new float[]{sprite.func_94214_a((double)(v.getTextureCoordinate().u * 16.0f)), sprite.func_94207_b((double)((((MuseOBJModel)this.model).customData.flipV ? 1.0f - v.getTextureCoordinate().v : v.getTextureCoordinate().v) * 16.0f)), 0.0f, 1.0f});
                        continue block6;
                    }
                    case NORMAL: {
                        if (!v.hasNormal()) {
                            builder.put(e, new float[]{faceNormal.x, faceNormal.y, faceNormal.z, 0.0f});
                            continue block6;
                        }
                        builder.put(e, new float[]{v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f});
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean func_177555_b() {
            return this.model != null ? ((MuseOBJModel)this.model).customData.ambientOcclusion : true;
        }

        public boolean func_177556_c() {
            return this.model != null ? ((MuseOBJModel)this.model).customData.gui3d : true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.sprite;
        }

        private void updateStateVisibilityMap(OBJState state) {
            if (state.visibilityMap.containsKey("MuseOBJModel.Group.All.Key")) {
                boolean operation = state.visibilityMap.get("MuseOBJModel.Group.All.Key");
                state.visibilityMap.clear();
                for (String s : this.model.getMatLib().getGroups().keySet()) {
                    state.visibilityMap.put(s, state.operation.performOperation(operation));
                }
            } else if (state.visibilityMap.containsKey("MuseOBJModel.Group.All.Except.Key")) {
                List<String> exceptList = state.getGroupNamesFromMap().subList(1, state.getGroupNamesFromMap().size());
                state.visibilityMap.remove("MuseOBJModel.Group.All.Except.Key");
                for (String s : this.model.getMatLib().getGroups().keySet()) {
                    if (exceptList.contains(s)) continue;
                    state.visibilityMap.put(s, state.operation.performOperation(state.visibilityMap.get(s)));
                }
            } else {
                for (String s : state.visibilityMap.keySet()) {
                    state.visibilityMap.put(s, state.operation.performOperation(state.visibilityMap.get(s)));
                }
            }
        }

        public MuseOBJBakedModel getCachedModel(IModelState state) {
            return (MuseOBJBakedModel)this.cache.getUnchecked((Object)state);
        }

        public MuseOBJModel getModel() {
            return this.model;
        }

        public IModelState getState() {
            return this.state;
        }

        public MuseOBJBakedModel getBakedModel() {
            return new MuseOBJBakedModel(this.model, this.state, this.format, this.textures);
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.state, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public String toString() {
            return this.model.modelLocation.toString();
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }

    public static class UVsOutOfBoundsException
    extends RuntimeException {
        public ResourceLocation modelLocation;

        public UVsOutOfBoundsException(ResourceLocation modelLocation) {
            super(String.format("Model '%s' has UVs ('vt') out of bounds 0-1! The missing model will be used instead. Support for UV processing will be added to the OBJ loader in the future.", modelLocation));
            this.modelLocation = modelLocation;
        }
    }

    @Deprecated
    public static class OBJState
    implements IModelState {
        public IModelState parent;
        protected Map<String, Boolean> visibilityMap = Maps.newHashMap();
        protected Operation operation = Operation.SET_TRUE;

        public OBJState(List<String> visibleGroups, boolean visibility) {
            this(visibleGroups, visibility, (IModelState)TRSRTransformation.identity());
        }

        public OBJState(Map<String, Boolean> visibleGroups, IModelState parent) {
            this.parent = parent;
            this.visibilityMap.putAll(visibleGroups);
        }

        public OBJState(List<String> visibleGroups, boolean visibility, IModelState parent) {
            this.parent = parent;
            for (String s : visibleGroups) {
                this.visibilityMap.put(s, visibility);
            }
        }

        @Nullable
        public IModelState getParent(IModelState parent) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof OBJState) {
                return ((OBJState)parent).parent;
            }
            return parent;
        }

        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            if (this.parent != null) {
                return this.parent.apply(part);
            }
            return Optional.empty();
        }

        public Map<String, Boolean> getVisibilityMap() {
            return this.visibilityMap;
        }

        public List<String> getGroupsWithVisibility(boolean visibility) {
            ArrayList ret = Lists.newArrayList();
            for (Map.Entry<String, Boolean> e : this.visibilityMap.entrySet()) {
                if (e.getValue() != visibility) continue;
                ret.add(e.getKey());
            }
            return ret;
        }

        public List<String> getGroupNamesFromMap() {
            return Lists.newArrayList(this.visibilityMap.keySet());
        }

        public void changeGroupVisibilities(List<String> names, Operation operation) {
            if (names == null || names.isEmpty()) {
                return;
            }
            this.operation = operation;
            if (names.get(0).equals("MuseOBJModel.Group.All.Key")) {
                for (String s : this.visibilityMap.keySet()) {
                    this.visibilityMap.put(s, this.operation.performOperation(this.visibilityMap.get(s)));
                }
            } else if (names.get(0).equals("MuseOBJModel.Group.All.Except.Key")) {
                for (String s : this.visibilityMap.keySet()) {
                    if (names.subList(1, names.size()).contains(s)) continue;
                    this.visibilityMap.put(s, this.operation.performOperation(this.visibilityMap.get(s)));
                }
            } else {
                for (String s : names) {
                    this.visibilityMap.put(s, this.operation.performOperation(this.visibilityMap.get(s)));
                }
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("OBJState: ");
            builder.append(String.format("%n    parent: %s%n", this.parent.toString()));
            builder.append(String.format("    visibility map: %n", new Object[0]));
            for (Map.Entry<String, Boolean> e : this.visibilityMap.entrySet()) {
                builder.append(String.format("        id: %s visible: %b%n", e.getKey(), e.getValue()));
            }
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OBJState objState = (OBJState)o;
            return Objects.equal((Object)this.parent, (Object)objState.parent) && Objects.equal(this.getVisibilityMap(), objState.getVisibilityMap()) && this.operation == objState.operation;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.parent, this.getVisibilityMap(), this.operation});
        }

        public static enum Operation {
            SET_TRUE,
            SET_FALSE,
            TOGGLE;


            public boolean performOperation(boolean valueToToggle) {
                switch (this) {
                    default: {
                        return true;
                    }
                    case SET_FALSE: {
                        return false;
                    }
                    case TOGGLE: 
                }
                return !valueToToggle;
            }
        }
    }

    @Deprecated
    public static class Group
    implements IModelPart {
        public static final String DEFAULT_NAME = "MuseOBJModel.Default.Element.Name";
        public static final String ALL = "MuseOBJModel.Group.All.Key";
        public static final String ALL_EXCEPT = "MuseOBJModel.Group.All.Except.Key";
        public float[] minUVBounds = new float[]{0.0f, 0.0f};
        public float[] maxUVBounds = new float[]{1.0f, 1.0f};
        private String name = "MuseOBJModel.Default.Element.Name";
        private LinkedHashSet<Face> faces = new LinkedHashSet();

        public Group(String name, @Nullable LinkedHashSet<Face> faces) {
            this.name = name != null ? name : DEFAULT_NAME;
            this.faces = faces == null ? new LinkedHashSet() : faces;
        }

        public LinkedHashSet<Face> applyTransform(Optional<TRSRTransformation> transform) {
            LinkedHashSet<Face> faceSet = new LinkedHashSet<Face>();
            for (Face f : this.faces) {
                faceSet.add(f.bake(transform.orElse(TRSRTransformation.identity())));
            }
            return faceSet;
        }

        public String getName() {
            return this.name;
        }

        public LinkedHashSet<Face> getFaces() {
            return this.faces;
        }

        public void setFaces(LinkedHashSet<Face> faces) {
            this.faces = faces;
        }

        public void addFace(Face face) {
            this.faces.add(face);
        }

        public void addFaces(List<Face> faces) {
            this.faces.addAll(faces);
        }
    }

    public static class TextureCoordinate {
        public float u;
        public float v;
        public float w;

        public TextureCoordinate() {
            this(0.0f, 0.0f, 1.0f);
        }

        public TextureCoordinate(float[] data) {
            this(data[0], data[1], data[2]);
        }

        public TextureCoordinate(Vector3f data) {
            this(data.x, data.y, data.z);
        }

        public TextureCoordinate(float u, float v, float w) {
            this.u = u;
            this.v = v;
            this.w = w;
        }

        public static TextureCoordinate[] getDefaultUVs() {
            TextureCoordinate[] texCoords = new TextureCoordinate[]{new TextureCoordinate(0.0f, 0.0f, 1.0f), new TextureCoordinate(1.0f, 0.0f, 1.0f), new TextureCoordinate(1.0f, 1.0f, 1.0f), new TextureCoordinate(0.0f, 1.0f, 1.0f)};
            return texCoords;
        }

        public Vector3f getData() {
            return new Vector3f(this.u, this.v, this.w);
        }
    }

    public static class Normal {
        public float x;
        public float y;
        public float z;

        public Normal() {
            this(0.0f, 0.0f, 0.0f);
        }

        public Normal(float[] data) {
            this(data[0], data[1], data[2]);
        }

        public Normal(Vector3f vector3f) {
            this(vector3f.x, vector3f.y, vector3f.z);
        }

        public Normal(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector3f getData() {
            return new Vector3f(this.x, this.y, this.z);
        }
    }

    public static class Vertex {
        private Vector4f position;
        private Normal normal;
        private TextureCoordinate texCoord;
        private Material material = new Material();

        public Vertex(Vector4f position, Material material) {
            this.position = position;
            this.material = material;
        }

        public Vector4f getPos() {
            return this.position;
        }

        public void setPos(Vector4f position) {
            this.position = position;
        }

        public Vector3f getPos3() {
            return new Vector3f(this.position.x, this.position.y, this.position.z);
        }

        public boolean hasNormal() {
            return this.normal != null;
        }

        public Normal getNormal() {
            return this.normal;
        }

        public void setNormal(Normal normal) {
            this.normal = normal;
        }

        public boolean hasTextureCoordinate() {
            return this.texCoord != null;
        }

        public TextureCoordinate getTextureCoordinate() {
            return this.texCoord;
        }

        public void setTextureCoordinate(TextureCoordinate texCoord) {
            this.texCoord = texCoord;
        }

        public Material getMaterial() {
            return this.material;
        }

        public void setMaterial(Material material) {
            this.material = material;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("v:%n", new Object[0]));
            builder.append(String.format("    position: %s %s %s%n", Float.valueOf(this.position.x), Float.valueOf(this.position.y), Float.valueOf(this.position.z)));
            builder.append(String.format("    material: %s %s %s %s %s%n", this.material.getName(), Float.valueOf(this.material.getColor().x), Float.valueOf(this.material.getColor().y), Float.valueOf(this.material.getColor().z), Float.valueOf(this.material.getColor().w)));
            return builder.toString();
        }
    }

    public static class Face {
        private Vertex[] verts = new Vertex[4];
        private String materialName = "MuseOBJModel.Default.Texture.Name";
        private boolean isTri = false;

        public Face(Vertex[] verts) {
            this(verts, "MuseOBJModel.Default.Texture.Name");
        }

        public Face(Vertex[] verts, String materialName) {
            this.verts = verts != null && verts.length > 2 ? verts : null;
            this.setMaterialName(materialName);
            this.checkData();
        }

        private void checkData() {
            if (this.verts != null && this.verts.length == 3) {
                this.isTri = true;
                this.verts = new Vertex[]{this.verts[0], this.verts[1], this.verts[2], this.verts[2]};
            }
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public void setMaterialName(String materialName) {
            this.materialName = materialName != null && !materialName.isEmpty() ? materialName : this.materialName;
        }

        public boolean isTriangles() {
            return this.isTri;
        }

        public boolean setVertices(Vertex[] verts) {
            if (verts == null) {
                return false;
            }
            this.verts = verts;
            this.checkData();
            return true;
        }

        public Vertex[] getVertices() {
            return this.verts;
        }

        public Face bake(TRSRTransformation transform) {
            Matrix4f m = transform.getMatrix();
            Matrix3f mn = null;
            Vertex[] vertices = new Vertex[this.verts.length];
            for (int i = 0; i < this.verts.length; ++i) {
                Vertex v = this.verts[i];
                Vector4f pos = new Vector4f(v.getPos());
                Vector4f newPos = new Vector4f();
                pos.w = 1.0f;
                m.transform((Tuple4f)pos, (Tuple4f)newPos);
                vertices[i] = new Vertex(newPos, v.getMaterial());
                if (v.hasNormal()) {
                    if (mn == null) {
                        mn = new Matrix3f();
                        m.getRotationScale(mn);
                        mn.invert();
                        mn.transpose();
                    }
                    Vector3f normal = new Vector3f(v.getNormal().getData());
                    Vector3f newNormal = new Vector3f();
                    mn.transform((Tuple3f)normal, (Tuple3f)newNormal);
                    newNormal.normalize();
                    vertices[i].setNormal(new Normal(newNormal));
                }
                if (v.hasTextureCoordinate()) {
                    vertices[i].setTextureCoordinate(v.getTextureCoordinate());
                    continue;
                }
                v.setTextureCoordinate(TextureCoordinate.getDefaultUVs()[i]);
            }
            return new Face(vertices, this.materialName);
        }

        public Normal getNormal() {
            Vector3f a = this.verts[2].getPos3();
            a.sub((Tuple3f)this.verts[0].getPos3());
            Vector3f b = this.verts[3].getPos3();
            b.sub((Tuple3f)this.verts[1].getPos3());
            a.cross(a, b);
            a.normalize();
            return new Normal(a);
        }
    }

    public static class Texture {
        public static Texture WHITE = new Texture("builtin/white", new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0.0f);
        private String path;
        private Vector2f position;
        private Vector2f scale;
        private float rotation;

        public Texture(String path) {
            this(path, new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0.0f);
        }

        public Texture(String path, Vector2f position, Vector2f scale, float rotation) {
            this.path = path;
            this.position = position;
            this.scale = scale;
            this.rotation = rotation;
        }

        public ResourceLocation getTextureLocation() {
            ResourceLocation loc = new ResourceLocation(this.path);
            return loc;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Vector2f getPosition() {
            return this.position;
        }

        public void setPosition(Vector2f position) {
            this.position = position;
        }

        public Vector2f getScale() {
            return this.scale;
        }

        public void setScale(Vector2f scale) {
            this.scale = scale;
        }

        public float getRotation() {
            return this.rotation;
        }

        public void setRotation(float rotation) {
            this.rotation = rotation;
        }
    }

    public static class Material {
        public static final String WHITE_NAME = "MuseOBJModel.White.Texture.Name";
        public static final String DEFAULT_NAME = "MuseOBJModel.Default.Texture.Name";
        private Vector4f color;
        private Texture texture = Texture.WHITE;
        private String name = "MuseOBJModel.Default.Texture.Name";

        public Material() {
            this(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
        }

        public Material(Vector4f color) {
            this(color, Texture.WHITE, WHITE_NAME);
        }

        public Material(Texture texture) {
            this(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), texture, DEFAULT_NAME);
        }

        public Material(Vector4f color, Texture texture, String name) {
            this.color = color;
            this.texture = texture;
            this.name = name != null ? name : DEFAULT_NAME;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name != null ? name : DEFAULT_NAME;
        }

        public Vector4f getColor() {
            return this.color;
        }

        public void setColor(Vector4f color) {
            this.color = color;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public void setTexture(Texture texture) {
            this.texture = texture;
        }

        public boolean isWhite() {
            return this.texture.equals(Texture.WHITE);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(String.format("%nMaterial:%n", new Object[0]));
            builder.append(String.format("    Name: %s%n", this.name));
            builder.append(String.format("    Color: %s%n", this.color.toString()));
            builder.append(String.format("    Is White: %b%n", this.isWhite()));
            return builder.toString();
        }
    }

    public static class MaterialLibrary {
        private static final Pattern WHITE_SPACE = Pattern.compile("\\s+");
        private Set<String> unknownMaterialCommands = new HashSet<String>();
        private Map<String, Material> materials = new HashMap<String, Material>();
        private Map<String, Group> groups = new HashMap<String, Group>();
        private InputStreamReader mtlStream;
        private BufferedReader mtlReader;

        public MaterialLibrary() {
            this.groups.put("MuseOBJModel.Default.Element.Name", new Group("MuseOBJModel.Default.Element.Name", null));
            Material def = new Material();
            def.setName("MuseOBJModel.Default.Texture.Name");
            this.materials.put("MuseOBJModel.Default.Texture.Name", def);
        }

        public MaterialLibrary makeLibWithReplacements(ImmutableMap<String, String> replacements) {
            HashMap<String, Material> mats = new HashMap<String, Material>();
            for (Map.Entry<String, Material> e : this.materials.entrySet()) {
                Material replacementMaterial;
                Texture replacementTexture;
                Texture currentTexture;
                String keyTex;
                String keyMat = e.getKey();
                if (!keyMat.startsWith("#")) {
                    keyMat = "#" + keyMat;
                }
                if ((keyTex = e.getValue().getTexture().getPath()).endsWith(".png")) {
                    keyTex = keyTex.substring(0, keyTex.length() - ".png".length());
                }
                if (!keyTex.startsWith("#")) {
                    keyTex = "#" + keyTex;
                }
                if (replacements.containsKey((Object)keyMat)) {
                    currentTexture = e.getValue().texture;
                    replacementTexture = new Texture((String)replacements.get((Object)keyMat), currentTexture.position, currentTexture.scale, currentTexture.rotation);
                    replacementMaterial = new Material(e.getValue().color, replacementTexture, e.getValue().name);
                    mats.put(e.getKey(), replacementMaterial);
                    continue;
                }
                if (replacements.containsKey((Object)keyTex)) {
                    currentTexture = e.getValue().texture;
                    replacementTexture = new Texture((String)replacements.get((Object)keyTex), currentTexture.position, currentTexture.scale, currentTexture.rotation);
                    replacementMaterial = new Material(e.getValue().color, replacementTexture, e.getValue().name);
                    mats.put(e.getKey(), replacementMaterial);
                    continue;
                }
                mats.put(e.getKey(), e.getValue());
            }
            MaterialLibrary ret = new MaterialLibrary();
            ret.unknownMaterialCommands = this.unknownMaterialCommands;
            ret.materials = mats;
            ret.groups = this.groups;
            ret.mtlStream = this.mtlStream;
            ret.mtlReader = this.mtlReader;
            return ret;
        }

        public Map<String, Group> getGroups() {
            return this.groups;
        }

        public List<Group> getGroupsContainingFace(Face f) {
            ArrayList groupList = Lists.newArrayList();
            for (Group g : this.groups.values()) {
                if (!g.faces.contains(f)) continue;
                groupList.add(g);
            }
            return groupList;
        }

        public void changeMaterialColor(String name, int color) {
            Vector4f colorVec = new Vector4f();
            colorVec.w = (color >> 24 & 0xFF) / 255;
            colorVec.x = (color >> 16 & 0xFF) / 255;
            colorVec.y = (color >> 8 & 0xFF) / 255;
            colorVec.z = (color & 0xFF) / 255;
            this.materials.get(name).setColor(colorVec);
        }

        public Material getMaterial(String name) {
            return this.materials.get(name);
        }

        public ImmutableList<String> getMaterialNames() {
            return ImmutableList.copyOf(this.materials.keySet());
        }

        public void parseMaterials(IResourceManager manager, String path, ResourceLocation from) throws IOException {
            this.materials.clear();
            boolean hasSetTexture = false;
            boolean hasSetColor = false;
            String domain = from.func_110624_b();
            if (!path.contains("/")) {
                path = from.func_110623_a().substring(0, from.func_110623_a().lastIndexOf("/") + 1) + path;
            }
            this.mtlStream = new InputStreamReader(manager.func_110536_a(new ResourceLocation(domain, path)).func_110527_b(), StandardCharsets.UTF_8);
            this.mtlReader = new BufferedReader(this.mtlStream);
            String currentLine = "";
            Material material = new Material();
            material.setName("MuseOBJModel.White.Texture.Name");
            material.setTexture(Texture.WHITE);
            this.materials.put("MuseOBJModel.White.Texture.Name", material);
            this.materials.put("MuseOBJModel.Default.Texture.Name", new Material(Texture.WHITE));
            while ((currentLine = this.mtlReader.readLine()) != null) {
                currentLine.trim();
                if (currentLine.isEmpty() || currentLine.startsWith("#")) continue;
                String[] fields = WHITE_SPACE.split(currentLine, 2);
                String key = fields[0];
                String data = fields[1];
                if (key.equalsIgnoreCase("newmtl")) {
                    hasSetColor = false;
                    hasSetTexture = false;
                    material = new Material();
                    material.setName(data);
                    this.materials.put(data, material);
                    continue;
                }
                if (key.equalsIgnoreCase("Ka") || key.equalsIgnoreCase("Kd") || key.equalsIgnoreCase("Ks")) {
                    if (key.equalsIgnoreCase("Kd") || !hasSetColor) {
                        String[] rgbStrings = WHITE_SPACE.split(data, 3);
                        Vector4f color = new Vector4f(Float.parseFloat(rgbStrings[0]), Float.parseFloat(rgbStrings[1]), Float.parseFloat(rgbStrings[2]), 1.0f);
                        hasSetColor = true;
                        material.setColor(color);
                        continue;
                    }
                    FMLLog.log.info("MuseOBJModel: A color has already been defined for material '{}' in '{}'. The color defined by key '{}' will not be applied!", (Object)material.getName(), (Object)new ResourceLocation(domain, path).toString(), (Object)key);
                    continue;
                }
                if (key.equalsIgnoreCase("map_Ka") || key.equalsIgnoreCase("map_Kd") || key.equalsIgnoreCase("map_Ks")) {
                    if (key.equalsIgnoreCase("map_Kd") || !hasSetTexture) {
                        if (data.contains(" ")) {
                            String[] mapStrings = WHITE_SPACE.split(data);
                            String texturePath = mapStrings[mapStrings.length - 1];
                            Texture texture = new Texture(texturePath);
                            hasSetTexture = true;
                            material.setTexture(texture);
                            continue;
                        }
                        Texture texture = new Texture(data);
                        hasSetTexture = true;
                        material.setTexture(texture);
                        continue;
                    }
                    FMLLog.log.info("MuseOBJModel: A texture has already been defined for material '{}' in '{}'. The texture defined by key '{}' will not be applied!", (Object)material.getName(), (Object)new ResourceLocation(domain, path).toString(), (Object)key);
                    continue;
                }
                if (key.equalsIgnoreCase("d") || key.equalsIgnoreCase("Tr")) {
                    String[] splitData = WHITE_SPACE.split(data);
                    float alpha = Float.parseFloat(splitData[splitData.length - 1]);
                    material.getColor().setW(alpha);
                    continue;
                }
                if (this.unknownMaterialCommands.contains(key)) continue;
                this.unknownMaterialCommands.add(key);
                FMLLog.log.info("MuseOBJLoader.MaterialLibrary: key '{}' (model: '{}') is not currently supported, skipping", (Object)key, (Object)new ResourceLocation(domain, path));
            }
        }
    }

    public static class Parser {
        private static final Pattern WHITE_SPACE = Pattern.compile("\\s+");
        private static Set<String> unknownObjectCommands = new HashSet<String>();
        public MaterialLibrary materialLibrary = new MaterialLibrary();
        private IResourceManager manager;
        private InputStreamReader objStream;
        private BufferedReader objReader;
        private ResourceLocation objFrom;
        private List<String> groupList = Lists.newArrayList();
        private List<Vertex> vertices = Lists.newArrayList();
        private List<Normal> normals = Lists.newArrayList();
        private List<TextureCoordinate> texCoords = Lists.newArrayList();

        public Parser(IResource from, IResourceManager manager) throws IOException {
            this.manager = manager;
            this.objFrom = from.func_177241_a();
            this.objStream = new InputStreamReader(from.func_110527_b(), StandardCharsets.UTF_8);
            this.objReader = new BufferedReader(this.objStream);
        }

        public List<String> getElements() {
            return this.groupList;
        }

        private float[] parseFloats(String[] data) {
            float[] ret = new float[data.length];
            for (int i = 0; i < data.length; ++i) {
                ret[i] = Float.parseFloat(data[i]);
            }
            return ret;
        }

        public MuseOBJModel parse() throws IOException {
            String currentLine = "";
            Material material = new Material();
            material.setName("MuseOBJModel.Default.Texture.Name");
            int usemtlCounter = 0;
            int lineNum = 0;
            block2: while (true) {
                ++lineNum;
                currentLine = this.objReader.readLine();
                if (currentLine == null) break;
                currentLine.trim();
                if (currentLine.isEmpty() || currentLine.startsWith("#")) continue;
                try {
                    float[] coords;
                    String[] fields = WHITE_SPACE.split(currentLine, 2);
                    String key = fields[0];
                    String data = fields[1];
                    String[] splitData = WHITE_SPACE.split(data);
                    if (key.equalsIgnoreCase("mtllib")) {
                        this.materialLibrary.parseMaterials(this.manager, data, this.objFrom);
                        continue;
                    }
                    if (key.equalsIgnoreCase("usemtl")) {
                        if (this.materialLibrary.materials.containsKey(data)) {
                            material = (Material)this.materialLibrary.materials.get(data);
                        } else {
                            FMLLog.log.error("MuseOBJModel.Parser: (Model: '{}', Line: {}) material '{}' referenced but was not found", (Object)this.objFrom, (Object)lineNum, (Object)data);
                        }
                        ++usemtlCounter;
                        continue;
                    }
                    if (key.equalsIgnoreCase("v")) {
                        coords = this.parseFloats(splitData);
                        Vector4f pos = new Vector4f(coords[0], coords[1], coords[2], coords.length == 4 ? coords[3] : 1.0f);
                        this.vertices.add(new Vertex(pos, material));
                        continue;
                    }
                    if (key.equalsIgnoreCase("vn")) {
                        this.normals.add(new Normal(this.parseFloats(splitData)));
                        continue;
                    }
                    if (key.equalsIgnoreCase("vt")) {
                        coords = this.parseFloats(splitData);
                        TextureCoordinate texCoord = new TextureCoordinate(coords[0], coords.length >= 2 ? coords[1] : 0.0f, coords.length >= 3 ? coords[2] : 0.0f);
                        if (texCoord.u < 0.0f || texCoord.u > 1.0f || texCoord.v < 0.0f || texCoord.v > 1.0f) {
                            throw new UVsOutOfBoundsException(this.objFrom);
                        }
                        this.texCoords.add(texCoord);
                        continue;
                    }
                    if (key.equalsIgnoreCase("f")) {
                        if (splitData.length > 4) {
                            FMLLog.log.warn("MuseOBJModel.Parser: found a face ('f') with more than 4 vertices, only the first 4 of these vertices will be rendered!");
                        }
                        ArrayList v = Lists.newArrayListWithCapacity((int)splitData.length);
                        for (int i = 0; i < splitData.length; ++i) {
                            String[] pts = splitData[i].split("/");
                            int vert = Integer.parseInt(pts[0]);
                            Integer texture = pts.length < 2 || Strings.isNullOrEmpty((String)pts[1]) ? null : Integer.valueOf(Integer.parseInt(pts[1]));
                            Integer normal = pts.length < 3 || Strings.isNullOrEmpty((String)pts[2]) ? null : Integer.valueOf(Integer.parseInt(pts[2]));
                            vert = vert < 0 ? this.vertices.size() - 1 : vert - 1;
                            Vertex newV = new Vertex(new Vector4f(this.vertices.get(vert).getPos()), this.vertices.get(vert).getMaterial());
                            if (texture != null) {
                                newV.setTextureCoordinate(this.texCoords.get(texture < 0 ? this.texCoords.size() - 1 : texture - 1));
                            }
                            if (normal != null) {
                                newV.setNormal(this.normals.get(normal < 0 ? this.normals.size() - 1 : normal - 1));
                            }
                            v.add(newV);
                        }
                        Vertex[] va = v.toArray(new Vertex[v.size()]);
                        Face face = new Face(va, material.name);
                        if (usemtlCounter < this.vertices.size()) {
                            for (Vertex ver : face.getVertices()) {
                                ver.setMaterial(material);
                            }
                        }
                        if (this.groupList.isEmpty()) {
                            if (this.materialLibrary.getGroups().containsKey("MuseOBJModel.Default.Element.Name")) {
                                this.materialLibrary.getGroups().get("MuseOBJModel.Default.Element.Name").addFace(face);
                                continue;
                            }
                            Group def = new Group("MuseOBJModel.Default.Element.Name", null);
                            def.addFace(face);
                            this.materialLibrary.getGroups().put("MuseOBJModel.Default.Element.Name", def);
                            continue;
                        }
                        Iterator<String> iterator = this.groupList.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            String s = iterator.next();
                            if (this.materialLibrary.getGroups().containsKey(s)) {
                                this.materialLibrary.getGroups().get(s).addFace(face);
                                continue;
                            }
                            Group e = new Group(s, null);
                            e.addFace(face);
                            this.materialLibrary.getGroups().put(s, e);
                        }
                    }
                    if (key.equalsIgnoreCase("g") || key.equalsIgnoreCase("o")) {
                        this.groupList.clear();
                        if (key.equalsIgnoreCase("g")) {
                            String[] splitSpace;
                            String[] stringArray = splitSpace = data.split(" ");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) continue block2;
                                String s = stringArray[n2];
                                this.groupList.add(s);
                                ++n2;
                            }
                        }
                        this.groupList.add(data);
                        continue;
                    }
                    if (unknownObjectCommands.contains(key)) continue;
                    unknownObjectCommands.add(key);
                    FMLLog.log.info("MuseOBJLoader.Parser: command '{}' (model: '{}') is not currently supported, skipping. Line: {} '{}'", (Object)key, (Object)this.objFrom, (Object)lineNum, (Object)currentLine);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(String.format("MuseOBJLoader.Parser: Exception parsing line #%d: `%s`", lineNum, currentLine), e);
                }
            }
            return new MuseOBJModel(this.materialLibrary, this.objFrom);
        }
    }

    static class CustomData {
        public boolean ambientOcclusion = true;
        public boolean gui3d = true;
        public boolean flipV = false;

        public CustomData(CustomData parent, ImmutableMap<String, String> customData) {
            this.ambientOcclusion = parent.ambientOcclusion;
            this.gui3d = parent.gui3d;
            this.flipV = parent.flipV;
            this.process(customData);
        }

        public CustomData() {
        }

        public void process(ImmutableMap<String, String> customData) {
            for (Map.Entry e : customData.entrySet()) {
                switch (((String)e.getKey()).toLowerCase()) {
                    case "ambient": {
                        this.ambientOcclusion = Boolean.valueOf((String)e.getValue());
                        break;
                    }
                    case "gui3d": {
                        this.gui3d = Boolean.valueOf((String)e.getValue());
                        break;
                    }
                    case "flip-v": {
                        this.flipV = Boolean.valueOf((String)e.getValue());
                    }
                }
            }
        }
    }

    @Deprecated
    public static enum OBJProperty implements IUnlistedProperty<OBJState>
    {
        INSTANCE;


        public String getName() {
            return "OBJProperty";
        }

        public boolean isValid(OBJState value) {
            return value instanceof OBJState;
        }

        public Class<OBJState> getType() {
            return OBJState.class;
        }

        public String valueToString(OBJState value) {
            return value.toString();
        }
    }
}

