/*
 * Decompiled with CFR 0.152.
 */
package tehseph.netherfoundation.init;

import cofh.api.util.ThermalExpansionHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.thermalfoundation.init.TFProps;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import tehseph.netherfoundation.init.NFConfig;

public class NFRecipes {
    private static final ItemStack COAL = new ItemStack(Items.field_151044_h, 1, 0);

    public static void initCommon() {
        if (NFConfig.PROCESSING_PETROTHEUM && TFProps.enablePetrotheumCrafting) {
            NFRecipes.addPetrotheumCrafting();
        }
        if (NFConfig.PROCESSING_PYROTHEUM && TFProps.enablePyrotheumCrafting) {
            NFRecipes.addPyrotheumCrafting();
        }
        if ((NFConfig.PROCESSING_PETROTHEUM || NFConfig.PROCESSING_PYROTHEUM) && TFProps.enablePetrotheumCrafting && TFProps.enablePyrotheumCrafting) {
            NFRecipes.addPetroPyroCrafting();
        }
        if (Loader.isModLoaded((String)"thermalexpansion")) {
            if (NFConfig.PROCESSING_INDUCTION_SMELTER) {
                NFRecipes.addInductionSmelterCrafting();
            }
            if (NFConfig.PROCESSING_PULVERIZER) {
                NFRecipes.addPulverizerCrafting();
            }
        }
        if (NFConfig.PROCESSING_FURNACE) {
            NFRecipes.addSmelting();
        }
    }

    private static void addPetrotheumCrafting() {
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustGold", (int)3), (Object[])new Object[]{"oreNetherGold", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustIron", (int)3), (Object[])new Object[]{"oreNetherIron", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)COAL, (int)3), (Object[])new Object[]{"oreNetherCoal", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"gemLapis", (int)3), (Object[])new Object[]{"oreNetherLapis", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"gemDiamond", (int)3), (Object[])new Object[]{"oreNetherDiamond", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustRedstone", (int)3), (Object[])new Object[]{"oreNetherRedstone", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustCopper", (int)3), (Object[])new Object[]{"oreNetherCopper", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustTin", (int)3), (Object[])new Object[]{"oreNetherTin", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustSilver", (int)3), (Object[])new Object[]{"oreNetherSilver", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustLead", (int)3), (Object[])new Object[]{"oreNetherLead", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustAluminum", (int)3), (Object[])new Object[]{"oreNetherAluminum", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustNickel", (int)3), (Object[])new Object[]{"oreNetherNickel", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustPlatinum", (int)3), (Object[])new Object[]{"oreNetherPlatinum", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustIridium", (int)3), (Object[])new Object[]{"oreNetherIridium", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"dustMithril", (int)3), (Object[])new Object[]{"oreNetherMithril", "dustPetrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"gemEmerald", (int)3), (Object[])new Object[]{"oreNetherEmerald", "dustPetrotheum"});
    }

    private static void addPyrotheumCrafting() {
        String oreType = NFConfig.PROCESSING_SMELT_TO_ORES ? "ore" : "ingot";
        ItemStack coalStack = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"oreCoal", (int)2) : ItemHelper.cloneStack((ItemStack)COAL, (int)2);
        ItemStack lapisStack = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"oreLapis", (int)2) : ItemHelper.getOre((String)"gemLapis", (int)2);
        ItemStack diamondStack = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"oreDiamond", (int)2) : ItemHelper.getOre((String)"gemDiamond", (int)2);
        ItemStack redstoneStack = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"oreRedstone", (int)2) : ItemHelper.getOre((String)"dustRedstone", (int)2);
        ItemStack emeraldStack = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"oreEmerald", (int)2) : ItemHelper.getOre((String)"gemEmerald", (int)2);
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Gold"), (int)2), (Object[])new Object[]{"oreNetherGold", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Iron"), (int)2), (Object[])new Object[]{"oreNetherIron", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)coalStack, (Object[])new Object[]{"oreNetherCoal", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)lapisStack, (Object[])new Object[]{"oreNetherLapis", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)diamondStack, (Object[])new Object[]{"oreNetherDiamond", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)redstoneStack, (Object[])new Object[]{"oreNetherRedstone", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Copper"), (int)2), (Object[])new Object[]{"oreNetherCopper", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Tin"), (int)2), (Object[])new Object[]{"oreNetherTin", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Silver"), (int)2), (Object[])new Object[]{"oreNetherSilver", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Lead"), (int)2), (Object[])new Object[]{"oreNetherLead", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Aluminum"), (int)2), (Object[])new Object[]{"oreNetherAluminum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Nickel"), (int)2), (Object[])new Object[]{"oreNetherNickel", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Platinum"), (int)2), (Object[])new Object[]{"oreNetherPlatinum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Iridium"), (int)2), (Object[])new Object[]{"oreNetherIridium", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)(oreType + "Mithril"), (int)2), (Object[])new Object[]{"oreNetherMithril", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)emeraldStack, (Object[])new Object[]{"oreNetherEmerald", "dustPyrotheum"});
    }

    private static void addPetroPyroCrafting() {
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotGold", (int)3), (Object[])new Object[]{"oreNetherGold", "dustPetrotheum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotIron", (int)3), (Object[])new Object[]{"oreNetherIron", "dustPetrotheum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotCopper", (int)3), (Object[])new Object[]{"oreNetherCopper", "dustPetrotheum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotTin", (int)3), (Object[])new Object[]{"oreNetherTin", "dustPetrotheum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotSilver", (int)3), (Object[])new Object[]{"oreNetherSilver", "dustPetrotheum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotLead", (int)3), (Object[])new Object[]{"oreNetherLead", "dustPetrotheum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotAluminum", (int)3), (Object[])new Object[]{"oreNetherAluminum", "dustPetrotheum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotNickel", (int)3), (Object[])new Object[]{"oreNetherNickel", "dustPetrotheum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotPlatinum", (int)3), (Object[])new Object[]{"oreNetherPlatinum", "dustPetrotheum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotIridium", (int)3), (Object[])new Object[]{"oreNetherIridium", "dustPetrotheum", "dustPyrotheum"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.getOre((String)"ingotMithril", (int)3), (Object[])new Object[]{"oreNetherMithril", "dustPetrotheum", "dustPyrotheum"});
    }

    private static void addInductionSmelterCrafting() {
        int countSand = NFConfig.PROCESSING_SMELT_TO_ORES ? 3 : 4;
        int countSlag = NFConfig.PROCESSING_SMELT_TO_ORES ? 5 : 6;
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherGold"), ItemHelper.getOre((String)"ingotGold", (int)countSand), ItemHelper.getOre((String)"ingotGold", (int)countSlag));
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherIron"), ItemHelper.getOre((String)"ingotIron", (int)countSand), ItemHelper.getOre((String)"ingotIron", (int)countSlag));
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherCopper"), ItemHelper.getOre((String)"ingotCopper", (int)countSand), ItemHelper.getOre((String)"ingotCopper", (int)countSlag));
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherTin"), ItemHelper.getOre((String)"ingotTin", (int)countSand), ItemHelper.getOre((String)"ingotTin", (int)countSlag));
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherSilver"), ItemHelper.getOre((String)"ingotSilver", (int)countSand), ItemHelper.getOre((String)"ingotSilver", (int)countSlag));
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherLead"), ItemHelper.getOre((String)"ingotLead", (int)countSand), ItemHelper.getOre((String)"ingotLead", (int)countSlag));
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherAluminum"), ItemHelper.getOre((String)"ingotAluminum", (int)countSand), ItemHelper.getOre((String)"ingotAluminum", (int)countSlag));
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherNickel"), ItemHelper.getOre((String)"ingotNickel", (int)countSand), ItemHelper.getOre((String)"ingotNickel", (int)countSlag));
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherPlatinum"), ItemHelper.getOre((String)"ingotPlatinum", (int)countSand), ItemHelper.getOre((String)"ingotPlatinum", (int)countSlag));
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherIridium"), ItemHelper.getOre((String)"ingotIridium", (int)countSand), ItemHelper.getOre((String)"ingotIridium", (int)countSlag));
        NFRecipes.addSmelterRecipes(ItemHelper.getOre((String)"oreNetherMithril"), ItemHelper.getOre((String)"ingotMithril", (int)countSand), ItemHelper.getOre((String)"ingotMithril", (int)countSlag));
        ItemStack outputLapis = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"gemLapis", (int)15) : ItemHelper.getOre((String)"gemLapis", (int)20);
        ItemStack outputRedstone = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"dustRedstone", (int)12) : ItemHelper.getOre((String)"dustRedstone", (int)16);
        ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"sand"), (ItemStack)ItemHelper.getOre((String)"oreNetherLapis"), (ItemStack)outputLapis, (ItemStack)ItemHelper.getOre((String)"crystalSlagRich"), (int)50);
        ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"sand"), (ItemStack)ItemHelper.getOre((String)"oreNetherRedstone"), (ItemStack)outputRedstone, (ItemStack)ItemHelper.getOre((String)"crystalSlagRich"), (int)50);
    }

    private static void addSmelterRecipes(ItemStack input, ItemStack outputSand, ItemStack outputSlag) {
        ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"sand"), (ItemStack)input, (ItemStack)outputSand, (ItemStack)ItemHelper.getOre((String)"crystalSlagRich"), (int)10);
        ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"crystalSlagRich"), (ItemStack)input, (ItemStack)outputSlag, (ItemStack)ItemHelper.getOre((String)"crystalSlag"), (int)75);
    }

    private static void addPulverizerCrafting() {
        int countCommon = NFConfig.PROCESSING_SMELT_TO_ORES ? 3 : 4;
        int countLapis = NFConfig.PROCESSING_SMELT_TO_ORES ? 12 : 16;
        int countRedstone = NFConfig.PROCESSING_SMELT_TO_ORES ? 9 : 12;
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherGold"), (ItemStack)ItemHelper.getOre((String)"dustGold", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherIron"), (ItemStack)ItemHelper.getOre((String)"dustIron", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherCoal"), (ItemStack)ItemHelper.cloneStack((ItemStack)COAL, (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherLapis"), (ItemStack)ItemHelper.getOre((String)"gemLapis", (int)countLapis), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherDiamond"), (ItemStack)ItemHelper.getOre((String)"gemDiamond", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherRedstone"), (ItemStack)ItemHelper.getOre((String)"dustRedstone", (int)countRedstone), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherCopper"), (ItemStack)ItemHelper.getOre((String)"dustCopper", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherTin"), (ItemStack)ItemHelper.getOre((String)"dustTin", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherSilver"), (ItemStack)ItemHelper.getOre((String)"dustSilver", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherLead"), (ItemStack)ItemHelper.getOre((String)"dustLead", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherAluminum"), (ItemStack)ItemHelper.getOre((String)"dustAluminum", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherNickel"), (ItemStack)ItemHelper.getOre((String)"dustNickel", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherPlatinum"), (ItemStack)ItemHelper.getOre((String)"dustPlatinum", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherIridium"), (ItemStack)ItemHelper.getOre((String)"dustIridium", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherMithril"), (ItemStack)ItemHelper.getOre((String)"dustMithril", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)ItemHelper.getOre((String)"oreNetherEmerald"), (ItemStack)ItemHelper.getOre((String)"gemEmerald", (int)countCommon), (ItemStack)ItemHelper.getOre((String)"dustSulfur"), (int)75);
    }

    private static void addSmelting() {
        String oreType = NFConfig.PROCESSING_SMELT_TO_ORES ? "ore" : "ingot";
        ItemStack coalStack = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"oreCoal", (int)2) : ItemHelper.cloneStack((ItemStack)COAL, (int)2);
        ItemStack lapisStack = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"oreLapis", (int)2) : ItemHelper.getOre((String)"gemLapis", (int)2);
        ItemStack diamondStack = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"oreDiamond", (int)2) : ItemHelper.getOre((String)"gemDiamond", (int)2);
        ItemStack redstoneStack = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"oreRedstone", (int)2) : ItemHelper.getOre((String)"dustRedstone", (int)2);
        ItemStack emeraldStack = NFConfig.PROCESSING_SMELT_TO_ORES ? ItemHelper.getOre((String)"oreEmerald", (int)2) : ItemHelper.getOre((String)"gemEmerald", (int)2);
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherGold"), (ItemStack)ItemHelper.getOre((String)(oreType + "Gold"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherIron"), (ItemStack)ItemHelper.getOre((String)(oreType + "Iron"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherCoal"), (ItemStack)coalStack);
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherLapis"), (ItemStack)lapisStack);
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherDiamond"), (ItemStack)diamondStack);
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherRedstone"), (ItemStack)redstoneStack);
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherCopper"), (ItemStack)ItemHelper.getOre((String)(oreType + "Copper"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherTin"), (ItemStack)ItemHelper.getOre((String)(oreType + "Tin"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherSilver"), (ItemStack)ItemHelper.getOre((String)(oreType + "Silver"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherLead"), (ItemStack)ItemHelper.getOre((String)(oreType + "Lead"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherAluminum"), (ItemStack)ItemHelper.getOre((String)(oreType + "Aluminum"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherNickel"), (ItemStack)ItemHelper.getOre((String)(oreType + "Nickel"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherPlatinum"), (ItemStack)ItemHelper.getOre((String)(oreType + "Platinum"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherIridium"), (ItemStack)ItemHelper.getOre((String)(oreType + "Iridium"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherMithril"), (ItemStack)ItemHelper.getOre((String)(oreType + "Mithril"), (int)2));
        RecipeHelper.addSmelting((ItemStack)ItemHelper.getOre((String)"oreNetherEmerald"), (ItemStack)emeraldStack);
    }
}

