/*
 * Decompiled with CFR 0.152.
 */
package tehseph.netherfoundation.init;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.init.TFFluids;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tehseph.netherfoundation.common.block.BlockHellfish;
import tehseph.netherfoundation.common.block.BlockNetherOre;
import tehseph.netherfoundation.common.block.ItemBlockNetherOre;
import tehseph.netherfoundation.init.NFConfig;

@GameRegistry.ObjectHolder(value="netherfoundation")
public class NFBlocks {
    public static final BlockHellfish HELLFISH = new BlockHellfish();
    public static final BlockNetherOre NETHER_ORE = new BlockNetherOre();

    public static void preInitCommon() {
        Object itemBlock;
        if (NFConfig.HELLFISH) {
            HELLFISH.setRegistryName("hellfish");
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)HELLFISH);
            itemBlock = new ItemBlock((Block)HELLFISH);
            itemBlock.setRegistryName("hellfish");
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        }
        NETHER_ORE.setRegistryName("ore");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)NETHER_ORE);
        itemBlock = new ItemBlockNetherOre((Block)NETHER_ORE);
        itemBlock.setRegistryName("ore");
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        for (int i = 0; i < BlockNetherOre.Type.values().length; ++i) {
            String oreName = BlockNetherOre.Type.byMetadata(i).func_176610_l();
            ItemStack oreStack = new ItemStack((Block)NETHER_ORE, 1, i);
            OreDictionary.registerOre((String)("oreNether" + StringHelper.titleCase((String)oreName)), (ItemStack)oreStack);
        }
        IBlockState netherLead = NETHER_ORE.func_176223_P().func_177226_a(BlockNetherOre.VARIANT, (Comparable)((Object)BlockNetherOre.Type.LEAD));
        IBlockState netherGold = NETHER_ORE.func_176223_P().func_177226_a(BlockNetherOre.VARIANT, (Comparable)((Object)BlockNetherOre.Type.GOLD));
        ((BlockFluidInteractive)TFFluids.blockFluidMana).addInteraction(netherLead, netherGold);
        IBlockState netherSilver = NETHER_ORE.func_176223_P().func_177226_a(BlockNetherOre.VARIANT, (Comparable)((Object)BlockNetherOre.Type.SILVER));
        IBlockState netherMithril = NETHER_ORE.func_176223_P().func_177226_a(BlockNetherOre.VARIANT, (Comparable)((Object)BlockNetherOre.Type.MITHRIL));
        ((BlockFluidInteractive)TFFluids.blockFluidMana).addInteraction(netherSilver, netherMithril);
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitClient() {
        ModelResourceLocation model;
        Item item;
        if (NFConfig.HELLFISH) {
            item = Item.func_150898_a((Block)HELLFISH);
            model = new ModelResourceLocation(HELLFISH.getRegistryName(), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)model);
        }
        for (int i = 0; i < BlockNetherOre.Type.values().length; ++i) {
            item = Item.func_150898_a((Block)NETHER_ORE);
            model = new ModelResourceLocation(NETHER_ORE.getRegistryName(), "type=" + BlockNetherOre.Type.byMetadata(i).func_176610_l());
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)model);
        }
    }
}

