/*
 * Decompiled with CFR 0.152.
 */
package tehseph.netherfoundation.common.block;

import cofh.core.block.BlockCore;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tehseph.netherfoundation.Reference;

public class BlockNetherOre
extends BlockCore {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockNetherOre() {
        super(Material.field_151576_e, "netherfoundation");
        this.func_149647_a((CreativeTabs)Reference.CREATIVE_TAB);
        this.func_149663_c("ore");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.GOLD)));
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    public boolean isFireSource(World world, BlockPos blockPos, EnumFacing facing) {
        return facing == EnumFacing.UP;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    public int func_180651_a(IBlockState state) {
        int meta = ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
        if (meta == 2) {
            return 0;
        }
        if (meta == 3) {
            return EnumDyeColor.BLUE.func_176767_b();
        }
        if (meta == 4) {
            return 0;
        }
        if (meta == 5) {
            return 0;
        }
        if (meta == 15) {
            return 0;
        }
        return meta;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int bonus;
        int meta = ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
        int n = bonus = fortune > 0 ? random.nextInt(fortune + 1) + 1 : 1;
        if (meta == 2) {
            return 2 * bonus;
        }
        if (meta == 3) {
            return 4 + random.nextInt(5) * bonus;
        }
        if (meta == 4) {
            return 2 * bonus;
        }
        if (meta == 5) {
            return 4 + random.nextInt(2) * bonus;
        }
        if (meta == 15) {
            return 2 * bonus;
        }
        return this.func_149679_a(fortune, random);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
        if (meta == 2) {
            return Items.field_151044_h;
        }
        if (meta == 3) {
            return Items.field_151100_aR;
        }
        if (meta == 4) {
            return Items.field_151045_i;
        }
        if (meta == 5) {
            return Items.field_151137_ax;
        }
        if (meta == 15) {
            return Items.field_151166_bC;
        }
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata());
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata());
    }

    public static enum Type implements IStringSerializable
    {
        GOLD(0, "gold", 0, EnumRarity.COMMON),
        IRON(1, "iron", 0, EnumRarity.COMMON),
        COAL(2, "coal", 0, EnumRarity.COMMON),
        LAPIS(3, "lapis", 0, EnumRarity.COMMON),
        DIAMOND(4, "diamond", 1, EnumRarity.COMMON),
        REDSTONE(5, "redstone", 4, EnumRarity.COMMON),
        COPPER(6, "copper", 0, EnumRarity.COMMON),
        TIN(7, "tin", 0, EnumRarity.COMMON),
        SILVER(8, "silver", 4, EnumRarity.COMMON),
        LEAD(9, "lead", 0, EnumRarity.COMMON),
        ALUMINUM(10, "aluminum", 0, EnumRarity.COMMON),
        NICKEL(11, "nickel", 0, EnumRarity.COMMON),
        PLATINUM(12, "platinum", 4, EnumRarity.UNCOMMON),
        IRIDIUM(13, "iridium", 4, EnumRarity.UNCOMMON),
        MITHRIL(14, "mithril", 8, EnumRarity.RARE),
        EMERALD(15, "emerald", 0, EnumRarity.COMMON);

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final int light;
        private final EnumRarity rarity;

        private Type(int metadata, String name, int light, EnumRarity rarity) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
            this.rarity = rarity;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public int getLight() {
            return this.light;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

