/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;

public class NoiseGenUtil {
    private static Random random = new Random();

    public static double getNoise(long seed, int x, int y) {
        random.setSeed(NoiseGenUtil.simple_hash(new int[]{(int)seed, (int)(seed << 32), (int)Math.signum(y) * 512 + 512, (int)Math.signum(x) * 512 + 512, x, y}, 5));
        return random.nextDouble();
    }

    @Nonnull
    public static Random getRandom(int ... args) {
        return new Random(NoiseGenUtil.simple_hash(args, args.length));
    }

    public static long getSeed(int seed, int x, int y) {
        return NoiseGenUtil.simple_hash(new int[]{seed, (int)Math.signum(y) * 512 + 512, (int)Math.signum(x) * 512 + 512, x, y}, 5);
    }

    public static int simple_hash(int[] is, int count) {
        int hash = 80238287;
        for (int i = 0; i < count; ++i) {
            hash = hash << 4 ^ hash >> 28 ^ is[i] * 5449 % 130651;
        }
        return hash % 75327403;
    }

    public static double get2DNoise(long seed, int x, int z) {
        return Math.pow((80.0 * NoiseGenUtil.getOctave(seed, x, z, 112.0) + 20.0 * NoiseGenUtil.getOctave(seed, x, z, 68.0) + 6.0 * NoiseGenUtil.getOctave(seed, x, z, 34.0) + 4.0 * NoiseGenUtil.getOctave(seed, x, z, 21.0) + 2.0 * NoiseGenUtil.getOctave(seed, x, z, 11.0) + 1.0 * NoiseGenUtil.getOctave(seed, x, z, 4.0)) / 93.0, 1.6f);
    }

    public static double fastSin(double x) {
        if (x < -3.14159265) {
            x += 6.28318531;
        } else if (x > 3.14159265) {
            x -= 6.28318531;
        }
        if (x < 0.0) {
            return 1.27323954 * x + 0.405284735 * x * x;
        }
        return 1.27323954 * x - 0.405284735 * x * x;
    }

    public static double fastCos(double x) {
        if (x < -3.14159265) {
            x += 6.28318531;
        } else if (x > 3.14159265) {
            x -= 6.28318531;
        }
        x += 1.57079632;
        if (x > 3.14159265) {
            x -= 6.28318531;
        }
        if (x < 0.0) {
            return 1.27323954 * x + 0.405284735 * x * x;
        }
        return 1.27323954 * x - 0.405284735 * x * x;
    }

    public static double interpolate(double s, double e, double t) {
        double t2 = (1.0 - NoiseGenUtil.fastCos(t * 3.1415927410125732)) / 2.0;
        return s * (1.0 - t2) + e * t2;
    }

    public static double interpolate(double s, double e, double t, double phase, double mult) {
        double t2 = 1.0f - MathHelper.func_76134_b((float)((float)mult * ((float)t * (float)Math.PI + (float)phase))) / 2.0f;
        double coeff = (0.5 - Math.abs(0.5 - t)) / 0.5;
        double t3 = t * (1.0 - coeff) + t2 * coeff;
        return s * (1.0 - t3) + e * t3;
    }

    public static double lerp(double s, double e, double t) {
        return s * (1.0 - t) + e * t;
    }

    public static double bilinear(double ul, double ur, double dr, double dl, double t1, double t2) {
        return NoiseGenUtil.interpolate(NoiseGenUtil.interpolate(ul, ur, t1), NoiseGenUtil.interpolate(dl, dr, t1), t2);
    }

    public static double getOctave(long seed, double x, double y, double dimen) {
        return NoiseGenUtil.bilinear(NoiseGenUtil.getNoise(seed, (int)(Math.floor(x / dimen) * dimen), (int)(Math.floor(y / dimen) * dimen)), NoiseGenUtil.getNoise(seed, (int)(Math.floor(x / dimen) * dimen + dimen), (int)(Math.floor(y / dimen) * dimen)), NoiseGenUtil.getNoise(seed, (int)(Math.floor(x / dimen) * dimen + dimen), (int)(Math.floor(y / dimen) * dimen + dimen)), NoiseGenUtil.getNoise(seed, (int)(Math.floor(x / dimen) * dimen), (int)(Math.floor(y / dimen) * dimen + dimen)), Math.abs((x - Math.floor(x / dimen) * dimen) / dimen), Math.abs((y - Math.floor(y / dimen) * dimen) / dimen));
    }
}

