/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thaumcraft.handlers.expand;

import com.blamejared.ModTweaker;
import com.blamejared.compat.thaumcraft.handlers.aspects.CTAspectStack;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;

@ZenExpansion(value="crafttweaker.item.IItemStack")
@ModOnly(value="thaumcraft")
@ZenRegister
public class IItemAspectExpansion {
    @ZenMethod
    public static void setAspects(final IItemStack stack, final CTAspectStack ... aspects) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new BaseAction("Aspects"){

            public void apply() {
                AspectList list = new AspectList();
                for (CTAspectStack aspect : aspects) {
                    list.add(aspect.getInternal().getInternal(), aspect.getAmount());
                }
                ThaumcraftApi.registerObjectTag((ItemStack)InputHelper.toStack((IItemStack)stack), (AspectList)list);
            }

            public String describe() {
                return "Setting aspects on item: " + LogHelper.getStackDescription((IIngredient)stack) + " to: " + this.getAspects();
            }

            private String getAspects() {
                StringBuilder builder = new StringBuilder();
                for (CTAspectStack aspect : aspects) {
                    builder.append(aspect.getInternal().getInternal().getName()).append(", ");
                }
                return builder.reverse().deleteCharAt(0).deleteCharAt(0).reverse().toString();
            }
        });
    }

    @ZenMethod
    public static void removeAspects(final IItemStack stack, final CTAspectStack ... aspects) {
        ModTweaker.LATE_REMOVALS.add((IAction)new BaseAction("Aspects"){

            public void apply() {
                AspectList list = new AspectList(InputHelper.toStack((IItemStack)stack));
                for (CTAspectStack aspect : aspects) {
                    list.remove(aspect.getInternal().getInternal());
                }
                ThaumcraftApi.registerObjectTag((ItemStack)InputHelper.toStack((IItemStack)stack), (AspectList)list);
            }

            public String describe() {
                return "Removing aspects on item: " + LogHelper.getStackDescription((IIngredient)stack) + "," + this.getAspects();
            }

            private String getAspects() {
                StringBuilder builder = new StringBuilder();
                for (CTAspectStack aspect : aspects) {
                    builder.append(aspect.getInternal().getInternal().getName()).append(", ");
                }
                return builder.reverse().deleteCharAt(0).deleteCharAt(0).reverse().toString();
            }
        });
    }
}

