/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.jee.packets;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.helpers.IContainerCraftingPacket;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.WrapperInvItemHandler;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;

public class PacketJEIPatternRecipe
implements IMessage,
IMessageHandler<PacketJEIPatternRecipe, IMessage> {
    NBTTagCompound input;
    NBTTagCompound output;

    public PacketJEIPatternRecipe() {
    }

    public PacketJEIPatternRecipe(@Nonnull NBTTagCompound input, @Nullable NBTTagCompound output) {
        this.input = input;
        this.output = output;
    }

    public void fromBytes(ByteBuf buf) {
        this.input = ByteBufUtils.readTag((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.output = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.input);
        if (this.output != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.output);
        } else {
            buf.writeBoolean(false);
        }
    }

    public IMessage onMessage(PacketJEIPatternRecipe message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container con = player.field_71070_bA;
            ItemStack[] recipe = new ItemStack[9];
            ItemStack[] recipeOutput = null;
            for (int i = 0; i < recipe.length; ++i) {
                NBTTagCompound currentStack = (NBTTagCompound)message.input.func_74781_a("#" + i);
                recipe[i] = currentStack == null ? ItemStack.field_190927_a : new ItemStack(currentStack);
            }
            if (message.output != null) {
                recipeOutput = new ItemStack[3];
                NBTTagList outputList = message.output.func_150295_c("Outputs", 10);
                for (int i = 0; i < recipeOutput.length; ++i) {
                    recipeOutput[i] = new ItemStack(outputList.func_150305_b(i));
                }
            }
            if (con instanceof IContainerCraftingPacket && con instanceof ContainerPatternTerm) {
                IActionHost obj;
                IContainerCraftingPacket cct = (IContainerCraftingPacket)con;
                IGridNode node = cct.getNetworkNode();
                if (node == null && (obj = (IActionHost)cct.getActionSource().machine().get()) != null) {
                    node = obj.getActionableNode();
                }
                if (node != null) {
                    IGrid grid = node.getGrid();
                    if (grid == null) {
                        return;
                    }
                    IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
                    ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
                    IItemHandler craftMatrix = cct.getInventoryByName("crafting");
                    if (inv != null && recipe != null && security != null) {
                        for (int i = 0; i < craftMatrix.getSlots(); ++i) {
                            ItemStack currentItem = ItemStack.field_190927_a;
                            if (recipe[i] != null) {
                                currentItem = recipe[i].func_77946_l();
                            }
                            ItemHandlerUtil.setStackInSlot((IItemHandler)craftMatrix, (int)i, (ItemStack)currentItem);
                        }
                        if (recipeOutput == null) {
                            con.func_75130_a((IInventory)new WrapperInvItemHandler(craftMatrix));
                        }
                    }
                    if (recipeOutput != null && !((ContainerPatternTerm)con).isCraftingMode()) {
                        IItemHandler outputInv = cct.getInventoryByName("output");
                        for (int i = 0; i < recipeOutput.length; ++i) {
                            ItemHandlerUtil.setStackInSlot((IItemHandler)outputInv, (int)i, (ItemStack)recipeOutput[i]);
                        }
                    }
                }
            }
        });
        return null;
    }

    @Nonnull
    private ItemStack canUseInSlot(int slot, ItemStack is, ItemStack[][] recipe) {
        if (recipe != null && recipe[slot] != null) {
            for (ItemStack stack : recipe[slot]) {
                if (!is.func_77969_a(stack)) continue;
                return is;
            }
        }
        return ItemStack.field_190927_a;
    }
}

