/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity.device;

import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.processing.pancheon.IPancheonRecipe;
import net.minecraftforge.fluids.FluidStack;

public class Pancheon
extends DeviceProgressive<IPancheonRecipe> {
    private DeviceFluidSlot inputSlot;
    private DeviceFluidSlot topSlot;
    private DeviceFluidSlot bottomSlot;

    public Pancheon(GrowthcraftTileDeviceBase te, int fsInput, int fsTop, int fsBottom) {
        super(te);
        this.inputSlot = new DeviceFluidSlot(te, fsInput);
        this.topSlot = new DeviceFluidSlot(te, fsTop);
        this.bottomSlot = new DeviceFluidSlot(te, fsBottom);
    }

    @Override
    protected IPancheonRecipe loadRecipe() {
        return MilkRegistry.instance().pancheon().getRecipe(this.inputSlot.get());
    }

    @Override
    protected boolean canProcess() {
        IPancheonRecipe recipe = (IPancheonRecipe)this.getWorkingRecipe();
        if (recipe == null) {
            return false;
        }
        if (!this.inputSlot.hasEnough(recipe.getInputFluid())) {
            return false;
        }
        if (!this.topSlot.hasCapacityFor(recipe.getTopOutputFluid())) {
            return false;
        }
        return this.bottomSlot.hasCapacityFor(recipe.getBottomOutputFluid());
    }

    @Override
    protected void process(IPancheonRecipe recipe) {
        FluidStack bottom;
        this.inputSlot.consume(recipe.getInputFluid(), true);
        FluidStack top = recipe.getTopOutputFluid();
        if (top != null) {
            this.topSlot.fill(top, true);
        }
        if ((bottom = recipe.getBottomOutputFluid()) != null) {
            this.bottomSlot.fill(bottom, true);
        }
    }
}

