/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.fluids;

import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.definition.IMultiFluidStacks;
import growthcraft.core.shared.fluids.FluidTag;
import growthcraft.core.shared.fluids.FluidTest;
import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TaggedFluidStacks
implements IMultiFluidStacks {
    public int amount;
    private List<String> tags;
    private List<String> exclusionTags;
    private List<FluidTag> fluidTags;
    private List<FluidTag> exclusionFluidTags;
    private List<Fluid> fluidCache;
    private transient List<ItemStack> fluidContainers;

    public TaggedFluidStacks(int amt, @Nonnull List<String> ptags, @Nonnull List<String> pextags) {
        this.amount = amt;
        this.tags = ptags;
        this.exclusionTags = pextags;
        this.fluidTags = CoreRegistry.instance().fluidTags().expandTagNames(this.tags);
        this.exclusionFluidTags = CoreRegistry.instance().fluidTags().expandTagNames(this.exclusionTags);
    }

    public TaggedFluidStacks(int amt, String ... ptags) {
        this(amt, Arrays.asList(ptags), new ArrayList<String>());
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<String> getExclusionTags() {
        return this.exclusionTags;
    }

    public Collection<Fluid> getFluids() {
        if (this.fluidCache == null) {
            this.fluidCache = new ArrayList<Fluid>();
            this.fluidCache.addAll(CoreRegistry.instance().fluidDictionary().getFluidsByTags(this.fluidTags));
            this.fluidCache.removeAll(CoreRegistry.instance().fluidDictionary().getFluidsByTags(this.exclusionFluidTags));
        }
        return this.fluidCache;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<FluidStack> getFluidStacks() {
        Collection<Fluid> fluids = this.getFluids();
        ArrayList<FluidStack> result = new ArrayList<FluidStack>();
        for (Fluid fluid : fluids) {
            result.add(new FluidStack(fluid, this.amount));
        }
        return result;
    }

    @Override
    public boolean containsFluid(@Nullable Fluid expectedFluid) {
        if (!FluidTest.isValid(expectedFluid)) {
            return false;
        }
        for (Fluid fluid : this.getFluids()) {
            if (fluid != expectedFluid) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsFluidStack(@Nullable FluidStack stack) {
        if (!FluidTest.isValid(stack)) {
            return false;
        }
        Fluid expected = stack.getFluid();
        return this.containsFluid(expected);
    }

    @Override
    public List<ItemStack> getItemStacks() {
        if (this.fluidContainers == null) {
            this.fluidContainers = GrowthcraftFluidUtils.getFluidContainers(this.getFluidStacks());
        }
        return this.fluidContainers;
    }
}

