/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.effect;

import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.config.description.Describer;
import growthcraft.core.shared.effect.IPotionEffectFactory;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class SimplePotionEffectFactory
implements IPotionEffectFactory {
    private Potion potion;
    private int time;
    private int level;

    public SimplePotionEffectFactory(Potion potion, int tm, int lvl) {
        this.potion = potion;
        this.time = tm;
        this.level = lvl;
    }

    public Potion getPotion() {
        return this.potion;
    }

    public int getTime() {
        return this.time;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public PotionEffect createPotionEffect(World world, Entity entity, Random random, Object data) {
        return new PotionEffect(this.getPotion(), this.getTime(), this.getLevel());
    }

    @Override
    public void getDescription(List<String> list) {
        PotionEffect pe = this.createPotionEffect(null, null, null, null);
        Describer.getPotionEffectDescription(list, pe);
    }

    private void readFromNBT(NBTTagCompound data) {
        this.potion = Potion.func_188412_a((int)data.func_74762_e("potion_id"));
        this.time = data.func_74762_e("time");
        this.level = data.func_74762_e("level");
    }

    @Override
    public void readFromNBT(NBTTagCompound data, String name) {
        if (data.func_74764_b(name)) {
            NBTTagCompound subData = data.func_74775_l(name);
            this.readFromNBT(subData);
        }
    }

    private void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("potion_id", Potion.func_188409_a((Potion)this.getPotion()));
        data.func_74768_a("time", this.getTime());
        data.func_74768_a("level", this.getLevel());
    }

    @Override
    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound target = new NBTTagCompound();
        String factoryName = CoreRegistry.instance().getPotionEffectFactoryRegistry().getName(this.getClass());
        target.func_74778_a("__name__", factoryName);
        this.writeToNBT(target);
        data.func_74782_a(name, (NBTBase)target);
    }
}

