/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.definition;

import growthcraft.core.shared.definition.IFluidStackFactory;
import growthcraft.core.shared.legacy.FluidContainerRegistry;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidTypeDefinition<T extends Fluid>
implements IFluidStackFactory {
    protected T fluid;

    public FluidTypeDefinition(@Nonnull T obj) {
        this.fluid = obj;
    }

    @Nonnull
    public T getFluid() {
        return this.fluid;
    }

    @Override
    @Nonnull
    public FluidStack asFluidStack(int size) {
        return new FluidStack(this.getFluid(), size);
    }

    @Override
    @Nonnull
    public FluidStack asFluidStack() {
        return this.asFluidStack(1);
    }

    public boolean equals(Fluid other) {
        if (other == null) {
            return false;
        }
        return this.getFluid() == other;
    }

    public void register() {
        FluidRegistry.registerFluid(this.fluid);
    }

    public void registerBucketItem() {
        FluidContainerRegistry.addBucketForFluid(this.fluid);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer() {
        Item item = Item.func_150898_a((Block)this.fluid.getBlock());
        String modID = this.fluid.getBlock().getRegistryName().func_110624_b();
        final ModelResourceLocation modelResourceLocation = new ModelResourceLocation(modID + ":" + this.fluid.getUnlocalizedName().substring(6), this.fluid.getName());
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> modelResourceLocation);
        ModelLoader.setCustomStateMapper((Block)this.fluid.getBlock(), (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return modelResourceLocation;
            }
        });
    }
}

