/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmLogic;
import forestry.core.config.Config;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.farming.multiblock.IFarmControllerInternal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;

public class FarmLogicSlot
extends Widget {
    private final IFarmControllerInternal farmController;
    private final FarmDirection farmDirection;
    protected final ToolTip toolTip = new ToolTip(250){

        @Override
        public void refresh() {
            FarmLogicSlot.this.toolTip.clear();
            FarmLogicSlot.this.toolTip.add(FarmLogicSlot.this.getLogic().getName());
            FarmLogicSlot.this.toolTip.add("Fertilizer: " + Math.round((float)FarmLogicSlot.this.getLogic().getFertilizerConsumption() * Config.fertilizerModifier));
            FarmLogicSlot.this.toolTip.add("Water: " + FarmLogicSlot.this.getLogic().getWaterConsumption(FarmLogicSlot.this.farmController.getFarmLedgerDelegate().getHydrationModifier()));
        }
    };

    public FarmLogicSlot(IFarmControllerInternal farmController, WidgetManager manager, int xPos, int yPos, FarmDirection farmDirection) {
        super(manager, xPos, yPos);
        this.farmController = farmController;
        this.farmDirection = farmDirection;
    }

    private IFarmLogic getLogic() {
        return this.farmController.getFarmLogic(this.farmDirection);
    }

    private ItemStack getStackIndex() {
        return this.getLogic().getIconItemStack();
    }

    @Override
    public void draw(int startX, int startY) {
        if (!this.getStackIndex().func_190926_b()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            TextureManager textureManager = minecraft.func_110434_K();
            textureManager.func_110577_a(this.getLogic().getTextureMap());
            RenderItem renderItem = minecraft.func_175599_af();
            renderItem.func_175042_a(this.getStackIndex(), startX + this.xPos, startY + this.yPos);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            return this.toolTip;
        }
        return null;
    }
}

