/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.IBlockPosPredicate;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.api.genetics.IFlowerProvider;
import forestry.core.utils.TickHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class HasFlowersCache
implements INbtWritable,
INbtReadable {
    private static final String NBT_KEY = "hasFlowerCache";
    private static final String NBT_KEY_FLOWERS = "flowers";
    private int flowerCheckInterval;
    private final TickHelper tickHelper = new TickHelper();
    @Nullable
    private FlowerData flowerData;
    private final ArrayList<BlockPos> flowerCoords = new ArrayList();
    private final List<IBlockState> flowers = new ArrayList<IBlockState>();
    private boolean needsSync = false;

    public HasFlowersCache() {
        this.flowerCheckInterval = 200;
    }

    public HasFlowersCache(int checkInterval) {
        this.flowerCheckInterval = checkInterval;
    }

    public void update(IBee queen, IBeeHousing beeHousing) {
        int flowerCount;
        int ticksPerCheck;
        if (this.flowerData == null) {
            this.flowerData = new FlowerData(queen, beeHousing);
            this.flowerCoords.clear();
            this.flowers.clear();
        }
        World world = beeHousing.getWorldObj();
        this.tickHelper.onTick();
        if (!this.flowerCoords.isEmpty() && this.tickHelper.updateOnInterval(this.flowerCheckInterval)) {
            Iterator<BlockPos> iterator = this.flowerCoords.iterator();
            while (iterator.hasNext()) {
                BlockPos flowerPos = iterator.next();
                if (this.flowerData.flowerPredicate.test(world, flowerPos) || !world.func_175667_e(flowerPos)) continue;
                iterator.remove();
                this.flowers.clear();
                this.needsSync = true;
            }
        }
        if (this.tickHelper.updateOnInterval(ticksPerCheck = 1 + (flowerCount = this.flowerCoords.size()) * flowerCount)) {
            if (this.flowerData.areaIterator.hasNext()) {
                BlockPos.MutableBlockPos blockPos = this.flowerData.areaIterator.next();
                if (this.flowerData.flowerPredicate.test(world, (BlockPos)blockPos)) {
                    this.addFlowerPos(blockPos.func_185334_h());
                }
            } else {
                this.flowerData.resetIterator(queen, beeHousing);
            }
        }
    }

    public boolean hasFlowers() {
        return !this.flowerCoords.isEmpty();
    }

    public boolean needsSync() {
        boolean returnVal = this.needsSync;
        this.needsSync = false;
        return returnVal;
    }

    public void onNewQueen(IBee queen, IBeeHousing housing) {
        IBeeGenome genome;
        String flowerType;
        if (!(this.flowerData == null || this.flowerData.flowerType.equals(flowerType = (genome = queen.getGenome()).getFlowerProvider().getFlowerType()) && this.flowerData.territory.equals((Object)genome.getTerritory()))) {
            this.flowerData = new FlowerData(queen, housing);
            this.flowerCoords.clear();
            this.flowers.clear();
        }
    }

    public List<BlockPos> getFlowerCoords() {
        return Collections.unmodifiableList(this.flowerCoords);
    }

    public List<IBlockState> getFlowers(World world) {
        if (this.flowers.isEmpty() && !this.flowerCoords.isEmpty()) {
            this.flowers.clear();
            for (BlockPos flowerCoord : this.flowerCoords) {
                IBlockState blockState = world.func_180495_p(flowerCoord);
                this.flowers.add(blockState);
            }
        }
        return Collections.unmodifiableList(this.flowers);
    }

    public void addFlowerPos(BlockPos blockPos) {
        this.flowerCoords.add(blockPos);
        this.flowers.clear();
        this.needsSync = true;
    }

    public void forceLookForFlowers(IBee queen, IBeeHousing housing) {
        if (this.flowerData != null) {
            this.flowerCoords.clear();
            this.flowers.clear();
            this.flowerData.resetIterator(queen, housing);
            World world = housing.getWorldObj();
            while (this.flowerData.areaIterator.hasNext()) {
                BlockPos.MutableBlockPos blockPos = this.flowerData.areaIterator.next();
                if (!this.flowerData.flowerPredicate.test(world, (BlockPos)blockPos)) continue;
                this.addFlowerPos(blockPos.func_185334_h());
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        int[] flowersList;
        if (!nbttagcompound.func_74764_b(NBT_KEY)) {
            return;
        }
        NBTTagCompound hasFlowerCacheNBT = nbttagcompound.func_74775_l(NBT_KEY);
        this.flowerCoords.clear();
        if (hasFlowerCacheNBT.func_74764_b(NBT_KEY_FLOWERS) && (flowersList = hasFlowerCacheNBT.func_74759_k(NBT_KEY_FLOWERS)).length % 3 == 0) {
            int flowerCount = flowersList.length / 3;
            this.flowerCoords.ensureCapacity(flowerCount);
            for (int i = 0; i < flowerCount; ++i) {
                int index = i * 3;
                BlockPos flowerPos = new BlockPos(flowersList[index], flowersList[index + 1], flowersList[index + 2]);
                this.flowerCoords.add(flowerPos);
            }
            this.needsSync = true;
        }
        this.flowers.clear();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound hasFlowerCacheNBT = new NBTTagCompound();
        if (!this.flowerCoords.isEmpty()) {
            int[] flowersList = new int[this.flowerCoords.size() * 3];
            int i = 0;
            for (BlockPos flowerPos : this.flowerCoords) {
                flowersList[i] = flowerPos.func_177958_n();
                flowersList[i + 1] = flowerPos.func_177956_o();
                flowersList[i + 2] = flowerPos.func_177952_p();
                i += 3;
            }
            hasFlowerCacheNBT.func_74783_a(NBT_KEY_FLOWERS, flowersList);
        }
        nbttagcompound.func_74782_a(NBT_KEY, (NBTBase)hasFlowerCacheNBT);
        return nbttagcompound;
    }

    public void writeData(PacketBuffer data) {
        int size = this.flowerCoords.size();
        data.func_150787_b(size);
        if (size > 0) {
            for (BlockPos pos : this.flowerCoords) {
                data.func_150787_b(pos.func_177958_n());
                data.func_150787_b(pos.func_177956_o());
                data.func_150787_b(pos.func_177952_p());
            }
        }
    }

    public void readData(PacketBuffer data) {
        this.flowerCoords.clear();
        this.flowers.clear();
        for (int size = data.func_150792_a(); size > 0; --size) {
            BlockPos pos = new BlockPos(data.func_150792_a(), data.func_150792_a(), data.func_150792_a());
            this.flowerCoords.add(pos);
        }
    }

    private static class FlowerData {
        public final String flowerType;
        public final Vec3i territory;
        public final IBlockPosPredicate flowerPredicate;
        public Iterator<BlockPos.MutableBlockPos> areaIterator;

        public FlowerData(IBee queen, IBeeHousing beeHousing) {
            IFlowerProvider flowerProvider = queen.getGenome().getFlowerProvider();
            this.flowerType = flowerProvider.getFlowerType();
            this.territory = queen.getGenome().getTerritory();
            this.flowerPredicate = FlowerManager.flowerRegistry.createAcceptedFlowerPredicate(this.flowerType);
            this.areaIterator = FlowerManager.flowerRegistry.getAreaIterator(beeHousing, queen);
        }

        public void resetIterator(IBee queen, IBeeHousing beeHousing) {
            this.areaIterator = FlowerManager.flowerRegistry.getAreaIterator(beeHousing, queen);
        }
    }
}

