/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tweaker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.tweaker.XUTweaker;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class CrafttweakerMachineRecipe
implements IMachineRecipe {
    public final Machine machine;
    public final Map<String, IIngredient> inputs;
    public final Map<String, IIngredient> outputs;
    public final Map<String, Float> probabilities;
    public final int processingTime;
    public final int energy;

    public CrafttweakerMachineRecipe(Machine machine, Map<String, IIngredient> inputs, Map<String, IIngredient> outputs, Map<String, Float> probabilities, int energy, int processingTime) {
        this.machine = machine;
        this.inputs = inputs;
        this.outputs = outputs;
        this.probabilities = probabilities;
        this.processingTime = processingTime;
        this.energy = energy;
    }

    public <S extends MachineSlot> S getSlot(String s, Iterable<S> slotList) {
        for (MachineSlot s1 : slotList) {
            if (!s1.name.equals(s)) continue;
            return (S)s1;
        }
        throw new IllegalStateException();
    }

    public MachineSlot getInputSlot(String s) {
        return this.getSlot(s, Iterables.concat(this.machine.itemInputs, this.machine.fluidInputs));
    }

    public MachineSlot getOutputSlot(String s) {
        return this.getSlot(s, Iterables.concat(this.machine.itemOutputs, this.machine.fluidOutputs));
    }

    @Override
    public List<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>> getJEIInputItemExamples() {
        ImmutableMap.Builder fluidBuilder = ImmutableMap.builder();
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        this.inputs.forEach((slot, ingredient) -> {
            List liquids;
            MachineSlot inputSlot = this.getInputSlot((String)slot);
            if (inputSlot instanceof MachineSlotItem) {
                List items = ingredient.getItems();
                if (items != null) {
                    itemBuilder.put((Object)((MachineSlotItem)inputSlot), items.stream().map(XUTweaker::createItemStack).collect(Collectors.toList()));
                }
            } else if (inputSlot instanceof MachineSlotFluid && (liquids = ingredient.getLiquids()) != null) {
                fluidBuilder.put((Object)((MachineSlotFluid)inputSlot), liquids.stream().map(XUTweaker::createFluidStack).collect(Collectors.toList()));
            }
        });
        return ImmutableList.of((Object)Pair.of((Object)itemBuilder.build(), (Object)fluidBuilder.build()));
    }

    @Override
    public boolean allowInputItem(MachineSlotItem slot, ItemStack stack, Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        return this.matchesSlotItem(slot, stack) && this.checkExistingItems(existingItems, existingFluids);
    }

    @Override
    public boolean allowInputFluid(MachineSlotFluid slot, FluidStack stack, Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        return this.matchesSlotFluid(slot, stack) && this.checkExistingItems(existingItems, existingFluids);
    }

    public boolean checkExistingItems(Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        for (Map.Entry<MachineSlotItem, ItemStack> entry2 : existingItems.entrySet()) {
            if (!StackHelper.isNonNull(entry2.getValue()) || this.matchesSlotItem(entry2.getKey(), entry2.getValue())) continue;
            return false;
        }
        for (Map.Entry<MachineSlot, Object> entry3 : existingFluids.entrySet()) {
            if (this.matchesSlotFluid((MachineSlotFluid)entry3.getKey(), (FluidStack)entry3.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean matchesSlotFluid(MachineSlotFluid slot, FluidStack stack) {
        if (stack == null || !this.inputs.containsKey(slot.name)) {
            return false;
        }
        IIngredient iIngredient = this.inputs.get(slot.name);
        return iIngredient.matches(XUTweaker.getILiquidStack(stack));
    }

    public boolean matchesSlotItem(MachineSlotItem slot, ItemStack stack) {
        if (stack == null || !this.inputs.containsKey(slot.name)) {
            return false;
        }
        IIngredient iIngredient = this.inputs.get(slot.name);
        return iIngredient.matches(XUTweaker.getIItemStack(stack));
    }

    @Override
    public boolean matches(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        ItemStack stack;
        for (MachineSlotItem slotItem : this.machine.itemInputs) {
            stack = inputItems.get(slotItem);
            if (!(StackHelper.isNull(stack) ? !slotItem.optional || this.inputs.containsKey(slotItem.name) : !this.matchesSlotItem(slotItem, stack) || this.getAmountToConsume(slotItem) > StackHelper.getStacksize(stack))) continue;
            return false;
        }
        for (MachineSlotFluid slotFluid : this.machine.fluidInputs) {
            stack = inputFluids.get(slotFluid);
            if (!(stack == null ? !slotFluid.optional || this.inputs.containsKey(slotFluid.name) : !this.matchesSlotFluid(slotFluid, (FluidStack)stack) || this.getAmountToConsume(slotFluid) > stack.amount)) continue;
            return false;
        }
        return true;
    }

    private int getAmountToConsume(MachineSlot slot) {
        IIngredient iIngredient = this.inputs.get(slot.name);
        if (iIngredient == null) {
            return 1;
        }
        return iIngredient.getAmount();
    }

    @Override
    public Map<MachineSlotItem, ItemStack> getItemOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        HashMap<MachineSlotItem, ItemStack> map = new HashMap<MachineSlotItem, ItemStack>();
        this.outputs.forEach((s, ingredient) -> {
            List items;
            MachineSlot outputSlot = this.getOutputSlot((String)s);
            if (outputSlot instanceof MachineSlotItem && (items = ingredient.getItems()) != null && !items.isEmpty()) {
                ItemStack stack;
                if (items.size() == 1) {
                    stack = XUTweaker.createItemStack((IItemStack)items.iterator().next());
                } else {
                    IItemStack item;
                    stack = ItemStack.field_190927_a;
                    Set collect = inputItems.values().stream().map(ItemStack::func_77973_b).map(IForgeRegistryEntry.Impl::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::func_110624_b).collect(Collectors.toSet());
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext() && !collect.contains(Objects.requireNonNull((stack = XUTweaker.createItemStack(item = (IItemStack)iterator.next())).func_77973_b().getRegistryName()).func_110624_b())) {
                    }
                }
                map.put((MachineSlotItem)outputSlot, Objects.requireNonNull(stack));
            }
        });
        return map;
    }

    @Override
    public Map<MachineSlotFluid, FluidStack> getFluidOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        HashMap<MachineSlotFluid, FluidStack> map = new HashMap<MachineSlotFluid, FluidStack>();
        this.outputs.forEach((s, ingredient) -> {
            List liquids;
            MachineSlot outputSlot = this.getOutputSlot((String)s);
            if (outputSlot instanceof MachineSlotFluid && (liquids = ingredient.getLiquids()) != null && !liquids.isEmpty()) {
                FluidStack stack = XUTweaker.createFluidStack((ILiquidStack)liquids.iterator().next());
                map.put((MachineSlotFluid)outputSlot, stack);
            }
        });
        return map;
    }

    @Override
    public int getEnergyOutput(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.energy;
    }

    @Override
    public int getProcessingTime(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.processingTime;
    }

    @Override
    public Map<MachineSlotItem, ItemStack> getContainerItems(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        HashMap<MachineSlotItem, ItemStack> map = new HashMap<MachineSlotItem, ItemStack>();
        this.machine.itemInputs.forEach(slot -> map.put((MachineSlotItem)slot, ItemStack.field_190927_a));
        for (Map.Entry<MachineSlotItem, ItemStack> entry2 : inputItems.entrySet()) {
            IItemStack iItemStack;
            IIngredient iIngredient = this.inputs.get(entry2.getKey().name);
            if (iIngredient == null || !iIngredient.hasTransformers() || !(iIngredient instanceof IItemStack) || (iItemStack = iIngredient.applyTransform((IItemStack)iIngredient, null)) == null) continue;
            map.put(entry2.getKey(), XUTweaker.createItemStack(iItemStack));
        }
        return map;
    }

    @Override
    @Nullable
    public TObjectFloatMap<MachineSlot> getProbabilityModifier(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        TObjectFloatHashMap map = new TObjectFloatHashMap();
        this.probabilities.forEach((arg_0, arg_1) -> this.lambda$getProbabilityModifier$4((TObjectFloatMap)map, arg_0, arg_1));
        return map;
    }

    @Override
    public TObjectIntMap<MachineSlot> getAmountToConsume(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        TObjectIntHashMap map = new TObjectIntHashMap();
        inputItems.keySet().forEach(arg_0 -> CrafttweakerMachineRecipe.lambda$getAmountToConsume$5((TObjectIntMap)map, arg_0));
        inputFluids.keySet().forEach(arg_0 -> CrafttweakerMachineRecipe.lambda$getAmountToConsume$6((TObjectIntMap)map, arg_0));
        this.inputs.forEach((arg_0, arg_1) -> this.lambda$getAmountToConsume$7((TObjectIntMap)map, arg_0, arg_1));
        return map;
    }

    private /* synthetic */ void lambda$getAmountToConsume$7(TObjectIntMap map, String k, IIngredient i) {
        MachineSlot inputSlot = this.getInputSlot(k);
        map.put((Object)inputSlot, i.getAmount());
    }

    private static /* synthetic */ void lambda$getAmountToConsume$6(TObjectIntMap map, MachineSlotFluid s) {
        map.put((Object)s, 1);
    }

    private static /* synthetic */ void lambda$getAmountToConsume$5(TObjectIntMap map, MachineSlotItem s) {
        map.put((Object)s, 1);
    }

    private /* synthetic */ void lambda$getProbabilityModifier$4(TObjectFloatMap map, String name, Float chance) {
        map.put((Object)this.getOutputSlot(name), chance.floatValue());
    }
}

