/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.compatibility.StackHelper;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public abstract class SingleInputStackMatchRecipeBase
implements IMachineRecipe {
    public final MachineSlotItem inputSlot;
    final TObjectIntHashMap<MachineSlot> amount;

    public SingleInputStackMatchRecipeBase(MachineSlotItem inputSlot) {
        this.inputSlot = inputSlot;
        this.amount = new TObjectIntHashMap();
        this.amount.put((Object)this.inputSlot, 1);
    }

    @Override
    public List<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>> getJEIInputItemExamples() {
        ArrayList<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>> list = new ArrayList<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>>();
        Collection<ItemStack> values = this.getInputValues();
        values.stream().filter(StackHelper::isNonNull).forEach(stack -> list.add(Pair.of((Object)ImmutableMap.of((Object)this.inputSlot, (Object)ImmutableList.of((Object)stack)), (Object)ImmutableMap.of())));
        return list;
    }

    @Nonnull
    public abstract Collection<ItemStack> getInputValues();

    public abstract boolean matches(ItemStack var1);

    @Override
    public boolean allowInputFluid(MachineSlotFluid slot, FluidStack stack, Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        return false;
    }

    @Override
    public TObjectIntMap<MachineSlot> getAmountToConsume(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        return this.amount;
    }

    @Override
    public Map<MachineSlotItem, ItemStack> getContainerItems(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        HashMap<MachineSlotItem, ItemStack> map = new HashMap<MachineSlotItem, ItemStack>();
        map.put(this.inputSlot, this.getContainer(inputItems.get(this.inputSlot)));
        return map;
    }

    @Nullable
    public ItemStack getContainer(ItemStack stack) {
        return ForgeHooks.getContainerItem((ItemStack)stack);
    }

    @Override
    public boolean allowInputItem(MachineSlotItem slot, ItemStack stack, Map<MachineSlotItem, ItemStack> existingItems, Map<MachineSlotFluid, FluidStack> existingFluids) {
        return this.matches(stack);
    }

    @Override
    public boolean matches(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
        ItemStack stack = inputItems.get(this.inputSlot);
        return this.matches(stack);
    }
}

