/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.itemhandler.IItemHandlerCompat;
import com.rwtema.extrautils2.itemhandler.IItemHandlerModifiableCompat;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ItemStackHandlerBase
implements IItemHandlerCompat,
IItemHandlerModifiableCompat {
    @ItemStackNonNull
    public abstract ItemStack getStack(int var1);

    public abstract void setStack(int var1, ItemStack var2);

    @Override
    public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
        if (ItemStack.func_77989_b((ItemStack)this.getStack(slot), (ItemStack)stack)) {
            return;
        }
        this.setStack(slot, stack);
        this.onContentsChanged(slot);
    }

    @Override
    @ItemStackNonNull
    public ItemStack getStackInSlot(int slot) {
        return this.getStack(slot);
    }

    @Override
    @ItemStackNonNull
    public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (StackHelper.isNull(stack) || StackHelper.isEmpty(stack)) {
            return StackHelper.empty();
        }
        ItemStack existing = this.getStack(slot);
        int limit = this.getStackLimit(slot, stack);
        if (StackHelper.isNonNull(existing)) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= StackHelper.getStacksize(existing);
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = StackHelper.getStacksize(stack) > limit;
        if (!simulate) {
            if (StackHelper.isNull(existing)) {
                this.setStack(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                StackHelper.increase(existing, reachedLimit ? limit : StackHelper.getStacksize(stack));
                this.setStack(slot, existing);
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(StackHelper.getStacksize(stack) - limit)) : StackHelper.empty();
    }

    @Override
    @ItemStackNonNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return StackHelper.empty();
        }
        ItemStack existing = this.getStack(slot);
        if (StackHelper.isNull(existing)) {
            return StackHelper.empty();
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (StackHelper.getStacksize(existing) <= toExtract) {
            if (!simulate) {
                this.setStack(slot, null);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.setStack(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(StackHelper.getStacksize(existing) - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return stack.func_77976_d();
    }

    protected void onContentsChanged(int slot) {
    }
}

