/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.fairies;

import com.rwtema.extrautils2.fairies.Fairy;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Fairies {
    static final WeakHashMap<World, List<Fairy>> fairies = new WeakHashMap();

    public static void register(World world, Fairy fairy) {
        fairies.computeIfAbsent(world, world1 -> new LinkedList()).add(fairy);
        fairy.joinedWorld = true;
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        List<Fairy> list = fairies.get(event.world);
        if (list != null) {
            Iterator<Fairy> iterator = list.iterator();
            while (iterator.hasNext()) {
                Fairy fairy = iterator.next();
                if (fairy.dead) {
                    iterator.remove();
                    continue;
                }
                World world = event.world;
                if (!(world instanceof WorldServer)) continue;
                ((WorldServer)world).func_175739_a(EnumParticleTypes.REDSTONE, fairy.pos.x, fairy.pos.y, fairy.pos.z, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(Fairies.class);
    }
}

