/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.containers.ISlotItemFilter;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.ItemUpgrade;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.tileentities.TileEntityThermo;
import com.zuxelus.energycontrol.utils.ReactorHelper;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.reactor.IReactor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityRemoteThermo
extends TileEntityThermo
implements IEnergySink,
ISlotItemFilter {
    public static final int SLOT_CHARGER = 0;
    public static final int SLOT_CARD = 1;
    private static final double BASE_PACKET_SIZE = 32.0;
    private static final int BASE_STORAGE = 600;
    private static final int STORAGE_PER_UPGRADE = 10000;
    private static final int LOCATION_RANGE = 8;
    private int deltaX;
    private int deltaY;
    private int deltaZ;
    private double prevMaxStorage;
    private double maxStorage;
    private double prevMaxPacketSize;
    private double maxPacketSize;
    private int prevTier;
    private int tier;
    private int heat;
    private double energy;
    private boolean addedToEnet;

    public TileEntityRemoteThermo() {
        this.customName = "tile.remote_thermo.name";
        this.addedToEnet = false;
        this.maxStorage = 600.0;
        this.maxPacketSize = 32.0;
        this.tier = 1;
        this.deltaX = 0;
        this.deltaY = 0;
        this.deltaZ = 0;
        this.energy = 0.0;
        this.heat = 0;
    }

    public int getHeat() {
        return this.heat;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double value) {
        this.energy = value;
    }

    public void setTier(int value) {
        this.tier = value;
        if (!this.field_145850_b.field_72995_K && this.tier != this.prevTier) {
            this.notifyBlockUpdate();
        }
        this.prevTier = this.tier;
    }

    public void setMaxPacketSize(double value) {
        this.maxPacketSize = value;
        if (!this.field_145850_b.field_72995_K && this.maxPacketSize != this.prevMaxPacketSize) {
            this.notifyBlockUpdate();
        }
        this.prevMaxPacketSize = this.maxPacketSize;
    }

    public double getMaxStorage() {
        return this.maxStorage;
    }

    public void setMaxStorage(double value) {
        this.maxStorage = value;
        if (!this.field_145850_b.field_72995_K && this.maxStorage != this.prevMaxStorage) {
            this.notifyBlockUpdate();
        }
        this.prevMaxStorage = this.maxStorage;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("heat")) {
            this.heat = tag.func_74762_e("heat");
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy = tag.func_74769_h("energy");
        this.func_70296_d();
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74768_a("heat", this.heat);
        return tag;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74780_a("energy", this.energy);
        return tag;
    }

    public void onLoad() {
        if (!this.addedToEnet && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    @Override
    public void func_145843_s() {
        this.onChunkUnload();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    @Override
    protected void checkStatus() {
        int newStatus;
        this.func_70296_d();
        int newHeat = 0;
        if (this.energy >= (double)EnergyControl.config.remoteThermalMonitorEnergyConsumption) {
            BlockPos target;
            IReactor reactor = ReactorHelper.getReactorAt(this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n() + this.deltaX, this.field_174879_c.func_177956_o() + this.deltaY, this.field_174879_c.func_177952_p() + this.deltaZ));
            if (reactor == null && !this.func_70301_a(1).func_190926_b() && (target = new ItemCardReader(this.func_70301_a(1)).getTarget()) != null) {
                reactor = ReactorHelper.getReactor3x3(this.field_145850_b, target);
            }
            if (reactor != null) {
                if (this.tickRate == -1) {
                    this.tickRate = reactor.getTickRate() / 2;
                    if (this.tickRate == 0) {
                        this.tickRate = 1;
                    }
                    this.updateTicker = this.tickRate;
                }
                newStatus = (newHeat = reactor.getHeat()) >= this.getHeatLevel() ? 1 : 0;
            } else {
                newStatus = -1;
                if (!this.func_70301_a(1).func_190926_b() && (target = new ItemCardReader(this.func_70301_a(1)).getTarget()) != null) {
                    newHeat = ReactorHelper.getReactorHeat(this.field_145850_b, target);
                    int n = newHeat == -1 ? -1 : (newStatus = newHeat >= this.getHeatLevel() ? 1 : 0);
                    if (newHeat == -1) {
                        newHeat = 0;
                    }
                }
            }
        } else {
            newStatus = -2;
        }
        if (newStatus != this.status || newHeat != this.heat) {
            this.status = newStatus;
            this.heat = newHeat;
            this.notifyBlockUpdate();
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        }
    }

    @Override
    public void func_73660_a() {
        IElectricItem ielectricitem;
        super.func_73660_a();
        if (!this.addedToEnet) {
            this.onLoad();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int consumption = EnergyControl.config.remoteThermalMonitorEnergyConsumption;
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && this.energy < this.maxStorage && stack.func_77973_b() instanceof IElectricItem && (ielectricitem = (IElectricItem)stack.func_77973_b()).canProvideEnergy(stack)) {
            this.energy += ElectricItem.manager.discharge(stack, this.maxStorage - this.energy, this.tier, false, false, false);
        }
        this.energy = this.energy >= (double)consumption ? (this.energy -= (double)consumption) : 0.0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        int upgradeCountTransormer = 0;
        int upgradeCountStorage = 0;
        int upgradeCountRange = 0;
        for (int i = 2; i < 5; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77969_a(CrossModLoader.ic2.getItemStack("transformer"))) {
                upgradeCountTransormer += itemStack.func_190916_E();
                continue;
            }
            if (itemStack.func_77969_a(CrossModLoader.ic2.getItemStack("energy_storage"))) {
                upgradeCountStorage += itemStack.func_190916_E();
                continue;
            }
            if (!(itemStack.func_77973_b() instanceof ItemUpgrade) || itemStack.func_77952_i() != 0) continue;
            upgradeCountRange += itemStack.func_190916_E();
        }
        if (!this.func_70301_a(1).func_190926_b()) {
            BlockPos target = new ItemCardReader(this.func_70301_a(1)).getTarget();
            if (target != null) {
                this.deltaX = target.func_177958_n() - this.field_174879_c.func_177958_n();
                this.deltaY = target.func_177956_o() - this.field_174879_c.func_177956_o();
                this.deltaZ = target.func_177952_p() - this.field_174879_c.func_177952_p();
                if (upgradeCountRange > 7) {
                    upgradeCountRange = 7;
                }
                int range = 8 * (int)Math.pow(2.0, upgradeCountRange);
                if (Math.abs(this.deltaX) > range || Math.abs(this.deltaY) > range || Math.abs(this.deltaZ) > range) {
                    this.deltaZ = 0;
                    this.deltaY = 0;
                    this.deltaX = 0;
                }
            } else {
                this.deltaX = 0;
                this.deltaY = 0;
                this.deltaZ = 0;
            }
        } else {
            this.deltaX = 0;
            this.deltaY = 0;
            this.deltaZ = 0;
            this.status = -2;
        }
        upgradeCountTransormer = Math.min(upgradeCountTransormer, 4);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.tier = upgradeCountTransormer + 1;
            this.setTier(this.tier);
            this.maxPacketSize = 32.0 * Math.pow(4.0, upgradeCountTransormer);
            this.setMaxPacketSize(this.maxPacketSize);
            this.maxStorage = 600 + 10000 * upgradeCountStorage;
            this.setMaxStorage(this.maxStorage);
            if (this.energy > this.maxStorage) {
                this.energy = this.maxStorage;
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return 5;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        switch (slotIndex) {
            case 0: {
                IElectricItem item;
                return stack.func_77973_b() instanceof IElectricItem && (item = (IElectricItem)stack.func_77973_b()).canProvideEnergy(stack) && item.getTier(stack) <= this.tier;
            }
            case 1: {
                return stack.func_77973_b() instanceof ItemCardMain && (stack.func_77952_i() == 7 || stack.func_77952_i() == 8 || stack.func_77952_i() == 24);
            }
        }
        return stack.func_77969_a(CrossModLoader.ic2.getItemStack("transformer")) || stack.func_77969_a(CrossModLoader.ic2.getItemStack("energy_storage")) || stack.func_77973_b() instanceof ItemUpgrade && stack.func_77952_i() == 0;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing dir) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return Math.max(0.0, this.maxStorage - this.energy);
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.energy += amount;
        double left = 0.0;
        if (this.energy > this.maxStorage) {
            left = this.energy - this.maxStorage;
            this.energy = this.maxStorage;
        }
        return left;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

