/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.tileentities.ITilePacketHandler;
import com.zuxelus.energycontrol.tileentities.TileEntityFacing;
import com.zuxelus.energycontrol.tileentities.TileEntitySound;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;

public class TileEntityHowlerAlarm
extends TileEntityFacing
implements ITickable,
ITilePacketHandler {
    private static final String DEFAULT_SOUND_NAME = "default";
    private static final float BASE_SOUND_RANGE = 16.0f;
    private static final String SOUND_PREFIX = "energycontrol:alarm-";
    public int range;
    public boolean powered = false;
    public String soundName = "default";
    private String prevSoundName = "default";
    protected int updateTicker = 0;
    protected int tickRate = 60;
    private TileEntitySound sound;

    public TileEntityHowlerAlarm() {
        this.range = EnergyControl.config.howlerAlarmRange;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int r) {
        if (!this.field_145850_b.field_72995_K && this.range != r) {
            this.notifyBlockUpdate();
        }
        this.range = r;
    }

    public String getSoundName() {
        return this.soundName;
    }

    public void setSoundName(String name) {
        this.soundName = name;
        if (!this.field_145850_b.field_72995_K && !this.prevSoundName.equals(this.soundName)) {
            this.notifyBlockUpdate();
        }
        if (this.field_145850_b.field_72995_K && EnergyControl.instance.availableAlarms != null && !EnergyControl.instance.availableAlarms.contains(this.soundName)) {
            EnergyControl.logger.info(String.format("Can't set sound '%s' at %d,%d,%d, using default", this.soundName, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            this.soundName = DEFAULT_SOUND_NAME;
        }
        this.prevSoundName = this.soundName;
    }

    public boolean getPowered() {
        return this.powered;
    }

    public void updatePowered(boolean isPowered) {
        if (this.field_145850_b.field_72995_K) {
            this.powered = isPowered;
            this.checkStatus();
        }
    }

    private float getNormalizedRange() {
        if (this.field_145850_b.field_72995_K) {
            return (float)Math.min(this.range, EnergyControl.config.SMPMaxAlarmRange) / 16.0f;
        }
        return (float)this.range / 16.0f;
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("string")) break;
                this.setSoundName(tag.func_74779_i("string"));
                break;
            }
            case 2: {
                if (!tag.func_74764_b("value")) break;
                this.setRange(tag.func_74762_e("value"));
            }
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        this.powered = this.field_145850_b.func_175640_z(this.field_174879_c);
        tag.func_74757_a("powered", this.powered);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("soundName")) {
            this.soundName = this.prevSoundName = tag.func_74779_i("soundName");
        }
        if (tag.func_74764_b("range")) {
            this.range = tag.func_74762_e("range");
        }
        if (tag.func_74764_b("powered")) {
            this.updatePowered(tag.func_74767_n("powered"));
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74778_a("soundName", this.soundName);
        tag.func_74768_a("range", this.range);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    public void func_145843_s() {
        if (this.field_145850_b.field_72995_K && this.sound != null) {
            this.sound.stopAlarm();
        }
        super.func_145843_s();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.updateTicker-- > 0) {
                return;
            }
            this.updateTicker = this.tickRate;
            this.checkStatus();
        }
    }

    protected void checkStatus() {
        if (this.sound == null) {
            this.sound = new TileEntitySound();
        }
        if (this.powered && !this.sound.isPlaying()) {
            this.sound.playAlarm((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SOUND_PREFIX + this.soundName, this.getNormalizedRange(), true);
        }
        if (!this.powered && this.sound.isPlaying()) {
            this.sound.stopAlarm();
        }
    }

    private void notifyBlockUpdate() {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 2);
    }
}

