/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.network;

import com.zuxelus.energycontrol.tileentities.ITilePacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketTileEntity
implements IMessage,
IMessageHandler<PacketTileEntity, IMessage> {
    private int x;
    private int y;
    private int z;
    private NBTTagCompound tag;

    public PacketTileEntity() {
    }

    public PacketTileEntity(BlockPos pos, NBTTagCompound tag) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.tag = tag;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public IMessage onMessage(PacketTileEntity message, MessageContext ctx) {
        TileEntity te;
        if (ctx.side == Side.SERVER) {
            te = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(new BlockPos(message.x, message.y, message.z));
            if (!(te instanceof ITilePacketHandler)) {
                return null;
            }
            ((ITilePacketHandler)te).onServerMessageReceived(message.tag);
        }
        if (ctx.side == Side.CLIENT) {
            te = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(new BlockPos(message.x, message.y, message.z));
            if (!(te instanceof ITilePacketHandler)) {
                return null;
            }
            ((ITilePacketHandler)te).onClientMessageReceived(message.tag);
        }
        return null;
    }
}

