/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.network;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketClientSensor
implements IMessage,
IMessageHandler<PacketClientSensor, IMessage> {
    private int x;
    private int y;
    private int z;
    private byte slot;
    private String className;
    private Map<String, Object> fields;
    public static final int FIELD_DOUBLE = 1;
    public static final int FIELD_INT = 2;
    public static final int FIELD_STRING = 3;
    public static final int FIELD_BOOLEAN = 4;
    public static final int FIELD_TAG = 5;
    public static final int FIELD_NULL = 6;
    public static final int FIELD_LONG = 7;

    public PacketClientSensor() {
    }

    public PacketClientSensor(BlockPos pos, byte slot, String className, Map<String, Object> fields) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.slot = slot;
        this.className = className;
        this.fields = fields;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.slot = buf.readByte();
        this.className = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int fieldCount = buf.readShort();
        this.fields = new HashMap<String, Object>();
        block7: for (int i = 0; i < fieldCount; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            byte type = buf.readByte();
            switch (type) {
                case 2: {
                    this.fields.put(name, buf.readInt());
                    continue block7;
                }
                case 4: {
                    this.fields.put(name, buf.readBoolean());
                    continue block7;
                }
                case 7: {
                    this.fields.put(name, buf.readLong());
                    continue block7;
                }
                case 1: {
                    this.fields.put(name, buf.readDouble());
                    continue block7;
                }
                case 3: {
                    this.fields.put(name, ByteBufUtils.readUTF8String((ByteBuf)buf));
                    continue block7;
                }
                default: {
                    EnergyControl.logger.warn("Invalid field type in PacketClientSensor: %d", (Object)type);
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.slot);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.className);
        buf.writeShort(this.fields.size());
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Long) {
                buf.writeByte(7);
                buf.writeLong(((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                buf.writeByte(1);
                buf.writeDouble(((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Integer) {
                buf.writeByte(2);
                buf.writeInt(((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                buf.writeByte(3);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)value));
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            buf.writeByte(4);
            buf.writeBoolean(((Boolean)value).booleanValue());
        }
    }

    public IMessage onMessage(PacketClientSensor message, MessageContext ctx) {
        TileEntity tileEntity = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(new BlockPos(message.x, message.y, message.z));
        if (tileEntity instanceof TileEntityInfoPanel) {
            TileEntityInfoPanel panel = (TileEntityInfoPanel)tileEntity;
            ItemStack stack = panel.func_70301_a(message.slot);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCardMain)) {
                return null;
            }
            if (!stack.func_77973_b().getClass().getName().equals(message.className)) {
                EnergyControl.logger.warn("Class mismatch: '%s'!='%s'", (Object)message.className, (Object)stack.func_77973_b().getClass().getName());
                return null;
            }
            ItemCardReader helper = new ItemCardReader(stack);
            for (Map.Entry<String, Object> entry : message.fields.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Long) {
                    helper.setLong(name, (Long)value);
                    continue;
                }
                if (value instanceof Double) {
                    helper.setDouble(name, (Double)value);
                    continue;
                }
                if (value instanceof Integer) {
                    helper.setInt(name, (Integer)value);
                    continue;
                }
                if (value instanceof String) {
                    helper.setString(name, (String)value);
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                helper.setBoolean(name, (Boolean)value);
            }
        }
        return null;
    }
}

