/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.kits;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.api.IItemKit;
import com.zuxelus.energycontrol.items.ItemHelper;
import com.zuxelus.energycontrol.items.kits.ItemKitAppEng;
import com.zuxelus.energycontrol.items.kits.ItemKitBase;
import com.zuxelus.energycontrol.items.kits.ItemKitBigReactors;
import com.zuxelus.energycontrol.items.kits.ItemKitCounter;
import com.zuxelus.energycontrol.items.kits.ItemKitDraconic;
import com.zuxelus.energycontrol.items.kits.ItemKitEnergy;
import com.zuxelus.energycontrol.items.kits.ItemKitGalacticraft;
import com.zuxelus.energycontrol.items.kits.ItemKitGenerator;
import com.zuxelus.energycontrol.items.kits.ItemKitLiquid;
import com.zuxelus.energycontrol.items.kits.ItemKitLiquidAdvanced;
import com.zuxelus.energycontrol.items.kits.ItemKitReactor;
import com.zuxelus.energycontrol.items.kits.ItemKitToggle;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class ItemKitMain
extends Item {
    private static Map<Integer, IItemKit> kits = new HashMap<Integer, IItemKit>();

    public ItemKitMain() {
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.canRepair = false;
        this.func_77637_a(EnergyControl.creativeTab);
    }

    public final void registerKits() {
        this.register(new ItemKitEnergy());
        this.register(new ItemKitCounter());
        this.register(new ItemKitLiquid());
        this.register(new ItemKitGenerator());
        if (Loader.isModLoaded((String)"ic2")) {
            this.register(new ItemKitReactor());
        }
        this.register(new ItemKitLiquidAdvanced());
        this.register(new ItemKitToggle());
        if (Loader.isModLoaded((String)"draconicevolution")) {
            this.register(new ItemKitDraconic());
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.register(new ItemKitAppEng());
        }
        if (Loader.isModLoaded((String)"galacticraftcore") && Loader.isModLoaded((String)"galacticraftplanets")) {
            this.register(new ItemKitGalacticraft());
        }
        if (Loader.isModLoaded((String)"bigreactors")) {
            this.register(new ItemKitBigReactors());
        }
    }

    private void register(ItemKitBase item) {
        if (ItemKitMain.checkKit(item)) {
            kits.put(item.getDamage(), item);
        }
    }

    private static boolean checkKit(IItemKit item) {
        if (!kits.containsKey(item.getDamage())) {
            return true;
        }
        if (item.getDamage() <= 49) {
            EnergyControl.logger.warn(String.format("Kit %s was not registered. ID %d is already used for standard kit.", item.getUnlocalizedName(), item.getDamage()));
        } else {
            EnergyControl.logger.warn(String.format("Kit %s was not registered. ID %d is already used for extended kit.", item.getUnlocalizedName(), item.getDamage()));
        }
        return false;
    }

    public static final void registerKit(IItemKit item) {
        if (ItemKitMain.checkKit(item)) {
            if (item.getDamage() <= 49) {
                EnergyControl.logger.warn(String.format("Kit %s was not registered. Kit ID should be bigger than %d", item.getUnlocalizedName(), 49));
                return;
            }
            kits.put(item.getDamage(), item);
        }
    }

    public static final boolean containsKit(int i) {
        return kits.containsKey(i);
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77952_i();
        if (kits.containsKey(damage)) {
            return kits.get(damage).getUnlocalizedName();
        }
        return "";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Map.Entry<Integer, IItemKit> entry : kits.entrySet()) {
            Integer key = entry.getKey();
            items.add((Object)new ItemStack((Item)this, 1, key.intValue()));
        }
    }

    public boolean func_77645_m() {
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player == null || !(player instanceof EntityPlayerMP)) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() || stack.func_190916_E() != 1) {
            return EnumActionResult.PASS;
        }
        ItemStack sensorLocationCard = this.getItemKitBase(stack.func_77952_i()).getSensorCard(stack, ItemHelper.itemCard, player, world, pos);
        if (sensorLocationCard.func_190926_b()) {
            return EnumActionResult.PASS;
        }
        player.func_174820_d(player.field_71071_by.field_70461_c, sensorLocationCard);
        return EnumActionResult.SUCCESS;
    }

    public IItemKit getItemKitBase(int metadata) {
        if (kits.containsKey(metadata)) {
            return kits.get(metadata);
        }
        return null;
    }

    public static final void registerModels() {
        for (Map.Entry<Integer, IItemKit> entry : kits.entrySet()) {
            Integer key = entry.getKey();
            if (key > 49) continue;
            ItemHelper.registerItemModel(ItemHelper.itemKit, key, kits.get(key).getName());
        }
    }

    public static final void registerExtendedModels() {
        for (Map.Entry<Integer, IItemKit> entry : kits.entrySet()) {
            Integer key = entry.getKey();
            if (key <= 49) continue;
            ItemHelper.registerExternalItemModel(ItemHelper.itemKit, key, kits.get(key).getName());
        }
    }
}

