/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.gui.GuiInfoPanel;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.FMLClientHandler;

public class ItemCardSettingsReader {
    private ItemStack card;
    private TileEntityInfoPanel panel;
    private Map<String, Object> updateSet;
    private GuiInfoPanel gui;
    private byte slot;

    public ItemCardSettingsReader(ItemStack card, TileEntityInfoPanel panel, GuiInfoPanel gui, byte slot) {
        if (!(card.func_77973_b() instanceof ItemCardMain)) {
            EnergyControl.logger.error("ItemCardSettingsReader sould be used for ItemCard items.");
        }
        this.card = card;
        this.panel = panel;
        this.updateSet = new HashMap<String, Object>();
        this.gui = gui;
        this.slot = slot;
    }

    public void setInt(String name, Integer value) {
        this.updateSet.put(name, value);
    }

    public void setDouble(String name, double value) {
        this.updateSet.put(name, value);
    }

    public void setString(String name, String value) {
        this.updateSet.put(name, value);
    }

    public void setBoolean(String name, Boolean value) {
        this.updateSet.put(name, value);
    }

    public void commit() {
        if (!this.updateSet.isEmpty()) {
            NetworkHelper.setCardSettings(this.card, this.panel, this.updateSet, this.slot);
            this.updateSet = new HashMap<String, Object>();
        }
    }

    public void closeGui() {
        this.gui.prevCard = ItemStack.field_190927_a;
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)this.gui);
    }
}

