/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.network.NetworkHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardReader
implements ICardReader {
    private ItemStack card;
    private Map<String, Object> updateSet;

    public ItemCardReader(ItemStack card) {
        if (!(card.func_77973_b() instanceof ItemCardMain)) {
            EnergyControl.logger.error("CardReader should be used for card items only.");
        }
        this.card = card;
        this.updateSet = new HashMap<String, Object>();
    }

    @Override
    public BlockPos getTarget() {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return null;
        }
        return new BlockPos(nbtTagCompound.func_74762_e("x"), nbtTagCompound.func_74762_e("y"), nbtTagCompound.func_74762_e("z"));
    }

    @Override
    public void setInt(String name, Integer value) {
        NBTTagCompound nbtTagCompound = ItemStackHelper.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            Integer prevValue = nbtTagCompound.func_74762_e(name);
            if (prevValue == null || !prevValue.equals(value)) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        nbtTagCompound.func_74768_a(name, value.intValue());
    }

    @Override
    public Integer getInt(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return 0;
        }
        return nbtTagCompound.func_74762_e(name);
    }

    @Override
    public void setLong(String name, Long value) {
        NBTTagCompound nbtTagCompound = ItemStackHelper.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            Long prevValue = nbtTagCompound.func_74763_f(name);
            if (prevValue == null || !prevValue.equals(value)) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        nbtTagCompound.func_74772_a(name, value.longValue());
    }

    @Override
    public Long getLong(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return 0L;
        }
        return nbtTagCompound.func_74763_f(name);
    }

    @Override
    public void setDouble(String name, Double value) {
        NBTTagCompound nbtTagCompound = ItemStackHelper.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            Double prevValue = nbtTagCompound.func_74769_h(name);
            if (prevValue == null || prevValue != value) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        nbtTagCompound.func_74780_a(name, value.doubleValue());
    }

    @Override
    public Double getDouble(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return 0.0;
        }
        return nbtTagCompound.func_74769_h(name);
    }

    @Override
    public void setString(String name, String value) {
        if (name == null) {
            return;
        }
        NBTTagCompound nbtTagCompound = ItemStackHelper.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            String prevValue = nbtTagCompound.func_74779_i(name);
            if (prevValue == null || !prevValue.equals(value)) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        nbtTagCompound.func_74778_a(name, value);
    }

    @Override
    public String getString(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return "";
        }
        return nbtTagCompound.func_74779_i(name);
    }

    @Override
    public void setBoolean(String name, Boolean value) {
        NBTTagCompound nbtTagCompound = ItemStackHelper.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            Boolean prevValue = nbtTagCompound.func_74767_n(name);
            if (prevValue == null || !prevValue.equals(value)) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        nbtTagCompound.func_74757_a(name, value.booleanValue());
    }

    @Override
    public Boolean getBoolean(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return false;
        }
        return nbtTagCompound.func_74767_n(name);
    }

    @Override
    public void setTitle(String title) {
        this.setString("title", title);
    }

    @Override
    public String getTitle() {
        return this.getString("title");
    }

    @Override
    public CardState getState() {
        return CardState.fromInteger(this.getInt("state"));
    }

    @Override
    public void setState(CardState state) {
        if (state != null) {
            this.setInt("state", state.getIndex());
        } else {
            this.setInt("state", CardState.NO_TARGET.getIndex());
        }
    }

    @Override
    public boolean hasField(String field) {
        return ItemStackHelper.getTagCompound(this.card).func_74764_b(field);
    }

    @Override
    public void updateClient(TileEntity panel, int slot) {
        if (!this.updateSet.isEmpty()) {
            NetworkHelper.setSensorCardField(panel, slot, this.updateSet);
        }
    }

    @Override
    public void setTag(String name, NBTTagCompound value) {
        NBTTagCompound nbtTagCompound = ItemStackHelper.getTagCompound(this.card);
        if (nbtTagCompound.func_74764_b(name)) {
            NBTBase prevValue = nbtTagCompound.func_74781_a(name);
            if (prevValue == null || !prevValue.equals((Object)value)) {
                this.updateSet.put(name, value);
            }
        } else {
            this.updateSet.put(name, value);
        }
        if (value == null) {
            nbtTagCompound.func_82580_o(name);
        } else {
            nbtTagCompound.func_74782_a(name, (NBTBase)value);
        }
    }

    @Override
    public NBTTagCompound getTag(String name) {
        NBTTagCompound nbtTagCompound = this.card.func_77978_p();
        if (nbtTagCompound == null) {
            return null;
        }
        return (NBTTagCompound)nbtTagCompound.func_74781_a(name);
    }

    public void clearField(String name) {
        NBTTagCompound nbtTagCompound = ItemStackHelper.getTagCompound(this.card);
        nbtTagCompound.func_82580_o(name);
    }

    @Override
    public int getCardCount() {
        return this.getInt("cardCount");
    }

    @Override
    public int getCardType() {
        return this.card.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public static List<PanelString> getStateMessage(CardState state) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        PanelString line = new PanelString();
        switch (state) {
            case OUT_OF_RANGE: {
                line.textCenter = I18n.func_135052_a((String)"msg.ec.InfoPanelOutOfRange", (Object[])new Object[0]);
                break;
            }
            case INVALID_CARD: {
                line.textCenter = I18n.func_135052_a((String)"msg.ec.InfoPanelInvalidCard", (Object[])new Object[0]);
                break;
            }
            case NO_TARGET: {
                line.textCenter = I18n.func_135052_a((String)"msg.ec.InfoPanelNoTarget", (Object[])new Object[0]);
                break;
            }
            case CUSTOM_ERROR: {
                break;
            }
            case OK: {
                break;
            }
        }
        result.add(line);
        return result;
    }

    @Override
    public List<PanelString> getTitleList() {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        String title = this.getTitle();
        if (title != null && !title.isEmpty()) {
            PanelString titleString = new PanelString();
            titleString.textCenter = title;
            result.add(0, titleString);
        }
        return result;
    }

    public List<PanelString> getAllData() {
        NBTTagCompound nbt = this.card.func_77978_p();
        if (nbt == null) {
            return null;
        }
        nbt = this.card.func_77978_p().func_74737_b();
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        if (nbt.func_74764_b("title") && nbt.func_74781_a("title").func_74732_a() == 8) {
            String title = nbt.func_74779_i("title");
            if (!title.equals("")) {
                result.add(new PanelString(String.format("title : %s", title)));
            }
            nbt.func_82580_o("title");
        }
        if (nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z") && nbt.func_74781_a("x").func_74732_a() == 3 && nbt.func_74781_a("y").func_74732_a() == 3 && nbt.func_74781_a("z").func_74732_a() == 3) {
            result.add(new PanelString(String.format("xyz : %s %s %s", nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"))));
            nbt.func_82580_o("x");
            nbt.func_82580_o("y");
            nbt.func_82580_o("z");
        }
        if (nbt.func_74764_b("cardCount") && nbt.func_74781_a("cardCount").func_74732_a() == 3) {
            int count = nbt.func_74762_e("cardCount");
            result.add(new PanelString(String.format("cardCount : %s", count)));
            nbt.func_82580_o("cardCount");
            for (int i = 0; i < count; ++i) {
                String[] value = new String[]{String.format("_%dx", i), String.format("_%dy", i), String.format("_%dz", i)};
                if (!nbt.func_74764_b(value[0]) || !nbt.func_74764_b(value[1]) || !nbt.func_74764_b(value[2]) || nbt.func_74781_a(value[0]).func_74732_a() != 3 || nbt.func_74781_a(value[1]).func_74732_a() != 3 || nbt.func_74781_a(value[2]).func_74732_a() != 3) continue;
                result.add(new PanelString(String.format("_%dxyz : %s %s %s", i, nbt.func_74762_e(value[0]), nbt.func_74762_e(value[1]), nbt.func_74762_e(value[2]))));
                nbt.func_82580_o(value[0]);
                nbt.func_82580_o(value[1]);
                nbt.func_82580_o(value[2]);
            }
        }
        for (String name : nbt.func_150296_c()) {
            NBTBase tag = nbt.func_74781_a(name);
            result.add(new PanelString(String.format("%s : %s", name, tag.toString())));
        }
        return result;
    }
}

