/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.entities.EntityTechArrow;
import com.zuxelus.energycontrol.network.NetworkHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemNanoBow
extends ItemBow {
    static final int NORMAL = 1;
    static final int RAPID = 2;
    static final int SPREAD = 3;
    static final int SNIPER = 4;
    static final int FLAME = 5;
    static final int EXPLOSIVE = 6;
    static final int[] CHARGE = new int[]{300, 150, 400, 1000, 200, 800};

    public ItemNanoBow() {
        this.func_77637_a(EnergyControl.creativeTab);
        this.func_77664_n();
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        float f;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        NBTTagCompound nbt = ItemStackHelper.getOrCreateNbtData(stack);
        int mode = nbt.func_74762_e("bowMode");
        EntityPlayer player = (EntityPlayer)entity;
        int charge = this.func_77626_a(stack) - timeLeft;
        if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)player, (int)charge, (boolean)true)) < 0) {
            return;
        }
        if (mode == 2) {
            charge *= 2;
        }
        if ((double)(f = ItemNanoBow.getArrowVelocity(charge)) < 0.1) {
            return;
        }
        if (!world.field_72995_K) {
            int j;
            EntityTechArrow arrow = new EntityTechArrow(world, (EntityLivingBase)player);
            arrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
            if (f == 1.5f) {
                arrow.func_70243_d(true);
            }
            if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if (mode == 1 && arrow.func_70241_g()) {
                j += 3;
            } else if (mode == 2 && arrow.func_70241_g()) {
                ++j;
            } else if (mode == 4 && arrow.func_70241_g()) {
                j += 8;
            }
            if (j > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
            if (mode == 1 && arrow.func_70241_g()) {
                ++k;
            } else if (mode == 4 && arrow.func_70241_g()) {
                k += 5;
            }
            if (k > 0) {
                arrow.func_70240_a(k);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                arrow.func_70015_d(100);
            }
            if (mode == 5 && arrow.func_70241_g()) {
                arrow.func_70015_d(2000);
            }
            if (mode == 6 && arrow.func_70241_g()) {
                arrow.setExplosive(true);
            }
            arrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
            switch (mode) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    this.discharge(stack, CHARGE[mode - 1], (EntityLivingBase)player);
                    world.func_72838_d((Entity)arrow);
                    break;
                }
                case 3: {
                    this.discharge(stack, 350.0, (EntityLivingBase)player);
                    world.func_72838_d((Entity)arrow);
                    if (!arrow.func_70241_g()) break;
                    EntityTechArrow arrow2 = new EntityTechArrow(world, (EntityLivingBase)player);
                    arrow2.func_184547_a((Entity)player, player.field_70125_A + 2.0f, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    arrow2.func_70243_d(true);
                    arrow2.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    EntityTechArrow arrow3 = new EntityTechArrow(world, (EntityLivingBase)player);
                    arrow3.func_184547_a((Entity)player, player.field_70125_A - 2.0f, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    arrow3.func_70243_d(true);
                    arrow3.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    EntityTechArrow arrow4 = new EntityTechArrow(world, (EntityLivingBase)player);
                    arrow4.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z + 2.0f, 0.0f, f * 3.0f, 1.0f);
                    arrow4.func_70243_d(true);
                    arrow4.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    EntityTechArrow arrow5 = new EntityTechArrow(world, (EntityLivingBase)player);
                    arrow5.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z - 2.0f, 0.0f, f * 3.0f, 1.0f);
                    arrow5.func_70243_d(true);
                    arrow5.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    world.func_72838_d((Entity)arrow2);
                    world.func_72838_d((Entity)arrow3);
                    world.func_72838_d((Entity)arrow4);
                    world.func_72838_d((Entity)arrow5);
                }
            }
        }
        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        player.func_71029_a(StatList.func_188057_b((Item)this));
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        return (f = (f * f + f * 2.0f) / 3.0f) > 1.5f ? 1.5f : f;
    }

    public int func_77626_a(ItemStack stack) {
        NBTTagCompound nbt = ItemStackHelper.getOrCreateNbtData(stack);
        switch (nbt.func_74762_e("bowMode")) {
            case 4: 
            case 6: {
                return 144000;
            }
            case 2: {
                return 18000;
            }
        }
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ActionResult result = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)true);
        if (result != null) {
            return result;
        }
        NBTTagCompound nbt = ItemStackHelper.getOrCreateNbtData(stack);
        int mode = nbt.func_74762_e("bowMode");
        if (!world.field_72995_K && this.isModeSwitchKeyDown(player) && nbt.func_74771_c("toggleTimer") == 0) {
            byte toggle = 10;
            nbt.func_74774_a("toggleTimer", toggle);
            if (++mode > 6) {
                mode -= 6;
            }
            nbt.func_74768_a("bowMode", mode);
            NetworkHelper.chatMessage(player, "info.modeenabled", 1, mode - 1);
            return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        if (this.canUse(stack, CHARGE[mode - 1])) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        int mode;
        NBTTagCompound nbt = ItemStackHelper.getOrCreateNbtData(stack);
        byte toggle = nbt.func_74771_c("toggleTimer");
        if (toggle > 0) {
            toggle = (byte)(toggle - 1);
            nbt.func_74774_a("toggleTimer", toggle);
        }
        if ((mode = nbt.func_74762_e("bowMode")) == 0) {
            nbt.func_74768_a("bowMode", 1);
        }
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        int j;
        NBTTagCompound nbt = ItemStackHelper.getOrCreateNbtData(stack);
        int mode = nbt.func_74762_e("bowMode");
        if (mode == 2 && (j = this.func_77626_a(stack) - count) >= 10 && this.canUse(stack, CHARGE[1])) {
            player.func_184597_cx();
        }
    }

    protected abstract void discharge(ItemStack var1, double var2, EntityLivingBase var4);

    protected abstract boolean canUse(ItemStack var1, double var2);

    protected abstract boolean isModeSwitchKeyDown(EntityPlayer var1);

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.UNCOMMON;
    }

    public int getDefaultMaxCharge() {
        return 40000;
    }

    public int getDefaultTier() {
        return 2;
    }

    public int getDefaultTransferLimit() {
        return 128;
    }
}

