/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui.controls;

import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityHowlerAlarm;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiHowlerAlarmListBox
extends GuiButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol:textures/gui/gui_howler_alarm.png");
    private static final int BASIC_X_OFFSET = 2;
    private static final int BASIC_Y_OFFSET = 2;
    private static final int SCROLL_WIDTH = 10;
    private static final int SCROLL_BUTTON_HEIGHT = 8;
    public int fontColor;
    public int selectedColor;
    public int selectedFontColor;
    private int scrollTop;
    private List<String> items;
    private TileEntityHowlerAlarm alarm;
    public int lineHeight;
    private int sliderHeight;
    public boolean dragging;
    private int sliderY;
    private int dragDelta;

    public GuiHowlerAlarmListBox(int id, int left, int top, int width, int height, List<String> items, TileEntityHowlerAlarm alarm) {
        super(id, left, top, width, height, "");
        this.items = items;
        this.alarm = alarm;
        this.fontColor = 0x404040;
        this.selectedColor = -12566464;
        this.selectedFontColor = 0xA0A0A0;
        this.scrollTop = 0;
        this.lineHeight = 0;
        this.sliderHeight = 0;
        this.dragging = false;
        this.dragDelta = 0;
    }

    private void scrollTo(int pos) {
        int max;
        this.scrollTop = pos;
        if (this.scrollTop < 0) {
            this.scrollTop = 0;
        }
        if ((max = this.lineHeight * this.items.size() + 2 - this.field_146121_g) < 0) {
            max = 0;
        }
        if (this.scrollTop > max) {
            this.scrollTop = max;
        }
    }

    public void scrollUp() {
        this.scrollTop -= 8;
        if (this.scrollTop < 0) {
            this.scrollTop = 0;
        }
    }

    public void scrollDown() {
        this.scrollTop += 8;
        int max = this.lineHeight * this.items.size() + 2 - this.field_146121_g;
        if (max < 0) {
            max = 0;
        }
        if (this.scrollTop > max) {
            this.scrollTop = max;
        }
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.dragging) {
            int pos = (mouseY - this.field_146129_i - 8 - this.dragDelta) * (this.lineHeight * this.items.size() + 2 - this.field_146121_g) / Math.max(this.field_146121_g - 16 - this.sliderHeight, 1);
            this.scrollTo(pos);
        }
        FontRenderer fontRenderer = mc.field_71466_p;
        String currentItem = this.alarm.getSoundName();
        if (this.lineHeight == 0) {
            float scale;
            this.lineHeight = fontRenderer.field_78288_b + 2;
            if (this.scrollTop == 0) {
                int rowsPerHeight = this.field_146121_g / this.lineHeight;
                int currentIndex = this.items.indexOf(currentItem);
                if (currentIndex >= rowsPerHeight) {
                    this.scrollTop = (currentIndex + 1) * this.lineHeight + 2 - this.field_146121_g;
                }
            }
            if ((scale = (float)this.field_146121_g / ((float)this.lineHeight * (float)this.items.size() + 2.0f)) > 1.0f) {
                scale = 1.0f;
            }
            this.sliderHeight = Math.round(scale * (float)(this.field_146121_g - 16));
            if (this.sliderHeight < 4) {
                this.sliderHeight = 4;
            }
        }
        int rowTop = 2;
        GL11.glEnable((int)3089);
        ScaledResolution scaler = new ScaledResolution(mc);
        GL11.glScissor((int)(this.field_146128_h * scaler.func_78325_e()), (int)(mc.field_71440_d - (this.field_146129_i + this.field_146121_g) * scaler.func_78325_e()), (int)((this.field_146120_f - 10) * scaler.func_78325_e()), (int)(this.field_146121_g * scaler.func_78325_e()));
        for (String row : this.items) {
            if (row.equals(currentItem)) {
                GuiHowlerAlarmListBox.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + rowTop - this.scrollTop - 1), (int)(this.field_146128_h + this.field_146120_f - 10), (int)(this.field_146129_i + rowTop - this.scrollTop + this.lineHeight - 1), (int)this.selectedColor);
                fontRenderer.func_78276_b(row, this.field_146128_h + 2, this.field_146129_i + rowTop - this.scrollTop, this.selectedFontColor);
            } else {
                fontRenderer.func_78276_b(row, this.field_146128_h + 2, this.field_146129_i + rowTop - this.scrollTop, this.fontColor);
            }
            rowTop += this.lineHeight;
        }
        GL11.glDisable((int)3089);
        int sliderX = this.field_146128_h + this.field_146120_f - 10 + 1;
        this.sliderY = this.field_146129_i + 8 + (this.field_146121_g - 16 - this.sliderHeight) * this.scrollTop / (this.lineHeight * this.items.size() + 2 - this.field_146121_g);
        mc.func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(sliderX, this.sliderY, 131, 16, 9, 1);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)sliderX, (double)(this.sliderY + this.sliderHeight - 1), (double)this.field_73735_i).func_187315_a(0.51171875, 0.0703125).func_181675_d();
        bufferbuilder.func_181662_b((double)(sliderX + 10 - 1), (double)(this.sliderY + this.sliderHeight - 1), (double)this.field_73735_i).func_187315_a(0.546875, 0.0703125).func_181675_d();
        bufferbuilder.func_181662_b((double)(sliderX + 10 - 1), (double)(this.sliderY + 1), (double)this.field_73735_i).func_187315_a(0.546875, 0.06640625).func_181675_d();
        bufferbuilder.func_181662_b((double)sliderX, (double)(this.sliderY + 1), (double)this.field_73735_i).func_187315_a(0.51171875, 0.06640625).func_181675_d();
        tessellator.func_78381_a();
        this.func_73729_b(sliderX, this.sliderY + this.sliderHeight - 1, 131, 19, 9, 1);
    }

    private void setCurrent(int targetY) {
        if (this.lineHeight == 0) {
            return;
        }
        int itemIndex = (targetY - 2 - this.field_146129_i + this.scrollTop) / this.lineHeight;
        if (itemIndex >= this.items.size()) {
            itemIndex = this.items.size() - 1;
        }
        String newSound = this.items.get(itemIndex);
        if (this.alarm.func_145831_w().field_72995_K && !newSound.equals(this.alarm.getSoundName())) {
            NetworkHelper.updateSeverTileEntity(this.alarm.func_174877_v(), 1, newSound);
            this.alarm.setSoundName(newSound);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            if (mouseX > this.field_146128_h + this.field_146120_f - 10) {
                if (mouseY - this.field_146129_i < 8) {
                    this.scrollUp();
                } else if (this.field_146121_g + this.field_146129_i - mouseY < 8) {
                    this.scrollDown();
                } else if (mouseY >= this.sliderY && mouseY <= this.sliderY + this.sliderHeight) {
                    this.dragging = true;
                    this.dragDelta = mouseY - this.sliderY;
                }
            } else {
                this.setCurrent(mouseY);
                return true;
            }
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        super.func_146118_a(mouseX, mouseY);
        this.dragging = false;
    }
}

