/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.api.ICardGui;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.containers.ContainerBase;
import com.zuxelus.energycontrol.gui.GuiScreenColor;
import com.zuxelus.energycontrol.gui.controls.CompactButton;
import com.zuxelus.energycontrol.gui.controls.GuiInfoPanelCheckBox;
import com.zuxelus.energycontrol.gui.controls.GuiInfoPanelShowLabels;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.items.cards.ItemCardSettingsReader;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiInfoPanel
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol:textures/gui/gui_info_panel.png");
    protected String name;
    private TileEntityInfoPanel panel;
    public ItemStack prevCard;
    protected GuiTextField textboxTitle;
    protected byte activeTab;
    protected boolean modified;
    public boolean isColored;

    public GuiInfoPanel(ContainerBase container) {
        super((Container)container);
        this.field_147000_g = 201;
        this.panel = (TileEntityInfoPanel)container.te;
        this.name = I18n.func_135052_a((String)"tile.info_panel.name", (Object[])new Object[0]);
        this.modified = false;
        this.isColored = !this.panel.getColored();
        this.prevCard = ItemStack.field_190927_a;
        this.activeTab = 0;
    }

    protected void initControls() {
        ItemStack stack = (ItemStack)this.panel.getCards().get(0);
        if (stack.equals(this.prevCard) && this.panel.getColored() == this.isColored) {
            return;
        }
        this.field_146292_n.clear();
        this.prevCard = stack;
        this.isColored = this.panel.getColored();
        this.func_189646_b(new GuiInfoPanelShowLabels(0, this.field_147003_i + this.field_146999_f - 25, this.field_147009_r + 42, this.panel));
        int delta = 0;
        if (this.isColored) {
            this.func_189646_b(new CompactButton(112, this.field_147003_i + this.field_146999_f - 25, this.field_147009_r + 55, 18, 12, "T"));
            delta = 15;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCardMain) {
            int slot = this.panel.getCardSlot(stack);
            if (stack.func_77952_i() == 18) {
                this.func_189646_b(new CompactButton(111, this.field_147003_i + this.field_146999_f - 25, this.field_147009_r + 55 + delta, 18, 12, "..."));
            }
            List<PanelSetting> settingsList = ItemCardMain.getSettingsList(stack);
            int hy = this.field_146289_q.field_78288_b + 1;
            int y = 1;
            int x = this.field_147003_i + 24;
            if (settingsList != null) {
                for (PanelSetting panelSetting : settingsList) {
                    this.func_189646_b(new GuiInfoPanelCheckBox(0, x + 4, this.field_147009_r + 28 + hy * y, panelSetting, this.panel, slot, this.field_146289_q));
                    ++y;
                }
            }
            if (!this.modified) {
                this.textboxTitle = new GuiTextField(0, this.field_146289_q, 7, 16, 162, 18);
                this.textboxTitle.func_146195_b(true);
                this.textboxTitle.func_146180_a(new ItemCardReader(stack).getTitle());
            }
        } else {
            this.modified = false;
            this.textboxTitle = null;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initControls();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.name, (this.field_146999_f - this.field_146289_q.func_78256_a(this.name)) / 2, 6, 0x404040);
        if (this.textboxTitle != null) {
            this.textboxTitle.func_146194_f();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.textboxTitle != null) {
            boolean focused = this.textboxTitle.func_146206_l();
            this.textboxTitle.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
            if (this.textboxTitle.func_146206_l() != focused) {
                this.updateTitle();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.textboxTitle != null) {
            this.textboxTitle.func_146178_a();
        }
        this.initControls();
    }

    protected void updateTitle() {
        if (this.textboxTitle == null) {
            return;
        }
        if (this.panel.func_145831_w().field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 4);
            tag.func_74768_a("slot", (int)this.activeTab);
            tag.func_74778_a("title", this.textboxTitle.func_146179_b());
            NetworkHelper.updateSeverTileEntity(this.panel.func_174877_v(), tag);
            ItemStack card = this.panel.func_70301_a(this.activeTab);
            if (!card.func_190926_b() && card.func_77973_b() instanceof ItemCardMain) {
                new ItemCardReader(card).setTitle(this.textboxTitle.func_146179_b());
            }
        }
    }

    public void func_146281_b() {
        this.updateTitle();
        super.func_146281_b();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 112) {
            GuiScreenColor colorGui = new GuiScreenColor(this, this.panel);
            this.field_146297_k.func_147108_a((GuiScreen)colorGui);
        } else if (button.field_146127_k == 111) {
            ItemStack card = (ItemStack)this.panel.getCards().get(0);
            if (card.func_190926_b()) {
                return;
            }
            if (card.func_77973_b() instanceof ItemCardMain && card.func_77952_i() == 18) {
                ItemCardReader reader = new ItemCardReader(card);
                ICardGui guiObject = ItemCardMain.getSettingsScreen(reader);
                if (!(guiObject instanceof GuiScreen)) {
                    EnergyControl.logger.warn("Invalid card, getSettingsScreen method should return GuiScreen object");
                    return;
                }
                GuiScreen gui = (GuiScreen)guiObject;
                ItemCardSettingsReader wrapper = new ItemCardSettingsReader(card, this.panel, this, 0);
                ((ICardGui)gui).setCardSettingsHelper(wrapper);
                this.field_146297_k.func_147108_a(gui);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.textboxTitle != null && this.textboxTitle.func_146206_l()) {
            if (keyCode == 1) {
                this.field_146297_k.field_71439_g.func_71053_j();
            } else if (typedChar == '\r') {
                this.updateTitle();
            } else {
                this.modified = true;
                this.textboxTitle.func_146201_a(typedChar, keyCode);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }
}

