/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod.opencomputers;

import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.ItemUpgrade;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.tileentities.TileEntityAdvancedInfoPanel;
import java.util.List;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverAdvancedInfoPanel
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return TileEntityAdvancedInfoPanel.class;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        return new Environment((TileEntityAdvancedInfoPanel)world.func_175625_s(pos));
    }

    public static final class Environment
    extends ManagedTileEntityEnvironment<TileEntityAdvancedInfoPanel>
    implements NamedBlock {
        public Environment(TileEntityAdvancedInfoPanel tileentity) {
            super((Object)tileentity, "info_panel_advanced");
        }

        public String preferredName() {
            return "info_panel_advanced";
        }

        public int priority() {
            return 0;
        }

        @Callback(doc="function():boolean -- Check if panel is active.")
        public Object[] isActive(Context context, Arguments args) {
            return new Object[]{((TileEntityAdvancedInfoPanel)this.tileEntity).powered};
        }

        @Callback(doc="function():number -- Get panel range.")
        public Object[] getRange(Context context, Arguments args) {
            ItemStack itemStack = ((TileEntityAdvancedInfoPanel)this.tileEntity).func_70301_a(((TileEntityAdvancedInfoPanel)this.tileEntity).getSlotUpgradeRange());
            int upgradeCountRange = 0;
            if (itemStack != ItemStack.field_190927_a && itemStack.func_77973_b() instanceof ItemUpgrade && itemStack.func_77952_i() == 0) {
                upgradeCountRange = itemStack.func_190916_E();
            }
            return new Object[]{8 * (int)Math.pow(2.0, Math.min(upgradeCountRange, 7))};
        }

        @Callback(doc="function():list<string> -- Get card data.")
        public Object[] getCardData(Context context, Arguments args) {
            List<PanelString> joinedData = ((TileEntityAdvancedInfoPanel)this.tileEntity).getPanelStringList(false);
            NonNullList list = NonNullList.func_191196_a();
            if (joinedData == null || joinedData.size() == 0) {
                return new Object[]{list};
            }
            for (PanelString panelString : joinedData) {
                if (panelString.textLeft != null) {
                    list.add(panelString.textLeft);
                }
                if (panelString.textCenter != null) {
                    list.add(panelString.textCenter);
                }
                if (panelString.textRight == null) continue;
                list.add(panelString.textRight);
            }
            return new Object[]{list};
        }

        @Callback(doc="function():number -- Get background color.")
        public Object[] getColorBack(Context context, Arguments args) {
            return new Object[]{((TileEntityAdvancedInfoPanel)this.tileEntity).getColorBackground()};
        }

        @Callback(doc="function():number -- Get font color.")
        public Object[] getColorText(Context context, Arguments args) {
            return new Object[]{((TileEntityAdvancedInfoPanel)this.tileEntity).getColorText()};
        }

        @Callback(doc="function(number) -- Set background color.")
        public Object[] setColorBack(Context context, Arguments args) {
            int newColor = args.checkInteger(0);
            if (newColor >= 0 && newColor < 16) {
                ((TileEntityAdvancedInfoPanel)this.tileEntity).setColorBackground(newColor);
            }
            return null;
        }

        @Callback(doc="function(number) -- Set font color.")
        public Object[] setColorText(Context context, Arguments args) {
            int value = args.checkInteger(0);
            if (value >= 0 && value < 16) {
                ((TileEntityAdvancedInfoPanel)this.tileEntity).setColorText(value);
            }
            return null;
        }

        @Callback(doc="function(number):string -- Get card title.")
        public Object[] getCardTitle(Context context, Arguments args) {
            int value = args.checkInteger(0);
            if (value < 0 || value > 2) {
                return new Object[]{""};
            }
            ItemStack stack = ((TileEntityAdvancedInfoPanel)this.tileEntity).func_70301_a(value);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCardMain)) {
                return new Object[]{""};
            }
            return new Object[]{new ItemCardReader(stack).getTitle()};
        }

        @Callback(doc="function(number,string) -- Set card title.")
        public Object[] setCardTitle(Context context, Arguments args) {
            int value = args.checkInteger(0);
            String title = args.checkString(1);
            if (value < 0 || value > 2) {
                return null;
            }
            ItemStack stack = ((TileEntityAdvancedInfoPanel)this.tileEntity).func_70301_a(value);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCardMain) {
                new ItemCardReader(stack).setTitle(title);
            }
            return null;
        }

        @Callback(doc="function():number -- Get panel thickness.")
        public Object[] getThickness(Context context, Arguments args) {
            return new Object[]{(int)((TileEntityAdvancedInfoPanel)this.tileEntity).thickness};
        }

        @Callback(doc="function(number) -- Set panel thickness.")
        public Object[] setThickness(Context context, Arguments args) {
            int value = args.checkInteger(0);
            if (value > 0 && value <= 16) {
                ((TileEntityAdvancedInfoPanel)this.tileEntity).thickness = (byte)value;
                ((TileEntityAdvancedInfoPanel)this.tileEntity).notifyBlockUpdate();
            }
            return null;
        }

        @Callback(doc="function():number -- Get panel horizonal rotation.")
        public Object[] getRotHor(Context context, Arguments args) {
            return new Object[]{((TileEntityAdvancedInfoPanel)this.tileEntity).rotateHor / 7};
        }

        @Callback(doc="function(number) -- Set panel horizonal rotation.")
        public Object[] setRotHor(Context context, Arguments args) {
            int value = args.checkInteger(0);
            if (value > -9 && value < 9) {
                ((TileEntityAdvancedInfoPanel)this.tileEntity).rotateHor = (byte)(value * 7);
                ((TileEntityAdvancedInfoPanel)this.tileEntity).notifyBlockUpdate();
            }
            return null;
        }

        @Callback(doc="function():number -- Get panel vertical rotation.")
        public Object[] getRotVert(Context context, Arguments args) {
            return new Object[]{((TileEntityAdvancedInfoPanel)this.tileEntity).rotateVert / 7};
        }

        @Callback(doc="function(number) -- Set panel vertical rotation.")
        public Object[] setRotVert(Context context, Arguments args) {
            int value = args.checkInteger(0);
            if (value > -9 && value < 9) {
                ((TileEntityAdvancedInfoPanel)this.tileEntity).rotateVert = (byte)(value * 7);
                ((TileEntityAdvancedInfoPanel)this.tileEntity).notifyBlockUpdate();
            }
            return null;
        }
    }
}

