/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod.ic2;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.ic2.CrossIC2;
import com.zuxelus.energycontrol.items.ItemAFB;
import com.zuxelus.energycontrol.items.ItemHelper;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.utils.ReactorHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.ICustomDamageItem;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.TileEntityBarrel;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityHeatSourceInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.comp.Fluids;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.generator.tileentity.TileEntityConversionGenerator;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.generator.tileentity.TileEntityKineticGenerator;
import ic2.core.block.generator.tileentity.TileEntityRTGenerator;
import ic2.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2.core.block.generator.tileentity.TileEntityStirlingGenerator;
import ic2.core.block.generator.tileentity.TileEntityWaterGenerator;
import ic2.core.block.heatgenerator.tileentity.TileEntityElectricHeatGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityElectricKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityManualKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntitySteamKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityStirlingKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityWaterKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityWindKineticGenerator;
import ic2.core.block.machine.tileentity.TileEntityLiquidHeatExchanger;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorAccessHatch;
import ic2.core.block.reactor.tileentity.TileEntityReactorChamberElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorFluidPort;
import ic2.core.block.reactor.tileentity.TileEntityReactorRedstonePort;
import ic2.core.item.reactor.ItemReactorLithiumCell;
import ic2.core.item.reactor.ItemReactorMOX;
import ic2.core.item.reactor.ItemReactorUranium;
import ic2.core.item.tool.ItemToolWrench;
import ic2.core.profile.ProfileManager;
import ic2.core.profile.Version;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class IC2Exp
extends CrossIC2 {
    @Override
    public int getNuclearCellTimeLeft(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemReactorUranium || item instanceof ItemReactorLithiumCell || item instanceof ItemReactorMOX) {
            return ((ICustomDamageItem)item).getMaxCustomDamage(stack) - ((ICustomDamageItem)item).getCustomDamage(stack);
        }
        if (item.getClass().getName() == "com.sm.FirstMod.items.ItemCoaxiumRod" || item.getClass().getName() == "com.sm.FirstMod.items.ItemCesiumRod") {
            return stack.func_77958_k() - this.getCoaxiumDamage(stack);
        }
        return 0;
    }

    public int getCoaxiumDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("fuelRodDamage");
    }

    @Override
    public CrossIC2.IC2Type getType() {
        return CrossIC2.IC2Type.EXP;
    }

    @Override
    public int getProfile() {
        return ProfileManager.selected.style == Version.OLD ? 1 : 0;
    }

    @Override
    public ItemStack getItemStack(String name) {
        switch (name) {
            case "transformer": {
                return IC2Items.getItem("upgrade", "transformer");
            }
            case "energy_storage": {
                return IC2Items.getItem("upgrade", "energy_storage");
            }
            case "machine": {
                return IC2Items.getItem("resource", "machine");
            }
            case "mfsu": {
                return IC2Items.getItem("te", "mfsu");
            }
            case "circuit": {
                return IC2Items.getItem("crafting", "circuit");
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public Item getItem(String name) {
        switch (name) {
            case "afb": {
                return new ItemAFB();
            }
        }
        return null;
    }

    @Override
    public ItemStack getChargedStack(ItemStack stack) {
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        return stack;
    }

    @Override
    public boolean isWrench(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemToolWrench;
    }

    @Override
    public boolean isSteamReactor(TileEntity par1) {
        return false;
    }

    @Override
    public ItemStack getEnergyCard(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEnergyStorage) {
            ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 0);
            ItemStackHelper.setCoordinates(sensorLocationCard, pos);
            return sensorLocationCard;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof IEnergyStorage) {
            NBTTagCompound tag = new NBTTagCompound();
            IEnergyStorage storage = (IEnergyStorage)te;
            tag.func_74768_a("type", 1);
            tag.func_74780_a("storage", (double)storage.getStored());
            tag.func_74780_a("maxStorage", (double)storage.getCapacity());
            return tag;
        }
        return null;
    }

    @Override
    public ItemStack getGeneratorCard(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof BlockTileEntity)) {
            return ItemStack.field_190927_a;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBaseGenerator || te instanceof TileEntityConversionGenerator) {
            ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 4);
            ItemStackHelper.setCoordinates(sensorLocationCard, pos);
            return sensorLocationCard;
        }
        if (te instanceof TileEntityElectricKineticGenerator || te instanceof TileEntityManualKineticGenerator || te instanceof TileEntitySteamKineticGenerator || te instanceof TileEntityStirlingKineticGenerator || te instanceof TileEntityWaterKineticGenerator || te instanceof TileEntityWindKineticGenerator) {
            ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 5);
            ItemStackHelper.setCoordinates(sensorLocationCard, pos);
            return sensorLocationCard;
        }
        if (te instanceof TileEntityHeatSourceInventory) {
            ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 6);
            ItemStackHelper.setCoordinates(sensorLocationCard, pos);
            return sensorLocationCard;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getGeneratorData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            Boolean active = this.isActive(te);
            tag.func_74757_a("active", active.booleanValue());
            tag.func_74778_a("euType", "EU");
            if (te instanceof TileEntityBaseGenerator) {
                tag.func_74768_a("type", 1);
                Energy energy = (Energy)((TileEntityBaseGenerator)te).getComponent(Energy.class);
                tag.func_74780_a("storage", energy.getEnergy());
                tag.func_74780_a("maxStorage", energy.getCapacity());
                if (te instanceof TileEntitySolarGenerator) {
                    float light = ((TileEntitySolarGenerator)te).skyLight;
                    active = light > 0.0f && energy.getEnergy() < energy.getCapacity();
                    tag.func_74757_a("active", active.booleanValue());
                    if (active.booleanValue()) {
                        tag.func_74780_a("production", (double)light);
                    } else {
                        tag.func_74780_a("production", 0.0);
                    }
                    return tag;
                }
                if (te instanceof TileEntityRTGenerator) {
                    tag.func_74768_a("type", 4);
                    int counter = 0;
                    for (int i = 0; i < ((TileEntityRTGenerator)te).fuelSlot.size(); ++i) {
                        if (((TileEntityRTGenerator)te).fuelSlot.isEmpty(i)) continue;
                        ++counter;
                    }
                    tag.func_74768_a("items", counter);
                    if (counter == 0 || energy.getEnergy() >= energy.getCapacity()) {
                        tag.func_74757_a("active", false);
                        tag.func_74780_a("production", 0.0);
                        return tag;
                    }
                    tag.func_74757_a("active", true);
                    Field field = TileEntityRTGenerator.class.getDeclaredField("efficiency");
                    field.setAccessible(true);
                    tag.func_74780_a("multiplier", (double)((Float)field.get(te)).floatValue());
                    tag.func_74780_a("production", Math.pow(2.0, counter - 1) * (double)((Float)field.get(te)).floatValue());
                    return tag;
                }
                if (te instanceof TileEntityWaterGenerator) {
                    active = ((TileEntityWaterGenerator)te).water > 0 || ((TileEntityWaterGenerator)te).fuel > 0;
                    tag.func_74757_a("active", active.booleanValue());
                    if (((TileEntityWaterGenerator)te).fuel <= 0) {
                        Field field = TileEntityWaterGenerator.class.getDeclaredField("energyMultiplier");
                        field.setAccessible(true);
                        tag.func_74780_a("production", (Double)field.get(te) * (double)((TileEntityWaterGenerator)te).water / 100.0);
                        return tag;
                    }
                }
                if (active.booleanValue()) {
                    Field field = TileEntityBaseGenerator.class.getDeclaredField("production");
                    field.setAccessible(true);
                    tag.func_74780_a("production", ((Double)field.get(te)).doubleValue());
                } else {
                    tag.func_74780_a("production", 0.0);
                }
                return tag;
            }
            if (te instanceof TileEntityConversionGenerator) {
                Field field;
                if (active.booleanValue()) {
                    field = TileEntityConversionGenerator.class.getDeclaredField("lastProduction");
                    field.setAccessible(true);
                    tag.func_74780_a("production", ((Double)field.get(te)).doubleValue());
                } else {
                    tag.func_74780_a("production", 0.0);
                }
                if (te instanceof TileEntityStirlingGenerator) {
                    tag.func_74768_a("type", 2);
                    field = TileEntityStirlingGenerator.class.getDeclaredField("productionpeerheat");
                    field.setAccessible(true);
                    tag.func_74780_a("multiplier", ((Double)field.get(te)).doubleValue());
                }
                if (te instanceof TileEntityKineticGenerator) {
                    tag.func_74768_a("type", 3);
                    Energy energy = (Energy)((TileEntityKineticGenerator)te).getComponent(Energy.class);
                    tag.func_74780_a("storage", energy.getEnergy());
                    tag.func_74780_a("maxStorage", energy.getCapacity());
                    Field field2 = TileEntityKineticGenerator.class.getDeclaredField("euPerKu");
                    field2.setAccessible(true);
                    tag.func_74780_a("multiplier", ((Double)field2.get(te)).doubleValue());
                }
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NBTTagCompound getGeneratorKineticData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            if (te instanceof TileEntityManualKineticGenerator) {
                tag.func_74768_a("type", 1);
                tag.func_74780_a("storage", (double)((TileEntityManualKineticGenerator)te).currentKU);
                ((TileEntityManualKineticGenerator)te).getClass();
                tag.func_74780_a("maxStorage", 1000.0);
                return tag;
            }
            Boolean active = ((TileEntityBlock)te).getActive();
            if (te instanceof TileEntityWindKineticGenerator) {
                TileEntityWindKineticGenerator entity = (TileEntityWindKineticGenerator)te;
                tag.func_74768_a("type", 2);
                tag.func_74780_a("output", (double)entity.getKuOutput());
                Field field = TileEntityWindKineticGenerator.class.getDeclaredField("windStrength");
                field.setAccessible(true);
                tag.func_74780_a("wind", ((Double)field.get(te)).doubleValue());
                tag.func_74780_a("multiplier", (double)(entity.getEfficiency() * TileEntityWindKineticGenerator.outputModifier));
                tag.func_74768_a("height", entity.func_174877_v().func_177956_o());
                if (entity.rotorSlot.isEmpty()) {
                    tag.func_74768_a("health", -1);
                    return tag;
                } else {
                    tag.func_74780_a("health", (double)(100.0f - (float)entity.rotorSlot.get().func_77952_i() * 100.0f / (float)entity.rotorSlot.get().func_77958_k()));
                }
                return tag;
            }
            if (te instanceof TileEntityWaterKineticGenerator) {
                TileEntityWaterKineticGenerator entity = (TileEntityWaterKineticGenerator)te;
                tag.func_74768_a("type", 2);
                tag.func_74780_a("output", (double)entity.getKuOutput());
                Field field = TileEntityWaterKineticGenerator.class.getDeclaredField("waterFlow");
                field.setAccessible(true);
                tag.func_74780_a("wind", (double)((Integer)field.get(te)).intValue());
                field = TileEntityWaterKineticGenerator.class.getDeclaredField("outputModifier");
                field.setAccessible(true);
                tag.func_74780_a("multiplier", (double)((Float)field.get(te)).floatValue());
                tag.func_74768_a("height", entity.func_174877_v().func_177956_o());
                if (entity.rotorSlot.isEmpty()) {
                    tag.func_74768_a("health", -1);
                    return tag;
                } else {
                    tag.func_74780_a("health", (double)(100.0f - (float)entity.rotorSlot.get().func_77952_i() * 100.0f / (float)entity.rotorSlot.get().func_77958_k()));
                }
                return tag;
            }
            if (!(te instanceof TileEntityStirlingKineticGenerator)) return null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public NBTTagCompound getGeneratorHeatData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            Boolean active = ((TileEntityBlock)te).getActive();
            tag.func_74757_a("active", active.booleanValue());
            if (te instanceof TileEntityHeatSourceInventory) {
                tag.func_74768_a("type", 1);
                if (active.booleanValue()) {
                    tag.func_74768_a("output", ((TileEntityHeatSourceInventory)te).gettransmitHeat());
                } else {
                    tag.func_74768_a("output", 0);
                }
                if (te instanceof TileEntityElectricHeatGenerator) {
                    Energy energy = (Energy)((TileEntityHeatSourceInventory)te).getComponent(Energy.class);
                    tag.func_74780_a("storage", energy.getEnergy());
                    tag.func_74780_a("maxStorage", energy.getCapacity());
                    int count = 0;
                    for (ItemStack stack : ((TileEntityElectricHeatGenerator)te).coilSlot) {
                        if (stack.func_190926_b()) continue;
                        ++count;
                    }
                    tag.func_74768_a("coils", count);
                }
                if (te instanceof TileEntityLiquidHeatExchanger) {
                    Fluids fluid = (Fluids)((TileEntityLiquidHeatExchanger)te).getComponent(Fluids.class);
                    Iterable tanks = fluid.getAllTanks();
                    Fluids.InternalFluidTank tank = (Fluids.InternalFluidTank)tanks.iterator().next();
                    tag.func_74780_a("storage", (double)tank.getFluidAmount());
                    tag.func_74780_a("maxStorage", (double)tank.getCapacity());
                    int count = 0;
                    for (ItemStack stack : ((TileEntityLiquidHeatExchanger)te).heatexchangerslots) {
                        if (stack.func_190926_b()) continue;
                        ++count;
                    }
                    tag.func_74768_a("coils", count);
                }
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private boolean isActive(TileEntity te) {
        if (te instanceof TileEntityGeoGenerator || te instanceof TileEntityConversionGenerator || te instanceof TileEntitySolarGenerator) {
            return ((TileEntityBlock)te).getActive();
        }
        if (te instanceof TileEntityBaseGenerator) {
            return ((TileEntityBaseGenerator)te).isConverting();
        }
        return false;
    }

    @Override
    public List<IFluidTank> getAllTanks(TileEntity te) {
        if (!(te instanceof TileEntityBlock)) {
            return null;
        }
        if (!((TileEntityBlock)te).hasComponent(Fluids.class)) {
            return null;
        }
        Fluids fluid = (Fluids)((TileEntityBlock)te).getComponent(Fluids.class);
        ArrayList<IFluidTank> result = new ArrayList<IFluidTank>();
        for (FluidTank tank : fluid.getAllTanks()) {
            result.add((IFluidTank)tank);
        }
        return result;
    }

    @Override
    public ItemStack getReactorCard(World world, BlockPos pos) {
        BlockPos position;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof BlockTileEntity)) {
            return ItemStack.field_190927_a;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityNuclearReactorElectric || te instanceof TileEntityReactorChamberElectric) {
            BlockPos position2 = ReactorHelper.getTargetCoordinates(world, pos);
            if (position2 != null) {
                ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 7);
                ItemStackHelper.setCoordinates(sensorLocationCard, position2);
                return sensorLocationCard;
            }
        } else if ((te instanceof TileEntityReactorFluidPort || te instanceof TileEntityReactorRedstonePort || te instanceof TileEntityReactorAccessHatch) && (position = ReactorHelper.get5x5TargetCoordinates(world, pos)) != null) {
            ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 8);
            ItemStackHelper.setCoordinates(sensorLocationCard, position);
            return sensorLocationCard;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getLiquidAdvancedCard(World world, BlockPos pos) {
        BlockPos position;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof BlockTileEntity)) {
            return ItemStack.field_190927_a;
        }
        TileEntity te = world.func_175625_s(pos);
        if ((te instanceof TileEntityReactorFluidPort || te instanceof TileEntityReactorRedstonePort || te instanceof TileEntityReactorAccessHatch) && (position = ReactorHelper.get5x5TargetCoordinates(world, pos)) != null) {
            ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 3);
            ItemStackHelper.setCoordinates(sensorLocationCard, position);
            return sensorLocationCard;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public CardState updateCardReactor(World world, ICardReader reader, IReactor reactor) {
        reader.setInt("heat", reactor.getHeat());
        reader.setInt("maxHeat", reactor.getMaxHeat());
        reader.setBoolean("reactorPoweredB", reactor.produceEnergy());
        reader.setInt("output", (int)Math.round(reactor.getReactorEUEnergyOutput()));
        boolean isSteam = ReactorHelper.isSteam(reactor);
        reader.setBoolean("isSteam", isSteam);
        IInventory inventory = (IInventory)reactor;
        int slotCount = inventory.func_70302_i_();
        int dmgLeft = 0;
        for (int i = 0; i < slotCount; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            dmgLeft = Math.max(dmgLeft, ReactorHelper.getNuclearCellTimeLeft(stack));
        }
        int timeLeft = 0;
        timeLeft = isSteam ? dmgLeft : dmgLeft * reactor.getTickRate() / 20;
        reader.setInt("timeLeft", timeLeft);
        return CardState.OK;
    }

    @Override
    public CardState updateCardReactor5x5(World world, ICardReader reader, BlockPos target) {
        IReactor reactor = ReactorHelper.getReactorAt(world, target);
        if (reactor == null || !(reactor instanceof TileEntityNuclearReactorElectric)) {
            return CardState.NO_TARGET;
        }
        reader.setInt("heat", reactor.getHeat());
        reader.setInt("maxHeat", reactor.getMaxHeat());
        reader.setBoolean("reactorPowered", reactor.produceEnergy());
        reader.setInt("output", ((TileEntityNuclearReactorElectric)reactor).EmitHeat);
        IInventory inventory = (IInventory)reactor;
        int slotCount = inventory.func_70302_i_();
        int dmgLeft = 0;
        for (int i = 0; i < slotCount; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            dmgLeft = Math.max(dmgLeft, ReactorHelper.getNuclearCellTimeLeft(stack));
        }
        int timeLeft = dmgLeft * reactor.getTickRate() / 20;
        reader.setInt("timeLeft", timeLeft);
        return CardState.OK;
    }

    @Override
    public void showBarrelInfo(EntityPlayer player, TileEntity te) {
        if (te instanceof TileEntityBarrel) {
            int age = -1;
            int boozeAmount = 0;
            try {
                Field field = TileEntityBarrel.class.getDeclaredField("age");
                field.setAccessible(true);
                age = (Integer)field.get(te);
                field = TileEntityBarrel.class.getDeclaredField("boozeAmount");
                field.setAccessible(true);
                boozeAmount = (Integer)field.get(te);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (age >= 0) {
                NetworkHelper.chatMessage(player, age + " / " + ((TileEntityBarrel)te).timeNedForRum(boozeAmount));
            }
        }
    }
}

