/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod.ic2;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.ic2.CrossIC2;
import com.zuxelus.energycontrol.items.ItemHelper;
import com.zuxelus.energycontrol.utils.ReactorHelper;
import ic2.api.classic.reactor.IChamberReactor;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.ICustomDamageItem;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.block.generator.tile.TileEntityLiquidFuelGenerator;
import ic2.core.block.generator.tile.TileEntityNuclearReactorElectric;
import ic2.core.block.generator.tile.TileEntityNuclearSteamReactor;
import ic2.core.block.generator.tile.TileEntityReactorChamberElectric;
import ic2.core.block.generator.tile.TileEntitySolarPanel;
import ic2.core.block.machine.low.TileEntityMachineTank;
import ic2.core.block.personal.tile.TileEntityPersonalTank;
import ic2.core.item.reactor.ItemReactorUraniumRod;
import ic2.core.item.tool.ItemToolWrench;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;

public class IC2Classic
extends CrossIC2 {
    @Override
    public int getNuclearCellTimeLeft(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemReactorUraniumRod) {
            return ((ICustomDamageItem)item).getMaxCustomDamage(stack) - ((ICustomDamageItem)item).getCustomDamage(stack);
        }
        return 0;
    }

    @Override
    public boolean isSteamReactor(TileEntity par1) {
        return par1 != null && par1 instanceof IReactor;
    }

    @Override
    public CrossIC2.IC2Type getType() {
        return CrossIC2.IC2Type.SPEIGER;
    }

    @Override
    public int getProfile() {
        return -1;
    }

    @Override
    public ItemStack getItemStack(String name) {
        switch (name) {
            case "transformer": {
                return IC2Items.getItem("upgrade", "transformer");
            }
            case "energy_storage": {
                return IC2Items.getItem("upgrade", "energy_storage");
            }
            case "machine": {
                return IC2Items.getItem("resource", "machine");
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public Item getItem(String name) {
        return null;
    }

    @Override
    public ItemStack getChargedStack(ItemStack stack) {
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        return stack;
    }

    @Override
    public boolean isWrench(ItemStack par1) {
        return par1 != null && par1.func_77973_b() instanceof ItemToolWrench;
    }

    @Override
    public ItemStack getEnergyCard(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEnergyStorage) {
            ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 0);
            ItemStackHelper.setCoordinates(sensorLocationCard, pos);
            return sensorLocationCard;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof IEnergyStorage) {
            NBTTagCompound tag = new NBTTagCompound();
            IEnergyStorage storage = (IEnergyStorage)te;
            tag.func_74768_a("type", 1);
            tag.func_74780_a("storage", (double)storage.getStored());
            tag.func_74780_a("maxStorage", (double)storage.getCapacity());
            return tag;
        }
        return null;
    }

    @Override
    public ItemStack getGeneratorCard(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntitySolarPanel || te instanceof TileEntityGeneratorBase) {
            ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 4);
            ItemStackHelper.setCoordinates(sensorLocationCard, pos);
            return sensorLocationCard;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getGeneratorData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            Boolean active = false;
            tag.func_74778_a("euType", "EU");
            if (te instanceof TileEntitySolarPanel) {
                tag.func_74768_a("type", 1);
                tag.func_74780_a("storage", ((TileEntitySolarPanel)te).getOfferedEnergy());
                tag.func_74780_a("maxStorage", (double)((TileEntitySolarPanel)te).getOutput());
                active = ((TileEntitySolarPanel)te).getActive();
                tag.func_74757_a("active", active.booleanValue());
                if (active.booleanValue()) {
                    tag.func_74780_a("production", (double)((TileEntitySolarPanel)te).getOutput());
                } else {
                    tag.func_74780_a("production", 0.0);
                }
                return tag;
            }
            if (te instanceof TileEntityGeneratorBase) {
                tag.func_74768_a("type", 1);
                tag.func_74780_a("storage", (double)((TileEntityGeneratorBase)te).getStoredEU());
                tag.func_74780_a("maxStorage", (double)((TileEntityGeneratorBase)te).getMaxEU());
                active = ((TileEntityGeneratorBase)te).getActive();
                tag.func_74757_a("active", active.booleanValue());
                if (active.booleanValue()) {
                    tag.func_74780_a("production", (double)((TileEntityGeneratorBase)te).getOutput());
                } else {
                    tag.func_74780_a("production", 0.0);
                }
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public NBTTagCompound getGeneratorKineticData(TileEntity entity) {
        return null;
    }

    @Override
    public NBTTagCompound getGeneratorHeatData(TileEntity entity) {
        return null;
    }

    @Override
    public List<IFluidTank> getAllTanks(TileEntity te) {
        ArrayList<IFluidTank> result = new ArrayList<IFluidTank>();
        if (te instanceof TileEntityNuclearSteamReactor) {
            result.add((IFluidTank)((TileEntityNuclearSteamReactor)te).getWaterTank());
            result.add((IFluidTank)((TileEntityNuclearSteamReactor)te).getSteamTank());
        }
        if (te instanceof TileEntityMachineTank) {
            result.add((IFluidTank)((TileEntityMachineTank)te).tank);
        }
        if (te instanceof TileEntityPersonalTank) {
            result.add((IFluidTank)((TileEntityPersonalTank)te).tank);
        }
        if (te instanceof TileEntityLiquidFuelGenerator) {
            result.add((IFluidTank)((TileEntityLiquidFuelGenerator)te).tank);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @Override
    public ItemStack getReactorCard(World world, BlockPos pos) {
        BlockPos position;
        TileEntity te = world.func_175625_s(pos);
        if ((te instanceof TileEntityNuclearReactorElectric || te instanceof TileEntityReactorChamberElectric || te instanceof TileEntityNuclearSteamReactor) && (position = ReactorHelper.getTargetCoordinates(world, pos)) != null) {
            ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 7);
            ItemStackHelper.setCoordinates(sensorLocationCard, position);
            return sensorLocationCard;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getLiquidAdvancedCard(World world, BlockPos pos) {
        return null;
    }

    @Override
    public CardState updateCardReactor(World world, ICardReader reader, IReactor reactor) {
        if (!(reactor instanceof IChamberReactor)) {
            return CardState.NO_TARGET;
        }
        reader.setInt("heat", reactor.getHeat());
        reader.setInt("maxHeat", reactor.getMaxHeat());
        reader.setBoolean("reactorPoweredB", reactor.produceEnergy());
        reader.setInt("output", (int)Math.round(reactor.getReactorEUEnergyOutput()));
        boolean isSteam = ReactorHelper.isSteam(reactor);
        reader.setBoolean("isSteam", isSteam);
        IChamberReactor chamber = (IChamberReactor)reactor;
        int size = chamber.getReactorSize();
        int dmgLeft = 0;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < size; ++x) {
                ItemStack stack = chamber.getItemAt(x, y);
                if (stack.func_190926_b()) continue;
                dmgLeft = Math.max(dmgLeft, ReactorHelper.getNuclearCellTimeLeft(stack));
            }
        }
        int timeLeft = 0;
        timeLeft = isSteam ? dmgLeft : dmgLeft * reactor.getTickRate() / 20;
        reader.setInt("timeLeft", timeLeft);
        return CardState.OK;
    }

    @Override
    public CardState updateCardReactor5x5(World world, ICardReader reader, BlockPos target) {
        return CardState.NO_TARGET;
    }

    @Override
    public void showBarrelInfo(EntityPlayer player, TileEntity te) {
    }
}

