/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.ServerTickHandler;
import com.zuxelus.energycontrol.config.ConfigHandler;
import com.zuxelus.energycontrol.containers.ContainerAFSU;
import com.zuxelus.energycontrol.containers.ContainerAdvancedInfoPanel;
import com.zuxelus.energycontrol.containers.ContainerAverageCounter;
import com.zuxelus.energycontrol.containers.ContainerCardHolder;
import com.zuxelus.energycontrol.containers.ContainerEnergyCounter;
import com.zuxelus.energycontrol.containers.ContainerInfoPanel;
import com.zuxelus.energycontrol.containers.ContainerKitAssembler;
import com.zuxelus.energycontrol.containers.ContainerPortablePanel;
import com.zuxelus.energycontrol.containers.ContainerRangeTrigger;
import com.zuxelus.energycontrol.containers.ContainerRemoteThermo;
import com.zuxelus.energycontrol.items.cards.ItemCardHolder;
import com.zuxelus.energycontrol.tileentities.TileEntityAFSU;
import com.zuxelus.energycontrol.tileentities.TileEntityAdvancedInfoPanel;
import com.zuxelus.energycontrol.tileentities.TileEntityAverageCounter;
import com.zuxelus.energycontrol.tileentities.TileEntityEnergyCounter;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import com.zuxelus.energycontrol.tileentities.TileEntityKitAssembler;
import com.zuxelus.energycontrol.tileentities.TileEntityRangeTrigger;
import com.zuxelus.energycontrol.tileentities.TileEntityRemoteThermo;
import java.io.File;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class ServerProxy
implements IGuiHandler {
    public void loadConfig(FMLPreInitializationEvent event) {
        EnergyControl.config = new ConfigHandler();
        EnergyControl.config.init(event.getSuggestedConfigurationFile());
    }

    public void registerSpecialRenderers() {
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 11: {
                return new ContainerPortablePanel(player);
            }
            case 12: {
                if (!(player.func_184614_ca().func_77973_b() instanceof ItemCardHolder)) break;
                return new ContainerCardHolder(player);
            }
        }
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        switch (ID) {
            case 4: {
                return new ContainerInfoPanel(player, (TileEntityInfoPanel)te);
            }
            case 9: {
                return new ContainerAdvancedInfoPanel(player, (TileEntityAdvancedInfoPanel)te);
            }
            case 8: {
                return new ContainerRangeTrigger(player, (TileEntityRangeTrigger)te);
            }
            case 3: {
                return new ContainerRemoteThermo(player, (TileEntityRemoteThermo)te);
            }
            case 7: {
                return new ContainerAverageCounter(player, (TileEntityAverageCounter)te);
            }
            case 6: {
                return new ContainerEnergyCounter(player, (TileEntityEnergyCounter)te);
            }
            case 13: {
                return new ContainerKitAssembler(player, (TileEntityKitAssembler)te);
            }
            case 14: {
                return new ContainerAFSU(player, (TileEntityAFSU)te);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)ServerTickHandler.instance);
    }

    public void importSound(File configFolder) {
    }
}

