/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.monitor;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.task.ContinuousTask;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.render.util.DynaTextureProvider;
import crazypants.enderio.conduits.autosave.HandleStatCollector;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.conduits.conduit.power.NetworkPowerManager;
import crazypants.enderio.conduits.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduits.conduit.power.PowerTracker;
import crazypants.enderio.powertools.capacitor.CapacitorKey;
import crazypants.enderio.powertools.init.PowerToolObject;
import crazypants.enderio.powertools.machine.monitor.DynaTextureProviderPMon;
import crazypants.enderio.powertools.machine.monitor.PacketPowerMonitorGraph;
import crazypants.enderio.powertools.machine.monitor.PacketPowerMonitorStatData;
import crazypants.enderio.powertools.machine.monitor.StatCollector;
import crazypants.enderio.powertools.network.PacketHandler;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TilePowerMonitor
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity,
DynaTextureProviderPMon.IDataProvider {
    private static final int iconUpdateRate = 1500;
    @Store(value={NBTAction.SAVE, NBTAction.ITEM}, handler=HandleStatCollector.class)
    protected StatCollector stats10s = new StatCollector(2);
    @Store(value={NBTAction.SAVE, NBTAction.ITEM}, handler=HandleStatCollector.class)
    protected StatCollector stats01m = new StatCollector(12);
    @Store(value={NBTAction.SAVE, NBTAction.ITEM}, handler=HandleStatCollector.class)
    protected StatCollector stats10m = new StatCollector(120);
    @Store(value={NBTAction.SAVE, NBTAction.ITEM}, handler=HandleStatCollector.class)
    protected StatCollector stats01h = new StatCollector(720);
    @Store(value={NBTAction.SAVE, NBTAction.ITEM}, handler=HandleStatCollector.class)
    protected StatCollector stats06h = new StatCollector(7200);
    @Store(value={NBTAction.SAVE, NBTAction.ITEM}, handler=HandleStatCollector.class)
    protected StatCollector stats24h = new StatCollector(17280);
    @Store(value={NBTAction.SAVE, NBTAction.ITEM}, handler=HandleStatCollector.class)
    protected StatCollector stats07d = new StatCollector(120960);
    @Store(value={NBTAction.SAVE, NBTAction.ITEM}, handler=HandleStatCollector.class)
    protected StatCollector statsIcn = new StatCollector(1500, 28);
    protected StatCollector[] stats = new StatCollector[]{this.stats10s, this.stats01m, this.stats10m, this.stats01h, this.stats06h, this.stats24h, this.stats07d, this.statsIcn};
    @Store(value={NBTAction.SAVE, NBTAction.CLIENT})
    private boolean advanced;
    @Store
    private boolean engineControlEnabled = false;
    @Store
    private float startLevel = 0.75f;
    @Store
    private float stopLevel = 0.99f;
    @Store(value={NBTAction.CLIENT})
    private boolean redStoneOn;
    private boolean initialized = false;
    private int slowstart = 100;
    private static final long bit62 = Integer.MAX_VALUE;
    private static final long bit63 = 0xFFFFFFFEL;
    @Store(value={NBTAction.SAVE})
    private EnumFacing lastConduitConnection = null;
    private boolean lastConduitConnectionDirty = true;
    private long[] nextUpdateRequest = new long[this.stats.length];
    protected Object dynaTextureProvider = null;
    protected int[] iconMins = new int[32];
    protected int[] iconMaxs = new int[32];
    protected StatData statData = null;
    private long nextUpdateRequestStatData = -1L;

    public TilePowerMonitor() {
        super(new SlotDefinition(0, 0, 0), CapacitorKey.POWER_MONITOR_POWER_INTAKE, CapacitorKey.POWER_MONITOR_POWER_BUFFER, CapacitorKey.POWER_MONITOR_POWER_USE);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return PowerToolObject.block_power_monitor.getUnlocalisedName();
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack item) {
        return false;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode == IoMode.NONE;
    }

    @Override
    protected boolean checkProgress(boolean redstoneChecksPassed) {
        this.usePower();
        if (!this.advanced && !this.engineControlEnabled) {
            return false;
        }
        if (this.slowstart > 0) {
            --this.slowstart;
            return false;
        }
        NetworkPowerManager pm = this.getPowerManager();
        if (pm != null) {
            if (this.advanced) {
                int capPower = TilePowerMonitor.logSrqt2(pm.getPowerInCapacitorBanks());
                for (StatCollector statCollector : this.stats) {
                    statCollector.addValue(capPower);
                }
            }
            if (this.engineControlEnabled) {
                double level = this.getPercentFull(pm);
                if (level < (double)this.startLevel) {
                    if (!this.redStoneOn) {
                        this.redStoneOn = true;
                        this.broadcastSignal();
                    }
                } else if (level >= (double)this.stopLevel && this.redStoneOn) {
                    this.redStoneOn = false;
                    this.broadcastSignal();
                }
                if (!this.initialized) {
                    this.broadcastSignal();
                }
            }
        }
        if (this.advanced && this.shouldDoWorkThisTick(150)) {
            PacketHandler.sendToAllAround(PacketPowerMonitorGraph.sendUpdate(this, this.stats.length - 1), (TileEntity)this);
        }
        return false;
    }

    private double getPercentFull(NetworkPowerManager pm) {
        return ((double)pm.getPowerInConduits() + (double)pm.getPowerInCapacitorBanks()) / ((double)pm.getMaxPowerInConduits() + (double)pm.getMaxPowerInCapacitorBanks());
    }

    private void broadcastSignal() {
        this.initialized = true;
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
    }

    private static int logSrqt2(long value) {
        if (value <= 0L) {
            return 0;
        }
        if (value >= 0xFFFFFFFEL) {
            return 63;
        }
        if (value >= Integer.MAX_VALUE) {
            return 62;
        }
        for (int i = 30; i >= 0; --i) {
            if ((value & (long)(1 << i)) == 0L) continue;
            if (i == 0) {
                return 1;
            }
            if ((value & (long)(1 << i - 1)) != 0L) {
                return i * 2 + 1;
            }
            return i * 2;
        }
        return 0;
    }

    protected void onNeighbor() {
        this.lastConduitConnectionDirty = true;
    }

    public NetworkPowerManager getPowerManager() {
        class Finder {
            NetworkPowerManager pmFound = null;
            EnumFacing found = null;

            Finder() {
            }

            void find(EnumFacing dir) {
                NetworkPowerManager pm;
                IConduitNetwork n;
                IPowerConduit con;
                if (dir != null && dir != this.found && (con = ConduitUtil.getConduit(TilePowerMonitor.this.field_145850_b, (TileEntity)TilePowerMonitor.this, dir, IPowerConduit.class)) != null && con.getEffectiveConnectionMode(dir.func_176734_d()).isActive() && (n = con.getNetwork()) instanceof PowerConduitNetwork && (pm = ((PowerConduitNetwork)n).getPowerManager()) != null) {
                    if (this.pmFound == null) {
                        this.pmFound = pm;
                        this.found = dir;
                    } else {
                        con.setConnectionMode(dir.func_176734_d(), ConnectionMode.DISABLED);
                    }
                }
            }
        }
        Finder f = new Finder();
        f.find(this.lastConduitConnection);
        if (!this.lastConduitConnectionDirty && f.pmFound != null) {
            return f.pmFound;
        }
        f.find(this.getFacing().func_176734_d());
        NNList.FACING.apply(f::find);
        this.lastConduitConnection = f.found;
        this.lastConduitConnectionDirty = false;
        return f.pmFound;
    }

    @Override
    protected IPoweredTask createTask(@Nullable IMachineRecipe nextRecipe, long nextSeed) {
        return new ContinuousTask(this.getPowerUsePerTick());
    }

    @Override
    public void onCapacitorDataChange() {
        this.currentTask = this.createTask(null, 0L);
        this.initialized = false;
    }

    @SideOnly(value=Side.CLIENT)
    public StatCollector getStatCollector(int id) {
        if (id < 0 || id >= this.stats.length) {
            return null;
        }
        long now = EnderIO.proxy.getTickCount();
        if (this.nextUpdateRequest[id] < now) {
            this.nextUpdateRequest[id] = now + 10L;
            PacketHandler.INSTANCE.sendToServer(PacketPowerMonitorGraph.requestUpdate(this, id));
        }
        return this.stats[id];
    }

    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
        if (this.dynaTextureProvider == null) {
            this.dynaTextureProvider = new DynaTextureProviderPMon(this);
        }
        ((DynaTextureProvider)this.dynaTextureProvider).bindTexture();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_145843_s() {
        super.func_145843_s();
        if (this.dynaTextureProvider != null) {
            ((DynaTextureProvider)this.dynaTextureProvider).free();
            this.dynaTextureProvider = null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public int[][] getIconValues() {
        return this.statsIcn.getValues();
    }

    @SideOnly(value=Side.CLIENT)
    public StatData getStatData() {
        long now = EnderIO.proxy.getTickCount();
        if (this.nextUpdateRequestStatData < now) {
            this.nextUpdateRequestStatData = now + 10L;
            PacketHandler.INSTANCE.sendToServer(PacketPowerMonitorStatData.requestUpdate(this));
        }
        return this.statData;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
        this.func_70296_d();
    }

    public boolean isEngineControlEnabled() {
        return this.engineControlEnabled;
    }

    public void setEngineControlEnabled(boolean engineControlEnabled) {
        this.engineControlEnabled = engineControlEnabled;
        if (!engineControlEnabled && this.redStoneOn) {
            this.redStoneOn = false;
            this.broadcastSignal();
        }
        this.func_70296_d();
    }

    public float getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(float startLevel) {
        this.startLevel = startLevel;
        this.func_70296_d();
    }

    public float getStopLevel() {
        return this.stopLevel;
    }

    public void setStopLevel(float stopLevel) {
        this.stopLevel = stopLevel;
        this.func_70296_d();
    }

    public int getRedstoneLevel() {
        return this.redStoneOn ? 15 : 0;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    static class StatData {
        long powerInConduits;
        long maxPowerInConduits;
        long powerInCapBanks;
        long maxPowerInCapBanks;
        long powerInMachines;
        long maxPowerInMachines;
        float aveRfSent;
        float aveRfReceived;

        StatData(NetworkPowerManager pm) {
            this.powerInConduits = pm.getPowerInConduits();
            this.maxPowerInConduits = pm.getMaxPowerInConduits();
            this.powerInCapBanks = pm.getPowerInCapacitorBanks();
            this.maxPowerInCapBanks = pm.getMaxPowerInCapacitorBanks();
            this.powerInMachines = pm.getPowerInReceptors();
            this.maxPowerInMachines = pm.getMaxPowerInReceptors();
            PowerTracker tracker = pm.getNetworkPowerTracker();
            this.aveRfSent = tracker.getAverageRfTickSent();
            this.aveRfReceived = tracker.getAverageRfTickRecieved();
        }

        StatData() {
        }
    }
}

