/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.glass;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.config.config.BlockConfig;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.material.glass.BlockFusedQuartzBase;
import crazypants.enderio.base.material.glass.FusedQuartzBlockRenderMapper;
import crazypants.enderio.base.material.glass.FusedQuartzItemRenderMapper;
import crazypants.enderio.base.material.glass.FusedQuartzType;
import crazypants.enderio.base.material.glass.IFusedBlockstate;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ITintedBlock;
import crazypants.enderio.base.render.ITintedItem;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumMergingBlockRenderMode;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.util.FacadeUtil;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFusedQuartz
extends BlockFusedQuartzBase<TileEntityEio>
implements ITintedBlock,
ICustomSubItems {
    @Nonnull
    protected static final EnumDyeColor DEFAULT_COLOR = EnumDyeColor.WHITE;
    @SideOnly(value=Side.CLIENT)
    private static FusedQuartzItemRenderMapper RENDER_MAPPER;
    @Nonnull
    private final FusedQuartzType glasstype;

    @Nonnull
    public static Function<IModObject, Block> create(@Nonnull FusedQuartzType type) {
        return modObject -> {
            BlockFusedQuartz block = new BlockFusedQuartz((IModObject)NullHelper.notnull((Object)modObject, (Object[])new Object[0]), type);
            block.init();
            return block;
        };
    }

    protected BlockFusedQuartz(@Nonnull IModObject modObject, @Nonnull FusedQuartzType glasstype) {
        super(modObject);
        this.glasstype = glasstype;
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO)).func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)DEFAULT_COLOR));
    }

    @Override
    protected void init() {
        super.init();
        this.glasstype.setBlock((Block)this);
        SmartModelAttacher.register((Block)this, EnumMergingBlockRenderMode.RENDER, EnumMergingBlockRenderMode.DEFAULTS, EnumMergingBlockRenderMode.AUTO);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumMergingBlockRenderMode.RENDER, BlockColored.field_176581_a});
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return state.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO));
    }

    @Override
    @Nonnull
    public IFusedBlockstate getFusedBlockstate(final @Nonnull IBlockState state) {
        return new IFusedBlockstate(){

            @Override
            @Nonnull
            public FusedQuartzType getType() {
                return BlockFusedQuartz.this.glasstype;
            }

            @Override
            @Nonnull
            public EnumDyeColor getColor() {
                return (EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a);
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        FusedQuartzBlockRenderMapper renderMapper = new FusedQuartzBlockRenderMapper(state, world, pos);
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, renderMapper);
        blockStateWrapper.addCacheKey(renderMapper);
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).func_176765_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs par2CreativeTabs, @Nonnull NonNullList<ItemStack> par3List) {
        for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
            par3List.add((Object)new ItemStack((Block)this, 1, enumdyecolor.func_176765_a()));
        }
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getSubItems() {
        return this.getSubItems((Block)this, 0, 15);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return FusedQuartzItemRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState blockStateIn, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        IBlockState facade;
        IBlockState otherState = world.func_180495_p(pos.func_177972_a(side)).func_185899_b(world, pos.func_177972_a(side));
        if (FacadeUtil.instance.isFacaded(otherState) && (facade = FacadeUtil.instance.getFacade(otherState, world, pos.func_177972_a(side), side)) != null) {
            otherState = facade;
        }
        if (otherState.func_177230_c() instanceof BlockFusedQuartz) {
            IFusedBlockstate ourFState = this.getFusedBlockstate(blockStateIn);
            IFusedBlockstate otherFState = IFusedBlockstate.get(otherState);
            return !ourFState.getType().connectTo(otherFState.getType()) || (Boolean)BlockConfig.glassConnectToTheirColorVariants.get() == false && ourFState.getColor() != otherFState.getColor();
        }
        return true;
    }

    @Override
    public int getBlockTint(@Nonnull IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (((Boolean)PersonalConfig.candyColors.get()).booleanValue()) {
            return ((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).func_193350_e();
        }
        return MapColor.func_193558_a((EnumDyeColor)((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a))).field_76291_p;
    }

    @Nullable
    public float[] getBeaconColorMultiplier(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockPos beaconPos) {
        if (((Boolean)PersonalConfig.candyColors.get()).booleanValue()) {
            return ((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a)).func_193349_f();
        }
        int colorValue = MapColor.func_193558_a((EnumDyeColor)((EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a))).field_76291_p;
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        return new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
    }

    @Override
    public BlockItemFusedQuartz createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemFusedQuartz(this));
    }

    @Nonnull
    public MapColor func_180659_g(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return MapColor.field_151660_b;
    }

    public static class BlockItemFusedQuartz
    extends BlockFusedQuartzBase.BlockItemFusedQuartzBase
    implements ITintedItem,
    PaintUtil.IWithPaintName {
        public BlockItemFusedQuartz(@Nonnull BlockFusedQuartz block) {
            super(block);
        }

        @Override
        public int getItemTint(@Nonnull ItemStack stack, int tintIndex) {
            return MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)stack.func_77960_j())).field_76291_p;
        }

        @Override
        public String getPaintName(@Nonnull ItemStack stack) {
            return EnderIO.lang.localize("color." + EnumDyeColor.func_176764_b((int)stack.func_77960_j()).func_176762_d());
        }
    }
}

