/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.task;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.util.Prep;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;

public class PoweredTask
implements IPoweredTask {
    @Nonnull
    public static final String KEY_INPUT_STACKS = "inputsStacks";
    @Nonnull
    public static final String KEY_RECIPE = "recipeUid";
    @Nonnull
    public static final String KEY_USED_ENERGY = "usedEnergy";
    @Nonnull
    public static final String KEY_CUSTOM_ENERGY = "customEnergy";
    @Nonnull
    private static final String KEY_SEED = "seed";
    @Nonnull
    private static final String KEY_CHANCE_OUTPUT = "chance1";
    @Nonnull
    private static final String KEY_CHANCE_MULTI = "chance2";
    private float usedEnergy = 0.0f;
    @Nonnull
    private NNList<MachineRecipeInput> inputs = new NNList();
    private float requiredEnergy;
    private boolean hasCustomEnergyCost = false;
    @Nonnull
    private RecipeBonusType bonusType;
    @Nonnull
    private IMachineRecipe recipe;
    private long nextSeed;
    private float outputMultiplier;
    private float chanceMultiplier;

    public PoweredTask(@Nonnull IMachineRecipe recipe, long nextSeed, @Nonnull NNList<MachineRecipeInput> inputs) {
        this(recipe, 0.0f, nextSeed, 1.0f, 1.0f, inputs);
    }

    public PoweredTask(@Nonnull IMachineRecipe recipe, long nextSeed, float outputMultiplier, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputs) {
        this(recipe, 0.0f, nextSeed, outputMultiplier, chanceMultiplier, inputs);
    }

    protected PoweredTask(@Nonnull IMachineRecipe recipe, float usedEnergy, long nextSeed, float outputMultiplier, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputsIn) {
        for (int i = 0; i < inputsIn.size(); ++i) {
            if (Prep.isValid(((MachineRecipeInput)inputsIn.get((int)i)).item)) {
                this.inputs.add((Object)new MachineRecipeInput(((MachineRecipeInput)inputsIn.get((int)i)).slotNumber, ((MachineRecipeInput)inputsIn.get((int)i)).item.func_77946_l()));
                continue;
            }
            if (((MachineRecipeInput)inputsIn.get((int)i)).fluid == null) continue;
            this.inputs.add((Object)new MachineRecipeInput(((MachineRecipeInput)inputsIn.get((int)i)).slotNumber, ((MachineRecipeInput)inputsIn.get((int)i)).fluid.copy()));
        }
        this.recipe = recipe;
        this.usedEnergy = usedEnergy;
        this.nextSeed = nextSeed;
        this.outputMultiplier = outputMultiplier;
        this.chanceMultiplier = chanceMultiplier;
        this.requiredEnergy = recipe.getEnergyRequired(inputsIn);
        this.bonusType = recipe.getBonusType(inputsIn);
    }

    @Override
    public void update(float availableEnergy) {
        this.usedEnergy += availableEnergy;
    }

    @Override
    public boolean isComplete() {
        return this.usedEnergy >= this.requiredEnergy;
    }

    @Override
    public float getProgress() {
        return MathHelper.func_76131_a((float)(this.usedEnergy / this.requiredEnergy), (float)0.0f, (float)1.0f);
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] getCompletedResult() {
        Random rand = new Random(this.nextSeed);
        NNList result = new NNList();
        result.addAll((Object[])this.recipe.getCompletedResult(rand.nextLong(), this.getBonusType().doChances() ? this.chanceMultiplier : 1.0f, this.inputs));
        if (this.getBonusType().doMultiply()) {
            for (float mul = this.outputMultiplier - 1.0f; mul > 0.0f; mul -= 1.0f) {
                if (!(rand.nextFloat() < mul)) continue;
                result.addAll((Object[])this.recipe.getCompletedResult(rand.nextLong(), this.getBonusType().doChances() ? this.chanceMultiplier : 1.0f, this.inputs));
            }
        }
        return (IMachineRecipe.ResultStack[])result.toArray((Object[])new IMachineRecipe.ResultStack[0]);
    }

    @Override
    @Nonnull
    public NNList<MachineRecipeInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(@Nonnull NNList<MachineRecipeInput> inputs) {
        this.inputs = inputs;
    }

    @Override
    public float getRequiredEnergy() {
        return this.requiredEnergy;
    }

    public void setRequiredEnergy(float requiredEnergy) {
        this.requiredEnergy = requiredEnergy;
        this.hasCustomEnergyCost = true;
    }

    @Override
    @Nonnull
    public RecipeBonusType getBonusType() {
        return this.bonusType;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagList inputItems = new NBTTagList();
        for (MachineRecipeInput ri : this.inputs) {
            NBTTagCompound stackRoot = new NBTTagCompound();
            ri.writeToNbt(stackRoot);
            inputItems.func_74742_a((NBTBase)stackRoot);
        }
        nbtRoot.func_74782_a(KEY_INPUT_STACKS, (NBTBase)inputItems);
        nbtRoot.func_74778_a(KEY_RECIPE, this.recipe.getUid());
        nbtRoot.func_74776_a(KEY_USED_ENERGY, this.usedEnergy);
        if (this.hasCustomEnergyCost) {
            nbtRoot.func_74776_a(KEY_CUSTOM_ENERGY, this.requiredEnergy);
        }
        nbtRoot.func_74772_a(KEY_SEED, this.nextSeed);
        nbtRoot.func_74776_a(KEY_CHANCE_OUTPUT, this.outputMultiplier);
        nbtRoot.func_74776_a(KEY_CHANCE_MULTI, this.chanceMultiplier);
    }

    @Nullable
    public static IPoweredTask readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        float usedEnergy = nbtRoot.func_74760_g(KEY_USED_ENERGY);
        long seed = nbtRoot.func_74763_f(KEY_SEED);
        float outputMultiplier = nbtRoot.func_74760_g(KEY_CHANCE_OUTPUT);
        float chanceMultiplier = nbtRoot.func_74760_g(KEY_CHANCE_MULTI);
        boolean hasCustomEnergyCost = false;
        float requiredEnergy = 0.0f;
        if (nbtRoot.func_74764_b(KEY_CUSTOM_ENERGY)) {
            hasCustomEnergyCost = true;
            requiredEnergy = nbtRoot.func_74760_g(KEY_CUSTOM_ENERGY);
        }
        NBTTagList inputItems = (NBTTagList)nbtRoot.func_74781_a(KEY_INPUT_STACKS);
        NNList ins = new NNList();
        for (int i = 0; i < inputItems.func_74745_c(); ++i) {
            NBTTagCompound stackTag = inputItems.func_150305_b(i);
            MachineRecipeInput mi = MachineRecipeInput.readFromNBT(stackTag);
            ins.add((Object)mi);
        }
        String uid = nbtRoot.func_74779_i(KEY_RECIPE);
        IMachineRecipe recipe = MachineRecipeRegistry.instance.getRecipeForUid(uid);
        if (recipe != null) {
            PoweredTask poweredTask = new PoweredTask(recipe, usedEnergy, seed, outputMultiplier, chanceMultiplier, (NNList<MachineRecipeInput>)ins);
            if (hasCustomEnergyCost) {
                poweredTask.setRequiredEnergy(requiredEnergy);
            }
            return poweredTask;
        }
        return null;
    }

    @Override
    public IMachineRecipe getRecipe() {
        return this.recipe;
    }
}

