/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit;

import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitItem;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.PacketOpenConduitUI;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.sound.IModSound;
import crazypants.enderio.base.sound.SoundHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConduitUtil {
    public static final Random RANDOM = new Random();

    public static void ensureValidNetwork(IServerConduit conduit) {
        block4: {
            try {
                TileEntity te = conduit.getBundle().getEntity();
                World world = te.func_145831_w();
                Collection<? extends IConduit> connections = ConduitUtil.getConnectedConduits(world, te.func_174877_v(), conduit.getBaseConduitType());
                if (ConduitUtil.reuseNetwork(conduit, connections, world)) {
                    return;
                }
                IConduitNetwork<?, ?> res = conduit.createNetworkForType();
                res.init(conduit.getBundle(), connections, world);
            }
            catch (UnloadedBlockException e) {
                IConduitNetwork<?, ?> networkToDestroy = e.getNetworkToDestroy();
                if (networkToDestroy == null) break block4;
                for (IConduit con : networkToDestroy.getConduits()) {
                    if (!(con instanceof IServerConduit)) continue;
                    ((IServerConduit)con).setNetworkBuildFailed();
                }
                networkToDestroy.destroyNetwork();
            }
        }
    }

    private static boolean reuseNetwork(IServerConduit con, Collection<? extends IServerConduit> connections, @Nonnull World world) {
        IConduitNetwork<?, ?> network = null;
        for (IServerConduit iServerConduit : connections) {
            if (network == null) {
                network = iServerConduit.getNetwork();
                continue;
            }
            if (network == iServerConduit.getNetwork()) continue;
            return false;
        }
        if (network == null) {
            return false;
        }
        if (con.setNetwork(network)) {
            network.addConduit(con);
            return true;
        }
        return false;
    }

    public static <T extends IServerConduit> void disconnectConduits(@Nonnull T con, @Nonnull EnumFacing connDir) {
        IConduitNetwork<?, ?> network;
        con.conduitConnectionRemoved(connDir);
        BlockPos pos = con.getBundle().getLocation().func_177972_a(connDir);
        IConduit neighbour = ConduitUtil.getConduit(con.getBundle().getEntity().func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), con.getBaseConduitType());
        if (neighbour instanceof IServerConduit) {
            ((IServerConduit)neighbour).conduitConnectionRemoved(connDir.func_176734_d());
            IConduitNetwork<?, ?> neighbourNetwork = ((IServerConduit)neighbour).getNetwork();
            if (neighbourNetwork != null) {
                neighbourNetwork.destroyNetwork();
            }
        }
        if ((network = con.getNetwork()) != null) {
            network.destroyNetwork();
        }
        con.connectionsChanged();
        if (neighbour instanceof IServerConduit) {
            ((IServerConduit)neighbour).connectionsChanged();
        }
    }

    public static <T extends IServerConduit> boolean connectConduits(@Nonnull T con, @Nonnull EnumFacing faceHit) {
        BlockPos pos = con.getBundle().getLocation().func_177972_a(faceHit);
        IConduit neighbour = ConduitUtil.getConduit(con.getBundle().getEntity().func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), con.getBaseConduitType());
        if (neighbour instanceof IServerConduit && con.canConnectToConduit(faceHit, neighbour) && ((IServerConduit)neighbour).canConnectToConduit(faceHit.func_176734_d(), con)) {
            IConduitNetwork<?, ?> neighbourNetwork;
            con.conduitConnectionAdded(faceHit);
            ((IServerConduit)neighbour).conduitConnectionAdded(faceHit.func_176734_d());
            IConduitNetwork<?, ?> network = con.getNetwork();
            if (network != null) {
                network.destroyNetwork();
            }
            if ((neighbourNetwork = ((IServerConduit)neighbour).getNetwork()) != null) {
                neighbourNetwork.destroyNetwork();
            }
            con.connectionsChanged();
            ((IServerConduit)neighbour).connectionsChanged();
            return true;
        }
        return false;
    }

    public static boolean forceSkylightRecalculation(@Nonnull World world, int xCoord, int yCoord, int zCoord) {
        return ConduitUtil.forceSkylightRecalculation(world, new BlockPos(xCoord, yCoord, zCoord));
    }

    public static boolean forceSkylightRecalculation(@Nonnull World world, @Nonnull BlockPos pos) {
        int height = world.func_175645_m(pos).func_177956_o();
        if (height <= pos.func_177956_o()) {
            for (int i = 1; i < 12; ++i) {
                BlockPos offset = pos.func_177967_a(EnumFacing.UP, i);
                if (!world.func_175623_d(offset)) continue;
                world.func_180501_a(offset, Blocks.field_150348_b.func_176223_P(), 3);
                world.func_175698_g(offset);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static IConduitBundle.FacadeRenderState getRequiredFacadeRenderState(@Nonnull IConduitBundle bundle, @Nonnull EntityPlayer player) {
        if (!bundle.hasFacade()) {
            return IConduitBundle.FacadeRenderState.NONE;
        }
        if (YetaUtil.isFacadeHidden(bundle, player)) {
            return IConduitBundle.FacadeRenderState.WIRE_FRAME;
        }
        return IConduitBundle.FacadeRenderState.FULL;
    }

    public static boolean isConduitEquipped(@Nullable EntityPlayer player) {
        return ConduitUtil.isConduitEquipped(player, EnumHand.MAIN_HAND);
    }

    public static boolean isConduitEquipped(@Nullable EntityPlayer player, @Nonnull EnumHand hand) {
        EntityPlayer entityPlayer = player = player == null ? EnderIO.proxy.getClientPlayer() : player;
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_184586_b(hand);
        return equipped.func_77973_b() instanceof IConduitItem;
    }

    public static boolean isProbeEquipped(@Nullable EntityPlayer player, @Nonnull EnumHand hand) {
        EntityPlayer entityPlayer = player = player == null ? EnderIO.proxy.getClientPlayer() : player;
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_184586_b(hand);
        return equipped.func_77973_b() == ModObject.itemConduitProbe.getItemNN();
    }

    @Deprecated
    public static <T extends IConduit> T getConduit(@Nonnull World world, int x, int y, int z, @Nonnull Class<T> type) {
        return ConduitUtil.getConduit(world, new BlockPos(x, y, z), type);
    }

    public static <T extends IConduit> T getConduit(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Class<T> type) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IConduitBundle) {
            IConduitBundle con = (IConduitBundle)te;
            return con.getConduit(type);
        }
        return null;
    }

    public static <T extends IConduit> T getConduit(@Nonnull World world, @Nonnull TileEntity te, @Nonnull EnumFacing dir, @Nonnull Class<T> type) {
        return ConduitUtil.getConduit(world, te.func_174877_v().func_177958_n() + dir.func_82601_c(), te.func_174877_v().func_177956_o() + dir.func_96559_d(), te.func_174877_v().func_177952_p() + dir.func_82599_e(), type);
    }

    public static <T extends IServerConduit> Collection<T> getConnectedConduits(@Nonnull World world, int x, int y, int z, @Nonnull Class<T> type) throws UnloadedBlockException {
        return ConduitUtil.getConnectedConduits(world, new BlockPos(x, y, z), type);
    }

    public static <T extends IServerConduit> Collection<T> getConnectedConduits(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Class<T> type) throws UnloadedBlockException {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return Collections.emptyList();
        }
        ArrayList<IServerConduit> result = new ArrayList<IServerConduit>();
        IConduitBundle root = (IConduitBundle)te;
        IServerConduit con = (IServerConduit)root.getConduit(type);
        if (con != null) {
            for (EnumFacing dir : con.getConduitConnections()) {
                if (dir == null) continue;
                if (!world.func_175667_e(pos.func_177972_a(dir))) {
                    throw new UnloadedBlockException(con.getNetwork());
                }
                IServerConduit connected = (IServerConduit)ConduitUtil.getConduit(world, root.getEntity(), dir, type);
                if (connected == null) continue;
                result.add(connected);
            }
        }
        return result;
    }

    public static void writeToNBT(IServerConduit conduit, @Nonnull NBTTagCompound conduitRoot) {
        if (conduit == null) {
            conduitRoot.func_74778_a("UUID", UUID.nameUUIDFromBytes("null".getBytes()).toString());
        } else {
            conduitRoot.func_74778_a("UUID", ConduitRegistry.get(conduit).getUUID().toString());
            conduit.writeToNBT(conduitRoot);
        }
    }

    public static IServerConduit readConduitFromNBT(@Nonnull NBTTagCompound conduitRoot) {
        if (conduitRoot.func_74764_b("UUID")) {
            String UUIDString = conduitRoot.func_74779_i("UUID");
            IServerConduit result = ConduitRegistry.getServerInstance(UUID.fromString(UUIDString));
            if (result != null) {
                result.readFromNBT(conduitRoot);
            }
            return result;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static IClientConduit readClientConduitFromNBT(@Nonnull NBTTagCompound conduitRoot) {
        if (conduitRoot.func_74764_b("UUID")) {
            String UUIDString = conduitRoot.func_74779_i("UUID");
            IClientConduit result = ConduitRegistry.getClientInstance(UUID.fromString(UUIDString));
            if (result != null) {
                result.readFromNBT(conduitRoot);
            }
            return result;
        }
        return null;
    }

    @Deprecated
    public static boolean isRedstoneControlModeMet(@Nonnull IServerConduit conduit, @Nonnull RedstoneControlMode mode, @Nonnull DyeColor col) {
        return mode != RedstoneControlMode.NEVER;
    }

    public static boolean isRedstoneControlModeMet(@Nonnull IServerConduit conduit, @Nonnull RedstoneControlMode mode, @Nonnull DyeColor col, @Nonnull EnumFacing dir) {
        if (mode == RedstoneControlMode.IGNORE) {
            return true;
        }
        if (mode == RedstoneControlMode.NEVER) {
            return false;
        }
        int signalStrength = conduit.getBundle().getInternalRedstoneSignalForColor(col, dir);
        if (signalStrength < 1 && DyeColor.RED == col) {
            signalStrength = Math.max(signalStrength, conduit.getExternalRedstoneLevel());
        }
        return RedstoneControlMode.isConditionMet(mode, signalStrength);
    }

    public static int isBlockIndirectlyGettingPoweredIfLoaded(@Nonnull World world, @Nonnull BlockPos pos) {
        int i = 0;
        for (EnumFacing enumfacing : NNList.FACING) {
            BlockPos offset = pos.func_177972_a(enumfacing);
            if (!world.func_175667_e(offset)) continue;
            int j = world.func_175651_c(offset, enumfacing);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static boolean isFluidValid(FluidStack fluidStack) {
        String name;
        return fluidStack != null && (name = FluidRegistry.getFluidName((FluidStack)fluidStack)) != null && !name.trim().isEmpty();
    }

    public static void openConduitGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        ConduitUtil.openConduitGui(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player);
    }

    public static void openConduitGui(@Nonnull World world, int x, int y, int z, @Nonnull EntityPlayer player) {
        EnumFacing facing;
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle cb = (IConduitBundle)te;
        HashSet<EnumFacing> cons = new HashSet<EnumFacing>();
        boolean conduitConnections = false;
        boolean hasInsulated = false;
        for (IClientConduit con : cb.getClientConduits()) {
            cons.addAll(con.getExternalConnections());
            if (ConduitRegistry.getNetwork(con).canConnectToAnything()) {
                hasInsulated = true;
            }
            conduitConnections = conduitConnections || con.hasConduitConnections();
        }
        if (cons.isEmpty() && !hasInsulated && !conduitConnections) {
            return;
        }
        if (cons.size() == 1 && (facing = (EnumFacing)cons.iterator().next()) != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenConduitUI(te, facing));
            return;
        }
        ConduitRegistry.getConduitModObjectNN().openClientGui(world, new BlockPos(x, y, z), player, null, 0);
    }

    public static void playBreakSound(@Nonnull SoundType snd, @Nonnull World world, @Nonnull BlockPos pos) {
        SoundHelper.playSound(world, pos, (IModSound)new Sound(snd.func_185845_c()), (snd.func_185843_a() + 1.0f) / 2.0f, snd.func_185847_b() * 0.8f);
    }

    public static void playHitSound(@Nonnull SoundType snd, @Nonnull World world, @Nonnull BlockPos pos) {
        SoundHelper.playSound(world, pos, (IModSound)new Sound(snd.func_185846_f()), (snd.func_185843_a() + 1.0f) / 2.0f, snd.func_185847_b() * 0.8f);
    }

    public static void playStepSound(@Nonnull SoundType snd, @Nonnull World world, @Nonnull BlockPos pos) {
        SoundHelper.playSound(world, pos, (IModSound)new Sound(snd.func_185844_d()), (snd.func_185843_a() + 1.0f) / 2.0f, snd.func_185847_b() * 0.8f);
    }

    public static void playPlaceSound(@Nonnull SoundType snd, @Nonnull World world, @Nonnull BlockPos pos) {
        SoundHelper.playSound(world, pos, (IModSound)new Sound(snd.func_185841_e()), (snd.func_185843_a() + 1.0f) / 2.0f, snd.func_185847_b() * 0.8f);
    }

    private static class Sound
    implements IModSound {
        @Nonnull
        private final SoundEvent event;

        public Sound(@Nonnull SoundEvent event) {
            this.event = event;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @Nonnull
        public SoundEvent getSoundEvent() {
            return this.event;
        }

        @Override
        @Nonnull
        public SoundCategory getSoundCategory() {
            return SoundCategory.BLOCKS;
        }
    }

    public static class UnloadedBlockException
    extends Exception {
        private static final long serialVersionUID = 2130974035860715939L;
        private IConduitNetwork<?, ?> networkToDestroy;

        public IConduitNetwork<?, ?> getNetworkToDestroy() {
            return this.networkToDestroy;
        }

        public UnloadedBlockException(IConduitNetwork<?, ?> networkToDestroy) {
            this.networkToDestroy = networkToDestroy;
        }
    }
}

