/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;

public class BlockCoord {
    private BlockCoord() {
    }

    @Nonnull
    public static BlockPos get(TileEntity tile) {
        return BlockCoord.get(tile.func_174877_v());
    }

    @Nonnull
    public static BlockPos get(Entity e) {
        return BlockCoord.get(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    @Nonnull
    public static BlockPos get(BlockPos bc) {
        return BlockCoord.get(bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p());
    }

    @Nonnull
    public static BlockPos get(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @Nonnull
    private static BlockPos get(double x, double y, double z) {
        return BlockCoord.get((int)x, (int)y, (int)z);
    }

    @Nonnull
    public static BlockPos get(String x, String y, String z) {
        return BlockCoord.get(Strings.isNullOrEmpty((String)x) ? 0 : Integer.parseInt(x), Strings.isNullOrEmpty((String)y) ? 0 : Integer.parseInt(y), Strings.isNullOrEmpty((String)z) ? 0 : Integer.parseInt(z));
    }

    @Nonnull
    public static BlockPos get(RayTraceResult mop) {
        return BlockCoord.get(mop.func_178782_a());
    }

    public static int getDistSq(BlockPos a, BlockPos b) {
        int xDiff = a.func_177958_n() - b.func_177958_n();
        int yDiff = a.func_177956_o() - b.func_177956_o();
        int zDiff = a.func_177952_p() - b.func_177952_p();
        return xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
    }

    public static int getDistSq(BlockPos a, TileEntity other) {
        return BlockCoord.getDistSq(a, BlockCoord.get(other));
    }

    public static int getDist(BlockPos a, BlockPos b) {
        double dsq = BlockCoord.getDistSq(a, b);
        return (int)Math.ceil(Math.sqrt(dsq));
    }

    public static int getDist(BlockPos a, TileEntity other) {
        return BlockCoord.getDist(a, BlockCoord.get(other));
    }

    @Nonnull
    public static String chatString(BlockPos pos, TextFormatting defaultColor) {
        return String.format("x%s%d%s y%s%d%s z%s%d", TextFormatting.GREEN, pos.func_177958_n(), defaultColor, TextFormatting.GREEN, pos.func_177956_o(), defaultColor, TextFormatting.GREEN, pos.func_177952_p());
    }

    @Nonnull
    public static BlockPos withX(BlockPos pos, int x) {
        return pos.func_177958_n() == x ? pos : BlockCoord.get(x, pos.func_177956_o(), pos.func_177952_p());
    }

    @Nonnull
    public static BlockPos withY(BlockPos pos, int y) {
        return pos.func_177956_o() == y ? pos : BlockCoord.get(pos.func_177958_n(), y, pos.func_177952_p());
    }

    @Nonnull
    public static BlockPos withZ(BlockPos pos, int z) {
        return pos.func_177952_p() == z ? pos : BlockCoord.get(pos.func_177958_n(), pos.func_177956_o(), z);
    }
}

